/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.publish;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.credentials.P4CredentialsImpl;
import org.jenkinsci.plugins.p4.publish.Publish;
import org.jenkinsci.plugins.p4.tasks.PublishTask;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PublishNotifier
extends Notifier {
    private static Logger logger = Logger.getLogger(PublishNotifier.class.getName());
    private final String credential;
    private final Workspace workspace;
    private final Publish publish;

    public String getCredential() {
        return this.credential;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Publish getPublish() {
        return this.publish;
    }

    @DataBoundConstructor
    public PublishNotifier(String credential, Workspace workspace, Publish publish) {
        this.credential = credential;
        this.workspace = workspace;
        this.publish = publish;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.getPublish().isOnlyOnSuccess() && build.getResult() != Result.SUCCESS) {
            return true;
        }
        FilePath buildWorkspace = build.getWorkspace();
        if (buildWorkspace == null) {
            logger.warning("FilePath is null!");
            return false;
        }
        Workspace ws = this.getWorkspace().deepClone();
        PublishTask task = new PublishTask(this.getCredential(), (Run<?, ?>)build, (TaskListener)listener, this.getPublish());
        ws = task.setEnvironment((Run<?, ?>)build, ws, buildWorkspace);
        task.setWorkspace(ws);
        String desc = this.getPublish().getDescription();
        desc = ws.getExpand().format(desc, false);
        this.getPublish().setExpandedDesc(desc);
        boolean success = (Boolean)buildWorkspace.act((FilePath.FileCallable)task);
        return success;
    }

    public static DescriptorImpl descriptor() {
        Jenkins j = Jenkins.getInstance();
        if (j != null) {
            j.getDescriptorByType(DescriptorImpl.class);
        }
        return null;
    }

    @Extension
    @Symbol(value={"publish"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Perforce: Publish assets";
        }

        public ListBoxModel doFillCredentialItems(@AncestorInPath Item project, @QueryParameter String credential) {
            return P4CredentialsImpl.doFillCredentialItems(project, credential);
        }
    }
}

