/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.groovy;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.credentials.P4CredentialsImpl;
import org.jenkinsci.plugins.p4.groovy.GetP4;
import org.jenkinsci.plugins.p4.groovy.P4Groovy;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GetP4Step
extends Step {
    private final String credential;
    private final Workspace workspace;

    public String getCredential() {
        return this.credential;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    @DataBoundConstructor
    public GetP4Step(String credential, Workspace workspace) {
        this.credential = credential;
        this.workspace = workspace;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<P4Groovy> {
        private static final long serialVersionUID = 1L;
        private final transient GetP4Step step;

        Execution(GetP4Step step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected P4Groovy run() throws Exception {
            GetP4 p4Groovy = new GetP4(this.step.getCredential(), this.step.getWorkspace());
            p4Groovy.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return p4Groovy.getP4Groovy();
        }
    }

    @Extension(optional=true)
    @Symbol(value={"p4groovy"})
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "p4";
        }

        public String getDisplayName() {
            return "P4 Groovy";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }

        public ListBoxModel doFillCredentialItems(@AncestorInPath Item project, @QueryParameter String credential) {
            return P4CredentialsImpl.doFillCredentialItems(project, credential);
        }
    }
}

