/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.credentials;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class TicketModeImpl
extends AbstractDescribableImpl<TicketModeImpl>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String value;
    @NonNull
    private final Secret ticketSecret;
    @Deprecated
    private final String ticketValue;
    @NonNull
    private final String ticketPath;

    @DataBoundConstructor
    public TicketModeImpl(String value, String ticketValue, String ticketPath) {
        this.value = value;
        this.ticketValue = "";
        this.ticketSecret = Secret.fromString((String)ticketValue);
        this.ticketPath = ticketPath != null ? ticketPath : "";
    }

    public String getValue() {
        return this.value;
    }

    public String getTicketValue() {
        if (this.ticketSecret != null && !this.getTicketSecret().isEmpty()) {
            return this.getTicketSecret();
        }
        return this.ticketValue;
    }

    public String getTicketSecret() {
        return this.ticketSecret.getPlainText();
    }

    public String getTicketPath() {
        return this.ticketPath;
    }

    public boolean isTicketValueSet() {
        return !StringUtils.isEmpty((String)this.getTicketValue());
    }

    public boolean isTicketPathSet() {
        return !StringUtils.isEmpty((String)this.getTicketPath());
    }

    @Extension
    @Symbol(value={"ticketMode"})
    public static class DescriptorImpl
    extends Descriptor<TicketModeImpl> {
        public String getDisplayName() {
            return "TicketMode";
        }
    }
}

