/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import javax.servlet.ServletException;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.client.ConnectionConfig;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.credentials.P4Password;
import org.jenkinsci.plugins.p4.credentials.TrustImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class P4PasswordImpl
extends P4BaseCredentials
implements P4Password {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final Secret password;
    private boolean allhosts;

    @DataBoundConstructor
    public P4PasswordImpl(CredentialsScope scope, String id, String description, @NonNull String p4port, TrustImpl ssl, @NonNull String username, @CheckForNull String retry, @CheckForNull String timeout, @CheckForNull String p4host, @NonNull String password) {
        super(scope, id, description, p4port, ssl, username, retry, timeout, p4host);
        this.password = Secret.fromString((String)password);
    }

    @DataBoundSetter
    public void setAllhosts(boolean allhosts) {
        this.allhosts = allhosts;
    }

    public Secret getPassword() {
        return this.password;
    }

    public boolean isAllhosts() {
        return this.allhosts;
    }

    @Extension
    @Symbol(value={"password"})
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Perforce Password Credential";
        }

        public FormValidation doCheckP4port(@QueryParameter String value) {
            if (value != null && value.startsWith("ssl:")) {
                return FormValidation.error((String)"Do not prefix P4PORT with 'ssl:', use the SSL checkbox.");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter(value="p4port") String p4port, @QueryParameter(value="ssl") String ssl, @QueryParameter(value="trust") String trust, @QueryParameter(value="p4host") String p4host, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="allhosts") boolean allhosts) throws IOException, ServletException {
            try {
                TrustImpl sslTrust = "true".equals(ssl) ? new TrustImpl(trust) : null;
                P4PasswordImpl test = new P4PasswordImpl(null, null, null, p4port, sslTrust, username, null, null, p4host, password);
                test.setAllhosts(allhosts);
                ConnectionConfig config = new ConnectionConfig(test);
                FormValidation validation = ConnectionFactory.testConnection(config);
                if (!FormValidation.ok().equals(validation)) {
                    return validation;
                }
                ConnectionHelper p4 = new ConnectionHelper(test);
                if (!p4.isConnected()) {
                    return FormValidation.error((String)"Server Connection Error.");
                }
                p4.logout();
                try {
                    if (!p4.login()) {
                        return FormValidation.error((String)"Authentication Error: Unable to login.");
                    }
                }
                catch (Exception e) {
                    return FormValidation.error((String)("Authentication Error: " + e.getMessage()));
                }
                if (!p4.checkVersion(20121)) {
                    return FormValidation.error((String)"Server version is too old (min 2012.1)");
                }
                return FormValidation.ok((String)"Success");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Connection Error: " + e.getMessage()));
            }
        }
    }
}

