/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import hudson.AbortException;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class Validate {
    private static Logger logger = Logger.getLogger(Validate.class.getName());
    private final TaskListener listener;

    public Validate(TaskListener listener) {
        this.listener = listener;
    }

    public boolean check(List<IFileSpec> fileSpecs, String ... ignore) throws Exception {
        return this.check(fileSpecs, true, ignore);
    }

    public boolean checkCatch(List<IFileSpec> fileSpecs, String ... ignore) {
        try {
            return this.check(fileSpecs, true, ignore);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean check(List<IFileSpec> fileSpecs, boolean quiet, String ... ignore) throws Exception {
        boolean success = true;
        boolean abort = false;
        StringBuffer errorLog = new StringBuffer();
        ArrayList<String> ignoreList = new ArrayList<String>();
        ignoreList.addAll(Arrays.asList(ignore));
        for (IFileSpec fileSpec : fileSpecs) {
            FileSpecOpStatus status = fileSpec.getOpStatus();
            if (status == FileSpecOpStatus.VALID) continue;
            String msg = fileSpec.getStatusMessage();
            boolean unknownMsg = true;
            for (String istring : ignoreList) {
                if (istring.isEmpty() || !StringUtils.containsIgnoreCase((String)msg, (String)istring)) continue;
                unknownMsg = false;
                break;
            }
            if (!unknownMsg) continue;
            if (!quiet) {
                msg = "P4JAVA: " + msg;
                this.log(msg);
                logger.warning(msg);
            }
            if (status == FileSpecOpStatus.ERROR || status == FileSpecOpStatus.CLIENT_ERROR) {
                errorLog.append(msg);
                errorLog.append("\n");
                abort = true;
            }
            success = false;
        }
        if (abort) {
            String msg = "P4JAVA: Error(s):\n" + errorLog.toString();
            throw new AbortException(msg);
        }
        return success;
    }

    public void log(String msg) {
        if (this.listener == null) {
            return;
        }
        this.listener.getLogger().println(msg);
    }
}

