/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.ServerFactory;
import hudson.util.FormValidation;
import java.util.Properties;
import java.util.logging.Logger;
import org.jenkinsci.plugins.p4.client.ConnectionConfig;
import org.jenkinsci.plugins.p4.client.Identifier;

public class ConnectionFactory {
    private static Logger logger = Logger.getLogger(ConnectionFactory.class.getName());
    private static IOptionsServer currentP4;

    public static IOptionsServer getConnection() {
        return currentP4;
    }

    public static IOptionsServer getConnection(ConnectionConfig config) throws Exception {
        IOptionsServer iserver = ConnectionFactory.getRawConnection(config);
        try {
            iserver.connect();
        }
        catch (ConnectionException e) {
            if (config.isSsl()) {
                ConnectionFactory.addTrust(iserver, config);
                iserver.connect();
            }
            throw e;
        }
        currentP4 = iserver;
        return iserver;
    }

    private static void addTrust(IOptionsServer iserver, ConnectionConfig config) throws P4JavaException {
        String serverTrust = iserver.getTrust();
        if (!serverTrust.equalsIgnoreCase(config.getTrust())) {
            logger.warning("Trust mismatch! Server fingerprint: " + serverTrust);
        } else {
            iserver.addTrust(config.getTrust());
            logger.fine("addTrust - ok: " + config.getTrust());
        }
    }

    public static FormValidation testConnection(ConnectionConfig config) {
        try {
            IOptionsServer iserver = ConnectionFactory.getRawConnection(config);
            if (config.isSsl()) {
                String serverTrust = iserver.getTrust();
                if (!serverTrust.equalsIgnoreCase(config.getTrust())) {
                    return FormValidation.error((String)("Trust mismatch! Server fingerprint: " + serverTrust));
                }
                iserver.addTrust(config.getTrust());
            }
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append("Unable to connect to: ");
            sb.append(config.getServerUri());
            sb.append("\n");
            sb.append(e.getMessage());
            return FormValidation.error((String)sb.toString());
        }
        return FormValidation.ok();
    }

    private static IOptionsServer getRawConnection(ConnectionConfig config) throws Exception {
        Properties props = System.getProperties();
        Identifier id = new Identifier();
        props.put("com.perforce.p4java.programName", id.getProduct());
        props.put("com.perforce.p4java.programVersion", id.getVersion());
        props.put("relaxCmdNameChecks", "true");
        String timeout = String.valueOf(config.getTimeout());
        props.put("sockSoTimeout", timeout);
        props.put("enableGraph", "true");
        props.put("expandAndmaps", "true");
        UsageOptions opts = new UsageOptions(props);
        String p4host = config.getP4Host();
        if (p4host != null && !p4host.isEmpty()) {
            opts.setHostName(p4host);
        }
        String serverUri = config.getServerUri();
        IOptionsServer iserver = ServerFactory.getOptionsServer((String)serverUri, (Properties)props, (UsageOptions)opts);
        return iserver;
    }
}

