/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.client;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IRepo;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.option.changelist.SubmitOptions;
import com.perforce.p4java.option.client.AddFilesOptions;
import com.perforce.p4java.option.client.ParallelSyncOptions;
import com.perforce.p4java.option.client.ReconcileFilesOptions;
import com.perforce.p4java.option.client.ReopenFilesOptions;
import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.p4java.option.client.RevertFilesOptions;
import com.perforce.p4java.option.client.SyncOptions;
import com.perforce.p4java.option.server.ChangelistOptions;
import com.perforce.p4java.option.server.GetChangelistsOptions;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.p4java.server.callback.IStreamingCallback;
import hudson.AbortException;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.p4.changes.P4ChangeRef;
import org.jenkinsci.plugins.p4.changes.P4GraphRef;
import org.jenkinsci.plugins.p4.changes.P4LabelRef;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.client.ReconcileStreamingCallback;
import org.jenkinsci.plugins.p4.client.SubmitStreamingCallback;
import org.jenkinsci.plugins.p4.client.SyncStreamingCallback;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.populate.AutoCleanImpl;
import org.jenkinsci.plugins.p4.populate.CheckOnlyImpl;
import org.jenkinsci.plugins.p4.populate.FlushOnlyImpl;
import org.jenkinsci.plugins.p4.populate.ForceCleanImpl;
import org.jenkinsci.plugins.p4.populate.GraphHybridImpl;
import org.jenkinsci.plugins.p4.populate.ParallelSync;
import org.jenkinsci.plugins.p4.populate.Populate;
import org.jenkinsci.plugins.p4.populate.SyncOnlyImpl;
import org.jenkinsci.plugins.p4.publish.CommitImpl;
import org.jenkinsci.plugins.p4.publish.Publish;
import org.jenkinsci.plugins.p4.publish.ShelveImpl;
import org.jenkinsci.plugins.p4.publish.SubmitImpl;
import org.jenkinsci.plugins.p4.tasks.TimeTask;
import org.jenkinsci.plugins.p4.workspace.StaticWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.TemplateWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;

public class ClientHelper
extends ConnectionHelper {
    private static Logger logger = Logger.getLogger(ClientHelper.class.getName());
    private IClient iclient;

    public ClientHelper(ItemGroup context, String credential, TaskListener listener, Workspace workspace) throws IOException {
        super(context, credential, listener);
        this.clientLogin(workspace);
    }

    public ClientHelper(Item context, String credential, TaskListener listener, Workspace workspace) throws IOException {
        super(context, credential, listener);
        this.clientLogin(workspace);
    }

    public ClientHelper(P4BaseCredentials credential, TaskListener listener, Workspace workspace) throws IOException {
        super(credential, listener);
        this.clientLogin(workspace);
    }

    protected ClientHelper(Item context, String credential, TaskListener listener) throws IOException {
        super(context, credential, listener);
    }

    protected void clientLogin(Workspace workspace) throws AbortException {
        if (this.getConnection() == null) {
            return;
        }
        try {
            String serverId;
            if (this.isUnicode()) {
                this.getConnection().setCharsetName(workspace.getCharset());
            }
            this.login();
            this.iclient = workspace.setClient(this.getConnection(), this.getAuthorisationConfig().getUsername());
            if (!this.isClientValid(workspace)) {
                String err = "P4: Undefined workspace: " + workspace.getFullName();
                throw new AbortException(err);
            }
            this.getConnection().setCurrentClient(this.iclient);
            if (workspace instanceof StaticWorkspaceImpl) {
                return;
            }
            if (workspace.getRootPath() != null) {
                this.iclient.setRoot(workspace.getRootPath());
            }
            if (workspace.getHostName() != null) {
                this.iclient.setHostName(workspace.getHostName());
            }
            if ((serverId = this.iclient.getServerId()) == null || serverId.isEmpty()) {
                IServerInfo info = this.getConnection().getServerInfo();
                String services = this.getServerServices();
                serverId = info.getServerId();
                if (serverId != null && !serverId.isEmpty() && this.isEdgeType(services)) {
                    this.iclient.setServerId(serverId);
                }
            }
            this.updateClient();
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            String err = "P4: Unable to setup workspace: " + writer.toString();
            logger.severe(err);
            this.log(err);
            throw new AbortException(e.getMessage());
        }
    }

    private void updateClient() throws Exception {
        String clientName = this.iclient.getName();
        IClient original = this.getConnection().getClient(clientName);
        if (this.diffClient(original, this.iclient)) {
            return;
        }
        this.iclient.update();
        ClientView clientView = this.iclient.getClientView();
        if (clientView != null) {
            StringBuffer sb = new StringBuffer("...   View:\n");
            for (IClientViewMapping view : clientView) {
                sb.append("      ");
                if (view.getType() != null) {
                    sb.append(view.getType().toString());
                }
                sb.append(view.getLeft());
                sb.append(" ");
                sb.append(view.getRight());
                sb.append("\n");
            }
            if (this.iclient.getStream() != null) {
                sb.append("...   Stream: " + this.iclient.getStream());
                sb.append("\n");
            }
            sb.append("...   Root: " + this.iclient.getRoot());
            sb.append("\n");
            logger.finer(sb.toString());
            sb.insert(0, "(p4):cmd:");
            sb.append("(p4):stop:");
            this.log(sb.toString());
        }
    }

    private boolean diffClient(IClient a, IClient b) {
        if (a == null || b == null) {
            return false;
        }
        Map mapA = InputMapper.map((IClient)a);
        List<String> valuesA = this.cleanMap(mapA);
        Map mapB = InputMapper.map((IClient)b);
        List<String> valuesB = this.cleanMap(mapB);
        return valuesA.equals(valuesB);
    }

    private List<String> cleanMap(Map<String, Object> map) {
        String[] set;
        String[] unset;
        for (String key : unset = new String[]{"Host", "Stream"}) {
            if (!"".equals(map.get(key))) continue;
            map.remove(key);
        }
        for (String key : set = new String[]{"Type"}) {
            map.remove(key);
        }
        ArrayList<Object> values = new ArrayList<Object>(map.values());
        values.removeAll(Collections.singleton(null));
        values.removeAll(Collections.singleton(""));
        Collections.sort(values);
        return values;
    }

    private boolean isEdgeType(String services) {
        if (services == null || services.isEmpty()) {
            return false;
        }
        if (services.contains("edge-server")) {
            return true;
        }
        if (services.contains("workspace-server")) {
            return true;
        }
        return services.contains("build-server");
    }

    private String getServerServices() throws ConnectionException, AccessException {
        List mapList = this.getConnection().execMapCmdList(CmdSpec.INFO, new String[0], null);
        for (Map map : mapList) {
            if (!map.containsKey("serverServices")) continue;
            return (String)map.get("serverServices");
        }
        return "";
    }

    public void syncFiles(P4Ref buildChange, Populate populate) throws Exception {
        TimeTask timer = new TimeTask();
        if (buildChange.isLabel()) {
            String label = buildChange.toString();
            try {
                int change = Integer.parseInt(label);
                this.log("P4 Task: label is a number! syncing files at change: " + change);
            }
            catch (NumberFormatException e) {
                if (!(label.equals("now") || this.isLabel(label) || this.isClient(label) || this.isCounter(label))) {
                    String msg = "P4: Unable to find client/label/counter: " + label;
                    this.log(msg);
                    logger.warning(msg);
                    throw new AbortException(msg);
                }
                this.log("P4 Task: syncing files at client/label: " + label);
            }
        } else {
            this.log("P4 Task: syncing files at change: " + buildChange);
        }
        if (buildChange instanceof P4ChangeRef || buildChange instanceof P4LabelRef) {
            String path = this.iclient.getRoot() + "/...";
            String revisions = path + "@" + buildChange;
            if (populate instanceof CheckOnlyImpl) {
                this.syncPreview(revisions, populate);
            } else if (populate instanceof FlushOnlyImpl) {
                this.syncHaveList(revisions, populate);
            } else {
                this.syncFiles(revisions, populate);
            }
        }
        if (buildChange instanceof P4GraphRef && populate instanceof GraphHybridImpl) {
            String rev = ((P4GraphRef)buildChange).getRepo() + "/...";
            this.syncFiles(rev, populate);
        }
        this.log("duration: " + timer.toString() + "\n");
    }

    private void syncPreview(String revisions, Populate populate) throws Exception {
        SyncOptions syncOpts = new SyncOptions();
        syncOpts.setNoUpdate(true);
        if (populate.isQuiet()) {
            this.log("P4 Task: skipping sync.");
            return;
        }
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{revisions});
        List syncMsg = this.iclient.sync(files, syncOpts);
        this.getValidate().check((List<IFileSpec>)syncMsg, "file(s) up-to-date.", "file does not exist", "no file(s) as of that date");
    }

    private void syncHaveList(String revisions, Populate populate) throws Exception {
        SyncOptions syncOpts = new SyncOptions();
        syncOpts.setClientBypass(true);
        syncOpts.setQuiet(populate.isQuiet());
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{revisions});
        List syncMsg = this.iclient.sync(files, syncOpts);
        this.getValidate().check((List<IFileSpec>)syncMsg, "file(s) up-to-date.", "file does not exist", "no file(s) as of that date");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFiles(String revisions, Populate populate) throws Exception {
        SyncStreamingCallback callback;
        IClientSummary.IClientOptions options;
        if (populate.isModtime() && !this.checkVersion(20151) && !(options = this.iclient.getOptions()).isModtime()) {
            options.setModtime(true);
            this.iclient.setOptions(options);
            this.updateClient();
        }
        SyncOptions syncOpts = new SyncOptions();
        syncOpts.setServerBypass(!populate.isHave());
        syncOpts.setForceUpdate(populate.isForce() && populate.isHave());
        syncOpts.setQuiet(populate.isQuiet());
        SyncStreamingCallback syncStreamingCallback = callback = new SyncStreamingCallback(this.iclient.getServer(), this.getListener());
        synchronized (syncStreamingCallback) {
            List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{revisions});
            ParallelSync parallel = populate.getParallel();
            if (parallel != null && parallel.isEnable()) {
                ParallelSyncOptions parallelOpts = parallel.getParallelOptions();
                this.iclient.syncParallel(files, syncOpts, (IStreamingCallback)callback, 0, parallelOpts);
            } else {
                this.iclient.sync(files, syncOpts, (IStreamingCallback)callback, 0);
            }
            while (!callback.isDone()) {
                callback.wait();
            }
            if (callback.isFail()) {
                throw new P4JavaException((Throwable)callback.getException());
            }
        }
    }

    public void tidyWorkspace(Populate populate) throws Exception {
        this.log("");
        String path = this.iclient.getRoot() + "/...";
        if (populate instanceof AutoCleanImpl) {
            this.tidyAutoCleanImpl(path, populate);
        }
        if (populate instanceof ForceCleanImpl) {
            this.tidyForceSyncImpl(path, populate);
        }
        if (populate instanceof GraphHybridImpl) {
            this.tidyForceSyncImpl(path, populate);
        }
        if (populate instanceof SyncOnlyImpl) {
            this.tidySyncOnlyImpl(path, populate);
        }
    }

    private void tidySyncOnlyImpl(String path, Populate populate) throws Exception {
        SyncOnlyImpl syncOnly = (SyncOnlyImpl)populate;
        if (syncOnly.isRevert()) {
            this.tidyPending(path);
        }
    }

    private void tidyForceSyncImpl(String path, Populate populate) throws Exception {
        this.tidyPending(path);
        String revisions = this.iclient.getRoot() + "/...#0";
        boolean quiet = populate.isQuiet();
        AutoCleanImpl clean = new AutoCleanImpl(false, false, false, false, quiet, null, null);
        this.syncFiles(revisions, (Populate)clean);
        String root = URLDecoder.decode(this.iclient.getRoot(), "UTF-8");
        this.log("... rm -rf " + root);
        this.log("");
        this.silentlyForceDelete(root);
    }

    private void silentlyForceDelete(String root) throws IOException {
        try {
            FileUtils.forceDelete((File)new File(root));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void tidyAutoCleanImpl(String path, Populate populate) throws Exception {
        this.tidyPending(path);
        this.tidyClean(populate, path);
    }

    private void tidyPending(String path) throws Exception {
        TimeTask timer = new TimeTask();
        this.log("P4 Task: reverting all pending and shelved revisions.");
        RevertFilesOptions rOpts = new RevertFilesOptions();
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{path});
        List list = this.iclient.revertFiles(files, rOpts);
        this.getValidate().check((List<IFileSpec>)list, "not opened on this client", "Replica does not support this command");
        this.log("... rm [abandoned files]");
        for (IFileSpec file : list) {
            File unlink;
            boolean ok;
            if (file.getAction() != FileAction.ABANDONED) continue;
            String local = file.getLocalPathString();
            if (local == null) {
                local = this.depotToLocal(file);
            }
            if (local == null || (ok = (unlink = new File(local)).delete())) continue;
            this.log("Not able to delete: " + local);
        }
        this.log("duration: " + timer.toString() + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tidyClean(Populate populate, String path) throws Exception {
        ReconcileStreamingCallback callback;
        if (!this.checkVersion(20141)) {
            this.tidyRevisions(path, populate);
            return;
        }
        boolean delete = ((AutoCleanImpl)populate).isDelete();
        boolean replace = ((AutoCleanImpl)populate).isReplace();
        ReconcileFilesOptions cleanOpts = new ReconcileFilesOptions();
        cleanOpts.setUpdateWorkspace(true);
        cleanOpts.setUseWildcards(true);
        if (delete && !replace) {
            cleanOpts.setOutsideAdd(true);
        }
        if (replace && !delete) {
            cleanOpts.setOutsideEdit(true);
            cleanOpts.setRemoved(true);
        }
        if (!replace && !delete) {
            this.log("P4 Task: skipping clean, no options set.");
            return;
        }
        if (populate.isModtime()) {
            if (this.checkVersion(20141)) {
                cleanOpts.setCheckModTime(true);
            } else {
                this.log("P4: Resolving files by MODTIME not supported (requires 2014.1 or above)");
            }
        }
        TimeTask timer = new TimeTask();
        this.log("P4 Task: cleaning workspace to match have list.");
        ReconcileStreamingCallback reconcileStreamingCallback = callback = new ReconcileStreamingCallback(this.iclient.getServer(), this.getListener());
        synchronized (reconcileStreamingCallback) {
            List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{path});
            this.iclient.reconcileFiles(files, cleanOpts, (IStreamingCallback)callback, 0);
            while (!callback.isDone()) {
                callback.wait();
            }
            if (callback.isFail()) {
                throw new P4JavaException((Throwable)callback.getException());
            }
        }
        this.log("duration: " + timer.toString() + "\n");
    }

    private void tidyRevisions(String path, Populate populate) throws Exception {
        TimeTask timer = new TimeTask();
        this.log("P4 Task: tidying workspace to match have list.");
        boolean delete = ((AutoCleanImpl)populate).isDelete();
        boolean replace = ((AutoCleanImpl)populate).isReplace();
        String[] base = new String[]{"-n", "-a", "-e", "-d", "-l", "-f"};
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(base));
        String[] args = list.toArray(new String[list.size()]);
        ReconcileFilesOptions statusOpts = new ReconcileFilesOptions(args);
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{path});
        List status = this.iclient.reconcileFiles(files, statusOpts);
        this.getValidate().check((List<IFileSpec>)status, "also opened by", "no file(s) to reconcile", "must sync/resolve", "exclusive file already opened", "cannot submit from stream", "instead of", "empty, assuming text");
        ArrayList<Object> update = new ArrayList<Object>();
        block3: for (IFileSpec s : status) {
            if (s.getOpStatus() == FileSpecOpStatus.VALID) {
                String local = s.getLocalPathString();
                if (local == null) {
                    local = this.depotToLocal(s);
                }
                switch (s.getAction()) {
                    case ADD: {
                        File unlink;
                        boolean ok;
                        if (local == null || !delete || (ok = (unlink = new File(local)).delete())) continue block3;
                        this.log("Not able to delete: " + local);
                        break;
                    }
                    default: {
                        update.add(s);
                    }
                }
                continue;
            }
            String msg = s.getStatusMessage();
            if (!msg.contains("exclusive file already opened")) continue;
            String rev = msg.substring(0, msg.indexOf(" - can't "));
            FileSpec spec = new FileSpec(rev);
            update.add(spec);
        }
        if (!update.isEmpty() && replace) {
            SyncOptions syncOpts = new SyncOptions();
            syncOpts.setForceUpdate(true);
            syncOpts.setQuiet(populate.isQuiet());
            List syncMsg = this.iclient.sync(update, syncOpts);
            this.getValidate().check((List<IFileSpec>)syncMsg, "file(s) up-to-date.", "file does not exist");
        }
        this.log("duration: " + timer.toString() + "\n");
    }

    public void revertAllFiles(boolean virtual) throws Exception {
        String path = this.iclient.getRoot() + "/...";
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{path});
        RevertFilesOptions rOpts = new RevertFilesOptions();
        rOpts.setNoClientRefresh(virtual);
        List list = this.iclient.revertFiles(files, rOpts);
        this.getValidate().check((List<IFileSpec>)list, "not opened on this client", "Replica does not support this command");
    }

    public void versionFile(String file, Publish publish, int ChangelistID, boolean submit) throws Exception {
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{file});
        this.findChangeFiles(files, publish.isDelete(), publish.isModtime());
        if (!this.isOpened(files)) {
            return;
        }
        IChangelist change = this.appendPendingChangeList(files, publish, ChangelistID);
        if (submit) {
            this.submitFiles(change, false);
        }
    }

    public boolean buildChange(Publish publish) throws Exception {
        List files;
        TimeTask timer = new TimeTask();
        this.log("P4 Task: reconcile files to changelist.");
        if (publish instanceof CommitImpl) {
            CommitImpl commit = (CommitImpl)publish;
            files = FileSpecBuilder.makeFileSpecList(commit.getFiles());
            AddFilesOptions opts = new AddFilesOptions();
            this.iclient.addFiles(files, opts);
        } else {
            String clientBase = "//" + this.iclient.getName() + "/";
            List<String> paths = this.buildPaths(publish, clientBase);
            files = FileSpecBuilder.makeFileSpecList(paths);
            this.findChangeFiles(files, publish.isDelete(), publish.isModtime());
        }
        boolean open = this.isOpened(files);
        this.log("duration: " + timer.toString() + "\n");
        return open;
    }

    private List<String> buildPaths(Publish publish, String clientBase) {
        String[] array;
        ArrayList<String> list = new ArrayList<String>();
        String rawPaths = publish.getPaths();
        if (rawPaths == null || rawPaths.isEmpty()) {
            list.add(clientBase + "...");
            return list;
        }
        for (String a : array = rawPaths.split("\n\\s*")) {
            if (a.startsWith("//")) {
                list.add(a);
                continue;
            }
            list.add(clientBase + a);
        }
        return list;
    }

    private void findChangeFiles(List<IFileSpec> files, boolean delete, boolean modtime) throws Exception {
        RevertFilesOptions revertOpts = new RevertFilesOptions();
        revertOpts.setNoClientRefresh(true);
        List revertStat = this.iclient.revertFiles(files, revertOpts);
        this.getValidate().check((List<IFileSpec>)revertStat, "file(s) not opened on this client.");
        SyncOptions syncOpts = new SyncOptions();
        syncOpts.setClientBypass(true);
        List syncStat = this.iclient.sync(files, syncOpts);
        this.getValidate().check((List<IFileSpec>)syncStat, "file(s) up-to-date.", "no such file(s).");
        ReconcileFilesOptions statusOpts = new ReconcileFilesOptions();
        statusOpts.setCheckModTime(modtime);
        statusOpts.setUseWildcards(true);
        statusOpts.setOutsideAdd(true);
        statusOpts.setOutsideEdit(true);
        statusOpts.setRemoved(delete);
        List status = this.iclient.reconcileFiles(files, statusOpts);
        this.getValidate().check((List<IFileSpec>)status, "- no file(s) to reconcile", "instead of", "empty, assuming text", "also opened by");
    }

    public String publishChange(Publish publish) throws Exception {
        String id = null;
        TimeTask timer = new TimeTask();
        this.log("P4 Task: publish files to Perforce.");
        String ws = "//" + this.iclient.getName() + "/...";
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{ws});
        IChangelist change = this.appendPendingChangeList(files, publish, 0);
        OpenedFilesOptions openOps = new OpenedFilesOptions();
        List open = this.iclient.openedFiles(files, openOps);
        for (IFileSpec f : open) {
            FileAction action = f.getAction();
            String path = f.getDepotPathString();
            this.log("... ... " + action + " " + path);
        }
        if (publish instanceof SubmitImpl) {
            SubmitImpl submit = (SubmitImpl)publish;
            boolean reopen = submit.isReopen();
            long c = this.submitFiles(change, reopen);
            id = Long.toString(c);
        }
        if (publish instanceof ShelveImpl) {
            ShelveImpl shelve = (ShelveImpl)publish;
            boolean revert = shelve.isRevert();
            long c = this.shelveFiles(change, files, revert);
            id = Long.toString(c);
        }
        if (publish instanceof CommitImpl) {
            CommitImpl commit = (CommitImpl)publish;
            id = this.commitFiles(change);
        }
        this.log("duration: " + timer.toString() + "\n");
        return id;
    }

    private IChangelist appendPendingChangeList(List<IFileSpec> files, Publish publish, int ChangeListID) throws Exception {
        SubmitImpl submit;
        int purge;
        String desc = publish.getExpandedDesc();
        if (ChangeListID == -1 || ChangeListID == 0) {
            Changelist change = new Changelist();
            change.setDescription(desc);
            change = this.iclient.createChangelist((IChangelist)change);
            ChangeListID = change.getId();
        }
        this.log("... pending change: " + ChangeListID);
        ReopenFilesOptions reopenOpts = new ReopenFilesOptions();
        reopenOpts.setChangelistId(ChangeListID);
        if (publish instanceof SubmitImpl && (purge = (submit = (SubmitImpl)publish).getPurgeValue()) > 0) {
            reopenOpts.setFileType("+S" + purge);
        }
        this.iclient.reopenFiles(files, reopenOpts);
        return this.getChange(ChangeListID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long submitFiles(IChangelist change, boolean reopen) throws Exception {
        SubmitStreamingCallback callback;
        this.log("... submitting files");
        SubmitOptions submitOpts = new SubmitOptions();
        submitOpts.setReOpen(reopen);
        SubmitStreamingCallback submitStreamingCallback = callback = new SubmitStreamingCallback(this.iclient.getServer(), this.getListener());
        synchronized (submitStreamingCallback) {
            change.submit(submitOpts, (IStreamingCallback)callback, 0);
            while (!callback.isDone()) {
                callback.wait();
            }
        }
        if (callback.isFail()) {
            throw new P4JavaException((Throwable)callback.getException());
        }
        long cngNumber = callback.getChange();
        if (cngNumber <= 0L) {
            throw new P4JavaException("Unable to submit change.");
        }
        this.log("... submitted in change: " + cngNumber);
        return cngNumber;
    }

    private String commitFiles(IChangelist change) throws Exception {
        Map[] results;
        this.log("... committing files");
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-c");
        opts.add(String.valueOf(change.getId()));
        String[] args = opts.toArray(new String[opts.size()]);
        for (Map map : results = this.getConnection().execMapCmd(CmdSpec.SUBMIT.name(), args, null)) {
            if (!map.containsKey("submittedCommit")) continue;
            String sha = (String)map.get("submittedCommit");
            this.log("... committing SHA: " + sha);
            return sha;
        }
        throw new P4JavaException("Unable to commit change.");
    }

    private long shelveFiles(IChangelist change, List<IFileSpec> files, boolean revert) throws Exception {
        this.log("... shelving files");
        List shelved = this.iclient.shelveChangelist(change);
        this.getValidate().check((List<IFileSpec>)shelved, "");
        RevertFilesOptions revertOpts = new RevertFilesOptions();
        revertOpts.setChangelistId(change.getId());
        revertOpts.setNoClientRefresh(!revert);
        String r = revert ? "(revert)" : "(revert -k)";
        this.log("... reverting open files " + r);
        this.iclient.revertFiles(files, revertOpts);
        return change.getId();
    }

    private boolean isOpened(List<IFileSpec> files) throws Exception {
        OpenedFilesOptions openOps = new OpenedFilesOptions();
        List open = this.iclient.openedFiles(files, openOps);
        for (IFileSpec file : open) {
            if (file == null || file.getAction() == null) continue;
            return true;
        }
        return false;
    }

    private String depotToLocal(IFileSpec fileSpec) throws Exception {
        String depotPath = fileSpec.getDepotPathString();
        if (depotPath == null) {
            depotPath = fileSpec.getOriginalPathString();
        }
        if (depotPath == null) {
            return null;
        }
        List dSpec = FileSpecBuilder.makeFileSpecList((String[])new String[]{depotPath});
        List lSpec = this.iclient.where(dSpec);
        String path = ((IFileSpec)lSpec.get(0)).getLocalPathString();
        return path;
    }

    private String localToDepot(IFileSpec fileSpec) throws Exception {
        String depotPath = fileSpec.getDepotPathString();
        if (depotPath == null) {
            depotPath = fileSpec.getOriginalPathString();
        }
        if (depotPath == null) {
            return null;
        }
        List dSpec = FileSpecBuilder.makeFileSpecList((String[])new String[]{depotPath});
        List lSpec = this.iclient.where(dSpec);
        String path = ((IFileSpec)lSpec.get(0)).getDepotPathString();
        return path;
    }

    private void deleteFile(String rev) throws Exception {
        boolean ok;
        List file = FileSpecBuilder.makeFileSpecList((String[])new String[]{rev});
        String local = this.depotToLocal((IFileSpec)file.get(0));
        File unlink = new File(local);
        if (unlink.exists() && !(ok = unlink.delete())) {
            this.log("Not able to delete: " + local);
        }
    }

    private void printFile(String rev) throws Exception {
        int len;
        byte[] buf = new byte[65536];
        List file = FileSpecBuilder.makeFileSpecList((String[])new String[]{rev});
        GetFileContentsOptions printOpts = new GetFileContentsOptions();
        printOpts.setNoHeaderLine(true);
        InputStream ins = this.getConnection().getFileContents(file, printOpts);
        String localPath = this.depotToLocal((IFileSpec)file.get(0));
        File target = new File(localPath);
        if (target.getParentFile().mkdirs()) {
            this.log("Directory created: " + target);
        }
        if (target.exists()) {
            target.setWritable(true);
        }
        FileOutputStream outs = new FileOutputStream(target);
        BufferedOutputStream bouts = new BufferedOutputStream(outs);
        while ((len = ins.read(buf)) > 0) {
            bouts.write(buf, 0, len);
        }
        ins.close();
        bouts.close();
    }

    public void unshelveFiles(long review) throws Exception {
        if (review < 1L) {
            this.log("P4 Task: skipping review: " + review);
            return;
        }
        TimeTask timer = new TimeTask();
        this.log("P4 Task: unshelve review: " + review);
        List shelveMsg = this.iclient.unshelveChangelist((int)review, null, 0, true, false);
        this.getValidate().check((List<IFileSpec>)shelveMsg, false, "also opened by", "No such file(s)", "exclusive file already opened", "no file(s) to unshelve");
        for (IFileSpec spec : shelveMsg) {
            if (spec.getOpStatus() != FileSpecOpStatus.VALID) {
                String msg = spec.getStatusMessage();
                if (!msg.contains("exclusive file already opened")) continue;
                String rev = msg.substring(0, msg.indexOf(" - can't "));
                if (msg.contains("can't delete") || msg.contains("can't move/delete")) {
                    this.log("P4 Task: delete: " + rev);
                    this.deleteFile(rev);
                    continue;
                }
                this.log("P4 Task: print: " + rev);
                this.printFile(rev + "@=" + review);
                continue;
            }
            this.log(spec.getDepotPathString());
        }
        this.log("... duration: " + timer.toString());
    }

    public void resolveFiles(String mode) throws Exception {
        if ("none".equals(mode)) {
            return;
        }
        TimeTask timer = new TimeTask();
        this.log("P4 Task: resolve: -" + mode);
        String path = this.iclient.getRoot() + "/...";
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{path});
        ResolveFilesAutoOptions rsvOpts = new ResolveFilesAutoOptions();
        rsvOpts.setAcceptTheirs("at".equals(mode));
        rsvOpts.setAcceptYours("ay".equals(mode));
        rsvOpts.setSafeMerge("as".equals(mode));
        rsvOpts.setForceResolve("af".equals(mode));
        List rsvMsg = this.iclient.resolveFilesAuto(files, rsvOpts);
        this.getValidate().check((List<IFileSpec>)rsvMsg, "no file(s) to resolve");
        this.log("... duration: " + timer.toString());
    }

    public Changelist getChange(long id) throws Exception {
        try {
            return (Changelist)this.getConnection().getChangelist((int)id);
        }
        catch (RequestException e) {
            ChangelistOptions opts = new ChangelistOptions();
            opts.setOriginalChangelist(true);
            return (Changelist)this.getConnection().getChangelist((int)id, opts);
        }
    }

    public long getClientHead(P4Ref from, P4Ref to) throws Exception {
        String path = "//" + this.iclient.getName() + "/...";
        String revisionPath = this.buildRevisionLimit(path, from, to);
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{revisionPath});
        GetChangelistsOptions opts = new GetChangelistsOptions();
        opts.setType(IChangelist.Type.SUBMITTED);
        opts.setMaxMostRecent(1);
        List list = this.getConnection().getChangelists(files, opts);
        if (!list.isEmpty() && list.get(0) != null) {
            long change = ((IChangelistSummary)list.get(0)).getId();
            this.log("P4: found " + change + " revision in " + revisionPath);
            return change;
        }
        this.log("P4: no revisions under " + revisionPath);
        return 0L;
    }

    public long getClientHead() throws Exception {
        String latestChange = this.getConnection().getCounter("change");
        long latest = Long.parseLong(latestChange);
        P4ChangeRef to = new P4ChangeRef(latest);
        long head = this.getClientHead(null, to);
        return head == 0L ? latest : head;
    }

    public List<IChangelistSummary> getPendingChangelists(boolean includeLongDescription, String clientName) throws Exception {
        String ws = "//" + this.iclient.getName() + "/...";
        List files = FileSpecBuilder.makeFileSpecList((String[])new String[]{ws});
        GetChangelistsOptions opts = new GetChangelistsOptions();
        opts.setType(IChangelist.Type.PENDING);
        opts.setMaxMostRecent(this.getMaxChangeLimit());
        opts.setLongDesc(includeLongDescription);
        opts.setClientName(clientName);
        List list = this.getConnection().getChangelists(files, opts);
        Collections.sort(list, new Comparator<IChangelistSummary>(){

            @Override
            public int compare(IChangelistSummary one, IChangelistSummary two) {
                return Integer.compare(one.getId(), two.getId());
            }
        });
        Collections.reverse(list);
        return list;
    }

    public int findPendingChangelistIDByDesc(String desc, String client) throws Exception {
        int changelistID = -1;
        List<IChangelistSummary> ol = this.getPendingChangelists(true, client);
        for (IChangelistSummary item : ol) {
            logger.fine("P4: Checking Changelist: " + item.getId() + " [" + item.getDescription() + "]");
            if (!item.getDescription().replaceAll("\\r\\n|\\r|\\n", "").trim().equalsIgnoreCase(desc.trim())) continue;
            changelistID = item.getId();
            break;
        }
        return changelistID;
    }

    public List<IRepo> listRepos() {
        ArrayList<IRepo> repos = new ArrayList();
        try {
            repos = this.iclient.getRepos();
        }
        catch (Exception e) {
            logger.fine("No repos found: " + e.getMessage());
        }
        return repos;
    }

    public List<P4Ref> listChanges(List<P4Ref> fromRefs, P4Ref to) throws Exception {
        P4Ref from = this.getSingleChange(fromRefs);
        if (from.equals(to)) {
            return new ArrayList<P4Ref>();
        }
        String ws = "//" + this.iclient.getName() + "/...@" + from + "," + to;
        List<P4Ref> list = this.listChanges(ws);
        if (!from.isLabel()) {
            list.remove(from);
        }
        return list;
    }

    private P4Ref getSingleChange(List<P4Ref> refs) {
        for (P4Ref ref : refs) {
            if (ref.isCommit()) continue;
            return ref;
        }
        return null;
    }

    public List<P4Ref> listChanges(P4Ref from) throws Exception {
        String ws = "//" + this.iclient.getName() + "/...@" + from + ",now";
        List<P4Ref> list = this.listChanges(ws);
        if (!from.isLabel()) {
            list.remove(from);
        }
        return list;
    }

    public List<P4Ref> listChanges() throws Exception {
        String ws = "//" + this.iclient.getName() + "/...";
        return this.listChanges(ws);
    }

    private List<P4Ref> listChanges(String ws) throws Exception {
        ArrayList<P4Ref> list = new ArrayList<P4Ref>();
        GetChangelistsOptions opts = new GetChangelistsOptions();
        opts.setMaxMostRecent(this.getMaxChangeLimit());
        List spec = FileSpecBuilder.makeFileSpecList((String[])new String[]{ws});
        List cngs = this.getConnection().getChangelists(spec, opts);
        if (cngs != null) {
            for (IChangelistSummary c : cngs) {
                P4ChangeRef rev;
                if (c == null || c.getId() == -1 || list.contains(rev = new P4ChangeRef(c.getId()))) continue;
                list.add(rev);
            }
        }
        Collections.sort(list);
        Collections.reverse(list);
        return list;
    }

    public List<P4Ref> listHaveChanges(List<P4Ref> fromRefs) throws Exception {
        P4Ref from = this.getSingleChange(fromRefs);
        if (from.getChange() > 0L) {
            this.log("P4: Polling with range: " + from + ",now");
            return this.listChanges(from);
        }
        String path = "//" + this.iclient.getName() + "/...";
        return this.listHaveChanges(path);
    }

    public List<P4Ref> listHaveChanges(List<P4Ref> fromRefs, P4Ref changeLimit) throws Exception {
        P4Ref from = this.getSingleChange(fromRefs);
        if (from.equals(changeLimit)) {
            return new ArrayList<P4Ref>();
        }
        if (from.getChange() > 0L) {
            this.log("P4: Polling with range: " + from + "," + changeLimit);
            return this.listChanges(fromRefs, changeLimit);
        }
        String path = "//" + this.iclient.getName() + "/...";
        String fileSpec = path + "@" + changeLimit;
        return this.listHaveChanges(fileSpec);
    }

    private List<P4Ref> listHaveChanges(String fileSpec) throws Exception {
        Map[] map;
        this.log("P4: Polling with cstat: " + fileSpec);
        ArrayList<P4Ref> haveChanges = new ArrayList<P4Ref>();
        for (Map entry : map = this.getConnection().execMapCmd("cstat", new String[]{fileSpec}, null)) {
            String status = (String)entry.get("status");
            if (status == null || !status.startsWith("have")) continue;
            String value = (String)entry.get("change");
            int change = Integer.parseInt(value);
            haveChanges.add(new P4ChangeRef(change));
        }
        Collections.sort(haveChanges);
        Collections.reverse(haveChanges);
        return haveChanges;
    }

    public ClientView getClientView() {
        return this.iclient.getClientView();
    }

    public boolean isClientValid(Workspace workspace) {
        if (this.iclient == null) {
            String msg;
            if (workspace instanceof TemplateWorkspaceImpl) {
                TemplateWorkspaceImpl template = (TemplateWorkspaceImpl)workspace;
                String name = template.getTemplateName();
                msg = "P4: Template workspace not found: " + name;
            } else {
                String name = workspace.getFullName();
                msg = "P4: Unable to use workspace: " + name;
            }
            logger.severe(msg);
            if (this.getListener() != null) {
                this.log(msg);
            }
            return false;
        }
        return true;
    }

    public IClient getClient() {
        return this.iclient;
    }

    public String where(String localFile) throws Exception {
        List file = FileSpecBuilder.makeFileSpecList((String[])new String[]{localFile});
        return this.localToDepot((IFileSpec)file.get(0));
    }
}

