/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.changes;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.graph.ICommit;
import java.util.List;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;

public class P4GraphRef
implements P4Ref {
    private static final long serialVersionUID = 1L;
    private final String repo;
    private final String sha;
    private final long date;
    private final transient ICommit commit;

    public P4GraphRef(ConnectionHelper p4, String id) throws P4JavaException {
        String[] parts;
        if (id != null && !id.isEmpty() && id.contains("@") && (parts = id.split("@")).length == 2) {
            this.repo = parts[0];
            String sha = parts[1];
            this.commit = p4.getGraphCommit(sha, this.repo);
            this.date = this.commit.getCommitterDate().getTime();
            this.sha = sha;
            return;
        }
        this.repo = null;
        this.commit = null;
        this.date = 0L;
        this.sha = null;
    }

    public P4GraphRef(String repo, ICommit commit) {
        this.repo = repo;
        this.commit = commit;
        this.date = commit.getCommitterDate().getTime();
        this.sha = commit.getCommit();
    }

    @Override
    public P4ChangeEntry getChangeEntry(ClientHelper p4) throws Exception {
        P4ChangeEntry cl = new P4ChangeEntry();
        cl.setGraphCommit(p4, this.repo, this.sha);
        return cl;
    }

    @Override
    public boolean isLabel() {
        return false;
    }

    @Override
    public boolean isCommit() {
        return true;
    }

    @Override
    public long getChange() {
        return -1L;
    }

    @Override
    public List<IFileSpec> getFiles(ConnectionHelper p4, int limit) throws Exception {
        List<IFileSpec> list = p4.getCommitFiles(this.repo, this.sha);
        return list.subList(0, limit);
    }

    public long getDate() {
        return this.date;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getSha() {
        return this.sha;
    }

    @Override
    public String toString() {
        return this.repo + "@" + this.sha;
    }

    public boolean equals(Object obj) {
        P4GraphRef ref;
        return obj instanceof P4GraphRef && (ref = (P4GraphRef)obj).toString().equals(this.toString());
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + this.toString().hashCode();
        return hash;
    }

    public int compareTo(Object obj) {
        if (this.equals(obj)) {
            return 0;
        }
        if (obj instanceof P4GraphRef) {
            P4GraphRef ref = (P4GraphRef)obj;
            long diff = this.getDate() - ref.getDate();
            return (int)diff;
        }
        throw new ClassCastException();
    }
}

