/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.build;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.review.P4Review;
import org.jenkinsci.plugins.p4.tagging.TagAction;
import org.jenkinsci.plugins.p4.workspace.Workspace;

@Extension
public class P4EnvironmentContributor
extends EnvironmentContributor {
    public void buildEnvironmentFor(Run run, EnvVars env, TaskListener listener) throws IOException, InterruptedException {
        TagAction tagAction = TagAction.getLastAction(run);
        P4EnvironmentContributor.buildEnvironment(tagAction, env);
    }

    public static void buildEnvironment(TagAction tagAction, Map<String, String> map) {
        EnvVars env = new EnvVars(map);
        P4EnvironmentContributor.buildEnvironment(tagAction, env);
        map.putAll((Map<String, String>)env);
    }

    private static void buildEnvironment(TagAction tagAction, EnvVars env) {
        String ticket;
        Descriptor scm;
        PerforceScm.DescriptorImpl p4scm;
        Jenkins j;
        Workspace tagWorkspace;
        if (tagAction == null) {
            return;
        }
        if (tagAction.getRefChanges() != null) {
            String change = tagAction.getRefChange().toString();
            env.put("P4_CHANGELIST", change);
        }
        if (tagAction.getClient() != null) {
            String client = tagAction.getClient();
            env.put("P4_CLIENT", client);
        }
        if (tagAction.getPort() != null) {
            String port = tagAction.getPort();
            env.put("P4_PORT", port);
        }
        if (tagAction.getWorkspace() != null && (tagWorkspace = tagAction.getWorkspace()) != null && tagWorkspace.getRootPath() != null) {
            env.put("P4_ROOT", tagWorkspace.getRootPath());
        }
        if (tagAction.getUser() != null) {
            String user = tagAction.getUser();
            env.put("P4_USER", user);
        }
        if (tagAction.getReview() != null) {
            P4Review review = tagAction.getReview();
            env.put("P4_REVIEW", review.getId());
            env.put("P4_REVIEW_TYPE", review.getStatus().toString());
        }
        if ((j = Jenkins.getInstance()) != null && (p4scm = (PerforceScm.DescriptorImpl)(scm = j.getDescriptor(PerforceScm.class))) != null && !p4scm.isHideTicket() && (ticket = tagAction.getTicket()) != null) {
            env.put("P4_TICKET", ticket);
        }
        if (tagAction.getChangelog() != null) {
            String changelog = tagAction.getChangelog().getAbsolutePath();
            changelog = StringUtils.defaultIfBlank((String)changelog, (String)"Not-set");
            env.put("HUDSON_CHANGELOG_FILE", changelog);
        }
        if (tagAction.getJenkinsPath() != null) {
            String jenkinsPath = tagAction.getJenkinsPath();
            env.put("JENKINSFILE_PATH", jenkinsPath);
        }
    }
}

