/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.build;

import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import jenkins.model.Jenkins;

public class NodeHelper {
    private static final String UNKNOWN_NODE_NAME = "unknown";
    private static final String MASTER_NODE_NAME = "master";

    private NodeHelper() {
    }

    public static String getNodeName(FilePath path) {
        Node node = NodeHelper.workspaceToNode(path);
        String nodeName = NodeHelper.nameOf(node);
        return nodeName.isEmpty() ? MASTER_NODE_NAME : nodeName;
    }

    private static String nameOf(Node node) {
        return node == null ? UNKNOWN_NODE_NAME : node.getNodeName();
    }

    private static Computer workspaceToComputer(FilePath workspace) {
        if (workspace != null) {
            return workspace.toComputer();
        }
        return null;
    }

    public static Node workspaceToNode(FilePath workspace) {
        Computer computer = NodeHelper.workspaceToComputer(workspace);
        if (computer != null) {
            return computer.getNode();
        }
        return Jenkins.getInstance();
    }
}

