/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.browsers;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.changes.P4AffectedFile;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class P4WebBrowser
extends P4Browser {
    private static final long serialVersionUID = 1L;
    public final String p4FileEnd = "?ac=22";
    public final String p4DiffEnd = "?ac=19";
    public final String p4ChangeEnd = "?ac=10";
    public final String p4JobEnd = "?ac=111";
    public final String p4LabelEnd = "?ac=16";

    @DataBoundConstructor
    public P4WebBrowser(String url) {
        super(url);
    }

    public URL getChangeSetLink(P4ChangeEntry changeSet) throws IOException {
        return new URL(this.getSafeUrl().toString() + changeSet.getId() + "?ac=10");
    }

    public URL getLabelSetLink(P4ChangeEntry changeSet) throws IOException {
        return new URL(this.getSafeUrl().toString() + changeSet.getId() + "?ac=16");
    }

    @Override
    public URL getDiffLink(P4AffectedFile file, P4Ref change) throws Exception {
        if (!file.getAction().equalsIgnoreCase("edit")) {
            return null;
        }
        int rev = this.parseRevision(file);
        if (rev <= 1) {
            return null;
        }
        return new URL(this.getSafeUrl().toString() + file.getPath() + "?ac=19" + "&rev1=" + (rev - 1) + "&rev2=" + rev);
    }

    @Override
    public URL getFileLink(P4AffectedFile file) throws Exception {
        return new URL(this.getSafeUrl().toString() + file.getPath() + "?ac=22");
    }

    @Override
    public URL getJobLink(String job) throws Exception {
        return new URL(this.getSafeUrl().toString() + job + "?ac=111");
    }

    @Extension
    @Symbol(value={"p4Web"})
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "P4Web browser";
        }

        public FormValidation doCheck(@QueryParameter String value) throws IOException, ServletException {
            String url = Util.fixEmpty((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                return FormValidation.errorWithMarkup((String)"The URL should contain <tt>http://</tt> or <tt>https://</tt>");
            }
            return FormValidation.ok();
        }

        public P4WebBrowser newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return req == null ? null : (P4WebBrowser)((Object)req.bindJSON(P4WebBrowser.class, jsonObject));
        }
    }
}

