/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.browsers;

import hudson.scm.RepositoryBrowser;
import java.net.MalformedURLException;
import java.net.URL;
import org.jenkinsci.plugins.p4.changes.P4AffectedFile;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4Ref;

public abstract class P4Browser
extends RepositoryBrowser<P4ChangeEntry> {
    private static final long serialVersionUID = 1L;
    private String url;

    public P4Browser(String url) {
        this.url = url;
    }

    public final String getUrl() {
        return this.url;
    }

    public URL getSafeUrl() {
        try {
            URL safe = P4Browser.normalizeToEndWithSlash((URL)new URL(this.url));
            return safe;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public abstract URL getDiffLink(P4AffectedFile var1, P4Ref var2) throws Exception;

    public abstract URL getFileLink(P4AffectedFile var1) throws Exception;

    public abstract URL getJobLink(String var1) throws Exception;

    protected int parseRevision(P4AffectedFile file) {
        String rev = file.getRevision();
        if (rev == null || !rev.contains("#") || rev.length() <= 1) {
            return -1;
        }
        rev = rev.substring(1);
        return Integer.parseInt(rev);
    }
}

