/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.browsers;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.changes.P4AffectedFile;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class OpenGrokBrowser
extends P4Browser {
    private static final long serialVersionUID = 1L;
    private final String depotPath;
    private final String projectName;

    public String getDepotPath() {
        return this.depotPath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundConstructor
    public OpenGrokBrowser(String url, String depotPath, String projectName) {
        super(url);
        this.depotPath = depotPath;
        this.projectName = projectName;
    }

    @Override
    public URL getDiffLink(P4AffectedFile file, P4Ref change) throws Exception {
        String path = this.getRelativeFilename(file);
        int rev = this.parseRevision(file);
        if (rev <= 1) {
            return null;
        }
        String r1 = "r1=" + URLEncoder.encode(path + "#" + (rev - 1), "UTF-8");
        String r2 = "r2=" + URLEncoder.encode(path + "#" + rev, "UTF-8");
        return new URL(this.getSafeUrl(), "source/diff/" + this.projectName + "/build.properties?" + r2 + "&" + r1 + this.getRelativeFilename(file));
    }

    @Override
    public URL getFileLink(P4AffectedFile file) throws Exception {
        return new URL(this.getSafeUrl(), "source/xref/" + this.projectName + "/" + this.getRelativeFilename(file));
    }

    @Override
    public URL getJobLink(String job) throws Exception {
        return null;
    }

    private String getRelativeFilename(P4AffectedFile file) {
        String path = file.getPath();
        if (path.startsWith(this.depotPath)) {
            path = path.substring(this.depotPath.length());
        }
        return OpenGrokBrowser.trimHeadSlash((String)path);
    }

    public URL getChangeSetLink(P4ChangeEntry changeSet) throws IOException {
        return null;
    }

    @Extension
    @Symbol(value={"openGrok"})
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "OpenGrok";
        }

        public FormValidation doCheck(@QueryParameter String value) {
            String url = Util.fixEmpty((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                return FormValidation.errorWithMarkup((String)"The URL should contain <tt>http://</tt> or <tt>https://</tt>");
            }
            return FormValidation.ok();
        }

        public OpenGrokBrowser newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return req == null ? null : (OpenGrokBrowser)((Object)req.bindJSON(OpenGrokBrowser.class, jsonObject));
        }
    }
}

