/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4.browsers;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.changes.P4AffectedFile;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class FishEyeBrowser
extends P4Browser {
    private static final long serialVersionUID = 1L;
    private final String rootModule;

    public String getRootModule() {
        if (this.rootModule == null) {
            return "";
        }
        return this.rootModule;
    }

    @DataBoundConstructor
    public FishEyeBrowser(String url, String rootModule) {
        super(url);
        this.rootModule = FishEyeBrowser.trimHeadSlash((String)FishEyeBrowser.trimHeadSlash((String)rootModule));
    }

    public URL getChangeSetLink(P4ChangeEntry changeSet) throws IOException {
        return new URL(this.getSafeUrl(), "../../changelog/" + this.getProjectName() + "/?cs=" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(P4AffectedFile file, P4Ref change) throws Exception {
        if (!file.getAction().equalsIgnoreCase("edit")) {
            return null;
        }
        if (change == null) {
            return null;
        }
        return new URL(this.getSafeUrl(), this.getRelativeFilename(file) + new QueryBuilder(this.getSafeUrl().getQuery()).add("r1=").add("r2=" + change));
    }

    @Override
    public URL getFileLink(P4AffectedFile file) throws Exception {
        return new URL(this.getSafeUrl(), this.getRelativeFilename(file) + new QueryBuilder(this.getSafeUrl().getQuery()));
    }

    @Override
    public URL getJobLink(String job) throws Exception {
        return null;
    }

    private String getRelativeFilename(P4AffectedFile file) {
        String path = FishEyeBrowser.trimHeadSlash((String)FishEyeBrowser.trimHeadSlash((String)file.getPath()));
        if (path.startsWith(this.getRootModule())) {
            path = path.substring(this.getRootModule().length());
        }
        return FishEyeBrowser.trimHeadSlash((String)path);
    }

    private String getProjectName() {
        String p = this.getSafeUrl().getPath();
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        int idx = p.lastIndexOf(47);
        return p.substring(idx + 1);
    }

    @Extension
    @Symbol(value={"fishEye"})
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        private static final Pattern URL_PATTERN = Pattern.compile(".+/browse/[^/]+/");

        public String getDisplayName() {
            return "FishEye browser";
        }

        public FormValidation doCheck(@QueryParameter String value) throws IOException, ServletException {
            String url = Util.fixEmpty((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            if (!url.endsWith("/")) {
                url = url + '/';
            }
            if (!URL_PATTERN.matcher(url).matches()) {
                return FormValidation.errorWithMarkup((String)"The URL should end like <tt>.../browse/foobar/</tt>");
            }
            return FormValidation.ok();
        }

        public FishEyeBrowser newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return req == null ? null : (FishEyeBrowser)((Object)req.bindJSON(FishEyeBrowser.class, jsonObject));
        }
    }
}

