/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.perforce.p4java.exception.P4JavaException;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Plugin;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixExecutionStrategy;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.LogTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.multiplescms.MultiSCM;
import org.jenkinsci.plugins.p4.PerforceRevisionState;
import org.jenkinsci.plugins.p4.browsers.P4Browser;
import org.jenkinsci.plugins.p4.browsers.SwarmBrowser;
import org.jenkinsci.plugins.p4.build.ExecutorHelper;
import org.jenkinsci.plugins.p4.build.NodeHelper;
import org.jenkinsci.plugins.p4.build.P4EnvironmentContributor;
import org.jenkinsci.plugins.p4.changes.P4ChangeEntry;
import org.jenkinsci.plugins.p4.changes.P4ChangeParser;
import org.jenkinsci.plugins.p4.changes.P4ChangeRef;
import org.jenkinsci.plugins.p4.changes.P4ChangeSet;
import org.jenkinsci.plugins.p4.changes.P4GraphRef;
import org.jenkinsci.plugins.p4.changes.P4LabelRef;
import org.jenkinsci.plugins.p4.changes.P4Ref;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jenkinsci.plugins.p4.credentials.P4BaseCredentials;
import org.jenkinsci.plugins.p4.credentials.P4CredentialsImpl;
import org.jenkinsci.plugins.p4.credentials.P4InvalidCredentialException;
import org.jenkinsci.plugins.p4.filters.Filter;
import org.jenkinsci.plugins.p4.filters.FilterLatestChangeImpl;
import org.jenkinsci.plugins.p4.filters.FilterPerChangeImpl;
import org.jenkinsci.plugins.p4.matrix.MatrixOptions;
import org.jenkinsci.plugins.p4.populate.Populate;
import org.jenkinsci.plugins.p4.review.P4Review;
import org.jenkinsci.plugins.p4.review.ReviewProp;
import org.jenkinsci.plugins.p4.scm.AbstractP4ScmSource;
import org.jenkinsci.plugins.p4.scm.P4Path;
import org.jenkinsci.plugins.p4.tagging.TagAction;
import org.jenkinsci.plugins.p4.tasks.CheckoutStatus;
import org.jenkinsci.plugins.p4.tasks.CheckoutTask;
import org.jenkinsci.plugins.p4.tasks.PollTask;
import org.jenkinsci.plugins.p4.tasks.RemoveClientTask;
import org.jenkinsci.plugins.p4.tasks.WhereTask;
import org.jenkinsci.plugins.p4.workspace.ManualWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.SpecWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.StaticWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.StreamWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.TemplateWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.DisableConcurrentBuildsJobProperty;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class PerforceScm
extends SCM {
    private static Logger logger = Logger.getLogger(PerforceScm.class.getName());
    private final String credential;
    private final Workspace workspace;
    private final List<Filter> filter;
    private final Populate populate;
    private final P4Browser browser;
    private P4Ref revision;
    private String script;
    private transient TagAction tagAction = null;
    private transient P4Ref parentChange;
    private transient P4Review review;
    public static final int DEFAULT_FILE_LIMIT = 50;
    public static final int DEFAULT_CHANGE_LIMIT = 20;
    public static final long DEFAULT_HEAD_LIMIT = 1000L;

    public String getCredential() {
        return this.credential;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public List<Filter> getFilter() {
        return this.filter;
    }

    public Populate getPopulate() {
        return this.populate;
    }

    public P4Browser getBrowser() {
        return this.browser;
    }

    public P4Review getReview() {
        return this.review;
    }

    public void setReview(P4Review review) {
        this.review = review;
    }

    public static PerforceScm convertToPerforceScm(SCM scm) {
        PerforceScm perforceScm = null;
        if (scm instanceof PerforceScm) {
            perforceScm = (PerforceScm)scm;
        } else {
            Plugin multiSCMPlugin;
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null && (multiSCMPlugin = jenkins.getPlugin("multiple-scms")) != null && scm instanceof MultiSCM) {
                MultiSCM multiSCM = (MultiSCM)scm;
                for (SCM configuredSCM : multiSCM.getConfiguredSCMs()) {
                    if (!(configuredSCM instanceof PerforceScm)) continue;
                    perforceScm = (PerforceScm)configuredSCM;
                    break;
                }
            }
        }
        return perforceScm;
    }

    @DataBoundConstructor
    public PerforceScm(String credential, Workspace workspace, List<Filter> filter, Populate populate, P4Browser browser) {
        this.credential = credential;
        this.workspace = workspace;
        this.filter = filter;
        this.populate = populate;
        this.browser = browser;
        this.revision = null;
    }

    public PerforceScm(AbstractP4ScmSource source, P4Path path, P4Ref revision) {
        this.credential = source.getCredential();
        this.workspace = source.getWorkspace(path);
        this.filter = source.getFilter();
        this.populate = source.getPopulate();
        this.browser = source.getBrowser();
        this.revision = revision;
        this.script = source.getScriptPathOrDefault();
    }

    public PerforceScm(String credential, Workspace workspace, Populate populate) {
        this.credential = credential;
        this.workspace = workspace;
        this.filter = null;
        this.populate = populate;
        this.browser = null;
        this.revision = null;
    }

    public String getKey() {
        Workspace ws;
        String delim = "-";
        StringBuffer key = new StringBuffer("p4");
        key.append(delim);
        key.append(this.credential);
        key.append(delim);
        if (this.workspace instanceof ManualWorkspaceImpl) {
            ws = (ManualWorkspaceImpl)this.workspace;
            key.append(((ManualWorkspaceImpl)ws).getSpec().getView());
            key.append(((ManualWorkspaceImpl)ws).getSpec().getStreamName());
            key.append(((ManualWorkspaceImpl)ws).getName());
        }
        if (this.workspace instanceof StreamWorkspaceImpl) {
            ws = (StreamWorkspaceImpl)this.workspace;
            key.append(((StreamWorkspaceImpl)ws).getStreamName());
            key.append(((StreamWorkspaceImpl)ws).getName());
        }
        if (this.workspace instanceof SpecWorkspaceImpl) {
            ws = (SpecWorkspaceImpl)this.workspace;
            key.append(((SpecWorkspaceImpl)ws).getSpecPath());
            key.append(((SpecWorkspaceImpl)ws).getName());
        }
        if (this.workspace instanceof StaticWorkspaceImpl) {
            ws = (StaticWorkspaceImpl)this.workspace;
            key.append(((StaticWorkspaceImpl)ws).getName());
        }
        if (this.workspace instanceof TemplateWorkspaceImpl) {
            ws = (TemplateWorkspaceImpl)this.workspace;
            key.append(((TemplateWorkspaceImpl)ws).getTemplateName());
            key.append(((TemplateWorkspaceImpl)ws).getName());
        }
        return key.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static P4Browser findBrowser(String scmCredential) {
        P4BaseCredentials credentials;
        StaplerRequest req = Stapler.getCurrentRequest();
        Job job = req == null ? null : (Job)req.findAncestorObject(Job.class);
        P4BaseCredentials p4BaseCredentials = credentials = job == null ? ConnectionHelper.findCredential(scmCredential, (ItemGroup)Jenkins.getInstance()) : ConnectionHelper.findCredential(scmCredential, (Item)job);
        if (credentials == null) {
            logger.fine("Could not retrieve credentials from id: '${scmCredential}");
            return null;
        }
        try (ConnectionHelper p4 = new ConnectionHelper(credentials, null);){
            String url = p4.getSwarm();
            if (url != null) {
                SwarmBrowser swarmBrowser = new SwarmBrowser(url);
                return swarmBrowser;
            }
            P4Browser p4Browser = null;
            return p4Browser;
        }
        catch (IOException e) {
            logger.severe("Connection error. " + e.getMessage());
            return null;
        }
        catch (P4JavaException e) {
            logger.severe("Unable to access Swarm Property. " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            logger.severe("Perforce resource error. " + e.getMessage());
        }
        return null;
    }

    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return new PerforceRevisionState(new P4LabelRef("now"));
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> job, Launcher launcher, FilePath buildWorkspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        Queue.Item[] items;
        String jobName = job.getName();
        logger.finer("P4: polling[" + jobName + "] started...");
        PollingResult state = PollingResult.NO_CHANGES;
        Run lastRun = job.getLastBuild();
        for (Queue.Item item : items = Jenkins.getInstance().getQueue().getItems()) {
            WorkflowJob task;
            if (!(item.task instanceof WorkflowJob) || !(task = (WorkflowJob)item.task).equals(job)) continue;
            if (item instanceof Queue.WaitingItem) {
                logger.info("P4: polling[" + jobName + "] skipping WaitingItem");
                return PollingResult.NO_CHANGES;
            }
            if (item instanceof Queue.BlockedItem) {
                logger.finer("P4: polling[" + jobName + "] BlockedItem");
            }
            if (!(item instanceof Queue.BuildableItem)) continue;
            logger.finer("P4: polling[" + jobName + "] BuildableItem");
        }
        if (buildWorkspace == null) {
            String defaultRoot = job.getRootDir().getAbsoluteFile().getAbsolutePath();
            if (lastRun != null) {
                EnvVars env = lastRun.getEnvironment(listener);
                buildWorkspace = new FilePath(new File(env.get("WORKSPACE", defaultRoot)));
            } else {
                listener.getLogger().println("Warning Jenkins Workspace root not defined.");
                return PollingResult.NO_CHANGES;
            }
        }
        Node node = NodeHelper.workspaceToNode(buildWorkspace);
        if (job instanceof MatrixProject) {
            if (this.isBuildParent(job)) {
                EnvVars envVars = job.getEnvironment(node, listener);
                state = this.pollWorkspace(envVars, listener, buildWorkspace, lastRun, baseline);
            } else {
                MatrixProject matrixProj = (MatrixProject)job;
                Collection configs = matrixProj.getActiveConfigurations();
                for (MatrixConfiguration config : configs) {
                    EnvVars envVars = config.getEnvironment(node, listener);
                    state = this.pollWorkspace(envVars, listener, buildWorkspace, lastRun, baseline);
                    if (state != PollingResult.BUILD_NOW) continue;
                    logger.finer("P4: polling[" + jobName + "] exit (Matrix): " + state.change);
                    return state;
                }
            }
        } else {
            EnvVars envVars = job.getEnvironment(node, listener);
            state = this.pollWorkspace(envVars, listener, buildWorkspace, lastRun, baseline);
        }
        logger.finer("P4: polling[" + jobName + "] exit: " + state.change);
        return state;
    }

    private boolean isConcurrentBuild(Job<?, ?> job) {
        return job instanceof AbstractProject ? ((AbstractProject)job).isConcurrentBuild() : job.getProperty(DisableConcurrentBuildsJobProperty.class) == null;
    }

    private PollingResult pollWorkspace(EnvVars envVars, TaskListener listener, FilePath buildWorkspace, Run<?, ?> lastRun, SCMRevisionState baseline) throws InterruptedException, IOException {
        String nodeName = NodeHelper.getNodeName(buildWorkspace);
        envVars.put("NODE_NAME", envVars.get("NODE_NAME", nodeName));
        String executor = ExecutorHelper.getExecutorID(buildWorkspace, listener);
        envVars.put("EXECUTOR_NUMBER", envVars.get("EXECUTOR_NUMBER", executor));
        Workspace ws = this.workspace.deepClone();
        ws.setRootPath(null);
        ws.setExpand((Map<String, String>)envVars);
        String client = ws.getFullName();
        listener.getLogger().println("P4: Polling on: " + nodeName + " with:" + client);
        List<P4Ref> changes = this.lookForChanges(buildWorkspace, ws, lastRun, listener);
        this.cleanupPerforceClient(lastRun, buildWorkspace, listener, ws);
        if (changes == null) {
            listener.getLogger().println("P4: Polling error; no previous change.");
            return PollingResult.NO_CHANGES;
        }
        if (changes.isEmpty()) {
            listener.getLogger().println("P4: Polling no changes found.");
            return PollingResult.NO_CHANGES;
        }
        changes.forEach(c -> listener.getLogger().println("P4: Polling found change: " + c));
        if (baseline instanceof PerforceRevisionState) {
            PerforceRevisionState p4Baseline = (PerforceRevisionState)baseline;
            this.setLatestChange(changes, listener, p4Baseline);
        }
        return PollingResult.BUILD_NOW;
    }

    private void setLatestChange(List<P4Ref> changes, TaskListener listener, PerforceRevisionState baseline) {
        long change = 0L;
        for (P4Ref c : changes) {
            change = Math.max(change, c.getChange());
        }
        if (change > 0L && FilterLatestChangeImpl.isActive(this.getFilter())) {
            listener.getLogger().println("P4: Setting Latest change to: " + change);
            baseline.setChange(new P4ChangeRef(change));
        }
    }

    private List<P4Ref> lookForChanges(FilePath buildWorkspace, Workspace ws, Run<?, ?> lastRun, TaskListener listener) throws IOException, InterruptedException {
        List<P4Ref> lastRefs;
        String syncID = ws.getSyncID();
        String pin = this.populate.getPin();
        if (pin != null && !pin.isEmpty()) {
            pin = ws.getExpand().format(pin, false);
            ws.getExpand().set(ReviewProp.P4_LABEL.toString(), pin);
        }
        if ((lastRefs = TagAction.getLastChange(lastRun, listener, syncID)) == null || lastRefs.isEmpty()) {
            listener.getLogger().println("P4: Polling: No changes in previous build.");
            return null;
        }
        PollTask task = new PollTask(this.credential, lastRun, listener, this.filter, lastRefs);
        task.setWorkspace(ws);
        task.setLimit(pin);
        List changes = (List)buildWorkspace.act((FilePath.FileCallable)task);
        return changes;
    }

    public void checkout(Run<?, ?> run, Launcher launcher, FilePath buildWorkspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        String jobName = run.getParent().getName();
        logger.finer("P4: checkout[" + jobName + "] started...");
        PrintStream log = listener.getLogger();
        boolean success = true;
        CheckoutTask task = new CheckoutTask(this.credential, run, listener, this.populate);
        try {
            CredentialsProvider.track(run, (Credentials)task.getCredential());
        }
        catch (P4InvalidCredentialException e) {
            String err = "P4: Unable to checkout: " + e;
            logger.severe(err);
            throw new AbortException(err);
        }
        Workspace ws = task.setEnvironment(run, this.workspace, buildWorkspace);
        if (this.review != null) {
            ws.addEnv(ReviewProp.SWARM_REVIEW.toString(), this.review.getId());
            ws.addEnv(ReviewProp.SWARM_STATUS.toString(), CheckoutStatus.SHELVED.toString());
        }
        task.setWorkspace(ws);
        task.initialise();
        if (FilterPerChangeImpl.isActive(this.getFilter())) {
            Run lastRun = run.getPreviousBuiltBuild();
            Run inProgressRun = run.getPreviousBuildInProgress();
            if (inProgressRun != null) {
                lastRun = inProgressRun;
            }
            List<P4Ref> changes = this.lookForChanges(buildWorkspace, ws, lastRun, listener);
            task.setIncrementalChanges(changes);
        }
        if (FilterLatestChangeImpl.isActive(this.getFilter()) && baseline instanceof PerforceRevisionState) {
            PerforceRevisionState p4baseline = (PerforceRevisionState)baseline;
            log.println("Baseline: " + p4baseline.getChange().toString());
            task.setBuildChange(p4baseline.getChange());
        }
        if (this.revision != null) {
            List<P4Ref> changes = Arrays.asList(this.revision);
            task.setIncrementalChanges(changes);
        }
        TagAction tag = new TagAction(run, this.credential);
        tag.setWorkspace(ws);
        tag.setRefChanges(task.getSyncChange());
        tag.setChangelog(changelogFile);
        WhereTask where = new WhereTask(this.credential, run, listener, this.getScriptPath(run));
        where.setWorkspace(ws);
        String jenkinsPath = (String)buildWorkspace.act((FilePath.FileCallable)where);
        tag.setJenkinsPath(jenkinsPath);
        this.tagAction = tag;
        run.addAction((Action)tag);
        String node = ws.getExpand().get("NODE_NAME");
        Job job = run.getParent();
        if (run instanceof MatrixBuild) {
            this.parentChange = new P4LabelRef(this.getChangeNumber(tag, run));
            if (this.isBuildParent(job)) {
                log.println("Building Parent on Node: " + node);
                success &= ((Boolean)buildWorkspace.act((FilePath.FileCallable)task)).booleanValue();
            } else {
                listener.getLogger().println("Skipping Parent build...");
                success = true;
            }
        } else {
            if (job instanceof MatrixProject) {
                if (this.parentChange != null) {
                    log.println("Using parent change: " + this.parentChange);
                    task.setBuildChange(this.parentChange);
                }
                log.println("Building Child on Node: " + node);
            } else {
                log.println("Building on Node: " + node);
            }
            success &= ((Boolean)buildWorkspace.act((FilePath.FileCallable)task)).booleanValue();
        }
        if (!success) {
            String msg = "P4: Build failed";
            logger.warning(msg);
            throw new AbortException(msg);
        }
        if (changelogFile != null) {
            listener.getLogger().println("P4: saving built changes.");
            List<P4ChangeEntry> changes = this.calculateChanges(run, task);
            P4ChangeSet.store(changelogFile, changes);
            listener.getLogger().println("... done\n");
        } else {
            logger.fine("P4: unable to save changes, null changelogFile.");
        }
        this.cleanupPerforceClient(run, buildWorkspace, listener, ws);
        logger.finer("P4: checkout[" + jobName + "] finished.");
    }

    private String getScriptPath(Run<?, ?> run) {
        if (this.script != null) {
            return this.script;
        }
        if (!(run instanceof WorkflowRun)) {
            return null;
        }
        WorkflowRun workflowRun = (WorkflowRun)run;
        WorkflowJob job = (WorkflowJob)workflowRun.getParent();
        return this.getScriptPath((Item)job);
    }

    public String getScriptPath(Item item) {
        if (!(item instanceof WorkflowJob)) {
            return null;
        }
        WorkflowJob job = (WorkflowJob)item;
        FlowDefinition definition = job.getDefinition();
        if (!(definition instanceof CpsScmFlowDefinition)) {
            return null;
        }
        CpsScmFlowDefinition cps = (CpsScmFlowDefinition)definition;
        if (!((Object)((Object)this)).equals(cps.getScm())) {
            return null;
        }
        return cps.getScriptPath();
    }

    private void cleanupPerforceClient(Run<?, ?> run, FilePath buildWorkspace, TaskListener listener, Workspace workspace) throws IOException, InterruptedException {
        if (!workspace.isCleanup()) {
            return;
        }
        listener.getLogger().println("P4Task: cleanup Client: " + workspace.getFullName());
        RemoveClientTask removeClientTask = new RemoveClientTask(this.credential, run, listener);
        removeClientTask.setDeleteClient(true);
        removeClientTask.setDeleteFiles(false);
        Workspace ws = removeClientTask.setEnvironment(run, workspace, buildWorkspace);
        removeClientTask.setWorkspace(ws);
        buildWorkspace.act((FilePath.FileCallable)removeClientTask);
    }

    private MatrixExecutionStrategy getMatrixExecutionStrategy(Job<?, ?> job) {
        if (job instanceof MatrixProject) {
            MatrixProject matrixProj = (MatrixProject)job;
            return matrixProj.getExecutionStrategy();
        }
        return null;
    }

    boolean isBuildParent(Job<?, ?> job) {
        MatrixExecutionStrategy matrix = this.getMatrixExecutionStrategy(job);
        if (matrix instanceof MatrixOptions) {
            return ((MatrixOptions)matrix).isBuildParent();
        }
        return false;
    }

    private List<P4ChangeEntry> calculateChanges(Run<?, ?> run, CheckoutTask task) {
        ArrayList<P4ChangeEntry> list = new ArrayList<P4ChangeEntry>();
        DescriptorImpl scm = this.getDescriptor();
        Run lastBuild = scm != null && scm.isLastSuccess() ? run.getPreviousSuccessfulBuild() : run.getPreviousCompletedBuild();
        String syncID = task.getSyncID();
        List<P4Ref> lastRefs = TagAction.getLastChange(lastBuild, task.getListener(), syncID);
        if (lastRefs != null && !lastRefs.isEmpty()) {
            list.addAll(task.getChangesFull(lastRefs));
        }
        if (list.isEmpty()) {
            ArrayList<P4Ref> lastRevisions = new ArrayList<P4Ref>();
            lastRevisions.add(task.getBuildChange());
            if (lastRevisions != null && !lastRevisions.isEmpty()) {
                list.addAll(task.getChangesFull(lastRevisions));
            }
        }
        if (lastBuild == null && list.isEmpty()) {
            list.add(task.getCurrentChange());
        }
        return list;
    }

    public void buildEnvironment(Run<?, ?> run, Map<String, String> env) {
        P4EnvironmentContributor.buildEnvironment(TagAction.getLastAction(run), env);
        P4EnvironmentContributor.buildEnvironment(this.tagAction, env);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getChangeNumber(TagAction tagAction, Run<?, ?> run) {
        List<P4Ref> builds = tagAction.getRefChanges();
        Iterator<P4Ref> iterator = builds.iterator();
        while (iterator.hasNext()) {
            P4Ref build = iterator.next();
            if (build instanceof P4ChangeRef) {
                return build.toString();
            }
            if (build instanceof P4GraphRef) continue;
            try {
                int change = Integer.parseInt(build.toString());
                return String.valueOf(change);
            }
            catch (NumberFormatException change) {
                try {
                    ConnectionHelper p4 = new ConnectionHelper(run, this.credential, null);
                    Throwable throwable = null;
                    try {
                        String name = build.toString();
                        String change2 = p4.labelToChange(name);
                        if (change2 != null) {
                            String string = change2;
                            return string;
                        }
                        change2 = p4.counterToChange(name);
                        if (change2 == null) continue;
                        String string = change2;
                        return string;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (p4 == null) continue;
                        if (throwable != null) {
                            try {
                                p4.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        p4.close();
                    }
                }
                catch (Exception e) {
                    logger.severe("P4: Unable to getChangeNumber: " + e.getMessage());
                }
            }
        }
        return "";
    }

    public ChangeLogParser createChangeLogParser() {
        return new P4ChangeParser(this.credential);
    }

    public boolean processWorkspaceBeforeDeletion(Job<?, ?> job, FilePath buildWorkspace, Node node) throws IOException, InterruptedException {
        logger.finer("processWorkspaceBeforeDeletion");
        Run run = job.getLastBuild();
        if (run == null) {
            logger.warning("P4: No previous builds found");
            return false;
        }
        LogTaskListener listener = new LogTaskListener(logger, Level.INFO);
        EnvVars envVars = run.getEnvironment((TaskListener)listener);
        String client = (String)envVars.get((Object)"P4_CLIENT");
        if (client == null || client.isEmpty()) {
            logger.warning("P4: Unable to read P4_CLIENT");
            return false;
        }
        ConnectionHelper connection = new ConnectionHelper(run, this.credential, null);
        try {
            TemplateWorkspaceImpl template;
            boolean exists;
            if (!connection.isClient(client)) {
                logger.warning("P4: client not found:" + client);
                return false;
            }
            if (this.workspace instanceof TemplateWorkspaceImpl && !(exists = (template = (TemplateWorkspaceImpl)this.workspace).templateExists(connection.getConnection()))) {
                return false;
            }
        }
        catch (Exception e) {
            logger.warning("P4: Not able to get connection");
            return false;
        }
        RemoveClientTask task = new RemoveClientTask(this.credential, (Item)job, (TaskListener)listener);
        Workspace ws = task.setEnvironment(run, this.workspace, buildWorkspace);
        task.setWorkspace(ws);
        boolean clean = (Boolean)buildWorkspace.act((FilePath.FileCallable)task);
        logger.finer("processWorkspaceBeforeDeletion cleaned: " + clean);
        return clean;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    @Extension
    @Symbol(value={"perforce"})
    public static class DescriptorImpl
    extends SCMDescriptor<PerforceScm> {
        private boolean autoSave;
        private String credential;
        private String clientName;
        private String depotPath;
        private boolean autoSubmitOnChange;
        private boolean deleteClient;
        private boolean deleteFiles;
        private boolean hideTicket;
        private boolean hideMessages;
        private int maxFiles = 50;
        private int maxChanges = 20;
        private long headLimit = 1000L;
        private boolean lastSuccess;

        public boolean isAutoSave() {
            return this.autoSave;
        }

        public String getCredential() {
            return this.credential;
        }

        public String getClientName() {
            return this.clientName;
        }

        public String getDepotPath() {
            return this.depotPath;
        }

        public boolean isAutoSubmitOnChange() {
            return this.autoSubmitOnChange;
        }

        public boolean isDeleteClient() {
            return this.deleteClient;
        }

        public boolean isDeleteFiles() {
            return this.deleteFiles;
        }

        public boolean isHideTicket() {
            return this.hideTicket;
        }

        public boolean isHideMessages() {
            return this.hideMessages;
        }

        public int getMaxFiles() {
            return this.maxFiles;
        }

        public int getMaxChanges() {
            return this.maxChanges;
        }

        public long getHeadLimit() {
            return this.headLimit;
        }

        public boolean isLastSuccess() {
            return this.lastSuccess;
        }

        public void setLastSuccess(boolean lastSuccess) {
            this.lastSuccess = lastSuccess;
        }

        public DescriptorImpl() {
            super(PerforceScm.class, P4Browser.class);
            this.load();
        }

        public String getDisplayName() {
            return "Perforce Software";
        }

        public boolean isApplicable(Job project) {
            return true;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            PerforceScm scm = (PerforceScm)super.newInstance(req, formData);
            return scm;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            try {
                this.autoSave = json.getBoolean("autoSave");
                this.credential = json.getString("credential");
                this.clientName = json.getString("clientName");
                this.depotPath = json.getString("depotPath");
                this.autoSubmitOnChange = json.getBoolean("autoSubmitOnChange");
            }
            catch (JSONException e) {
                logger.info("Unable to read Auto Version configuration.");
                this.autoSave = false;
            }
            try {
                this.deleteClient = json.getBoolean("deleteClient");
                this.deleteFiles = json.getBoolean("deleteFiles");
            }
            catch (JSONException e) {
                logger.info("Unable to read client cleanup configuration.");
                this.deleteClient = false;
                this.deleteFiles = false;
            }
            try {
                this.hideTicket = json.getBoolean("hideTicket");
            }
            catch (JSONException e) {
                logger.info("Unable to read TICKET security configuration.");
                this.hideTicket = false;
            }
            try {
                this.maxFiles = json.getInt("maxFiles");
                this.maxChanges = json.getInt("maxChanges");
            }
            catch (JSONException e) {
                logger.info("Unable to read Max limits in configuration.");
                this.maxFiles = 50;
                this.maxChanges = 20;
            }
            try {
                this.headLimit = json.getLong("headLimit");
            }
            catch (JSONException e) {
                logger.info("Unable to read query limits in configuration.");
                this.headLimit = 1000L;
            }
            try {
                this.lastSuccess = json.getBoolean("lastSuccess");
                this.hideMessages = json.getBoolean("hideMessages");
            }
            catch (JSONException e) {
                logger.info("Unable to read Reporting options in configuration");
                this.lastSuccess = false;
                this.hideMessages = false;
            }
            this.save();
            return true;
        }

        public ListBoxModel doFillCredentialItems(@AncestorInPath Item project, @QueryParameter String credential) {
            return P4CredentialsImpl.doFillCredentialItems(project, credential);
        }

        public FormValidation doCheckCredential(@AncestorInPath Item project, @QueryParameter String value) {
            return P4CredentialsImpl.doCheckCredential(project, value);
        }
    }
}

