/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.p4;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.SaveableListener;
import hudson.util.LogTaskListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ViewMapHelper;
import org.jenkinsci.plugins.p4.publish.SubmitImpl;
import org.jenkinsci.plugins.p4.workspace.ManualWorkspaceImpl;
import org.jenkinsci.plugins.p4.workspace.Workspace;
import org.jenkinsci.plugins.p4.workspace.WorkspaceSpec;

@Extension
public class ConfigurationListener
extends SaveableListener {
    private static final Logger logger = Logger.getLogger(ConfigurationListener.class.getName());

    public void onChange(Saveable o, XmlFile xml) {
        Jenkins j = Jenkins.getInstance();
        Descriptor scm = j.getDescriptor(PerforceScm.class);
        PerforceScm.DescriptorImpl p4scm = (PerforceScm.DescriptorImpl)scm;
        if (p4scm == null || !p4scm.isAutoSave()) {
            return;
        }
        try {
            String file = xml.getFile().getCanonicalPath();
            logger.info(">>> onUpdated: " + file);
            String desc = "Configuration change";
            boolean success = false;
            boolean delete = true;
            boolean modtime = false;
            boolean reopen = false;
            String purge = "";
            SubmitImpl publish = new SubmitImpl(desc, success, delete, modtime, reopen, purge);
            try (ClientHelper p4 = this.getClientHelper(p4scm);){
                int ChangelistID = -1;
                if (!p4scm.isAutoSubmitOnChange()) {
                    ChangelistID = p4.findPendingChangelistIDByDesc(desc, p4scm.getClientName());
                }
                p4.versionFile(file, publish, ChangelistID, p4scm.isAutoSubmitOnChange());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ClientHelper getClientHelper(PerforceScm.DescriptorImpl p4scm) throws Exception {
        LogTaskListener listener = new LogTaskListener(logger, Level.INFO);
        String credential = p4scm.getCredential();
        String clientName = p4scm.getClientName();
        String depotPath = p4scm.getDepotPath();
        if (!depotPath.endsWith("/...")) {
            String string = depotPath = depotPath.endsWith("/") ? depotPath + "..." : depotPath + "/...";
        }
        if (depotPath.contains(" ")) {
            depotPath = "\"" + depotPath + "\"";
        }
        Jenkins j = Jenkins.getInstance();
        String rootPath = j.getRootDir().getCanonicalPath();
        String view = ViewMapHelper.getClientView(depotPath, clientName, true);
        WorkspaceSpec spec = new WorkspaceSpec(true, true, false, false, false, false, "", "LOCAL", view, null, null, null, true);
        ManualWorkspaceImpl workspace = new ManualWorkspaceImpl("utf8", false, clientName, spec, false);
        workspace.setExpand(new HashMap<String, String>());
        workspace.setRootPath(rootPath);
        return new ClientHelper((ItemGroup)Jenkins.getInstance(), credential, (TaskListener)listener, (Workspace)workspace);
    }
}

