/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins.ssh;

import com.oracle.cloud.baremetal.jenkins.ssh.FileCreator;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.ConnectionInfo;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ServerHostKeyVerifier;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SshConnector {
    private static final Logger LOGGER = Logger.getLogger(SshConnector.class.getName());

    public static Connection createConnection(String host, int port) throws IOException, InterruptedException {
        return new Connection(host, port);
    }

    public static ConnectionInfo connect(Connection conn, int timeoutMillis, String verificationStrategy) throws IOException {
        conn.setTCPNoDelay(true);
        if (verificationStrategy.equals("No Verification")) {
            LOGGER.log(Level.INFO, "No verification strategy chosen.");
            return conn.connect((ServerHostKeyVerifier)new NoSshServerHostKeyVerifier(), timeoutMillis, timeoutMillis);
        }
        LOGGER.log(Level.INFO, "Known host verification strategy chosen.");
        return conn.connect((ServerHostKeyVerifier)new VerifySshServerHostKeyVerifier(), timeoutMillis, timeoutMillis);
    }

    static class VerifySshServerHostKeyVerifier
    implements ServerHostKeyVerifier {
        VerifySshServerHostKeyVerifier() {
        }

        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException, InterruptedException {
            KnownHosts knownHosts;
            int fingerprintMatch;
            File knownhostsfile = new File("./known_hosts");
            if (!knownhostsfile.exists()) {
                FileCreator fc = new FileCreator();
                fc.createfilename = "known_hosts";
                try {
                    fc.createFileOnMaster();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                knownhostsfile = new File("./known_hosts");
                if (!knownhostsfile.exists()) {
                    throw new RuntimeException("No known host file to verify");
                }
            }
            if ((fingerprintMatch = (knownHosts = new KnownHosts(knownhostsfile)).verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey)) == 0) {
                return true;
            }
            if (fingerprintMatch == 1) {
                String[] hostnames = new String[]{hostname};
                KnownHosts.addHostkeyToFile((File)knownhostsfile, (String[])hostnames, (String)serverHostKeyAlgorithm, (byte[])serverHostKey);
                return true;
            }
            return false;
        }
    }

    static class NoSshServerHostKeyVerifier
    implements ServerHostKeyVerifier {
        NoSshServerHostKeyVerifier() {
        }

        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) {
            return true;
        }
    }
}

