/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.oracle.bmc.core.model.Instance;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudAgent;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudAgentTemplate;
import com.oracle.cloud.baremetal.jenkins.Clock;
import com.oracle.cloud.baremetal.jenkins.JenkinsUtil;
import com.oracle.cloud.baremetal.jenkins.Messages;
import com.oracle.cloud.baremetal.jenkins.TimeoutHelper;
import com.oracle.cloud.baremetal.jenkins.client.BaremetalCloudClient;
import com.oracle.cloud.baremetal.jenkins.client.BaremetalCloudClientFactory;
import com.oracle.cloud.baremetal.jenkins.client.SDKBaremetalCloudClientFactory;
import com.oracle.cloud.baremetal.jenkins.credentials.BaremetalCloudCredentials;
import com.oracle.cloud.baremetal.jenkins.retry.LinearRetry;
import com.oracle.cloud.baremetal.jenkins.retry.Retry;
import com.oracle.cloud.baremetal.jenkins.ssh.SshConnector;
import com.trilead.ssh2.Connection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.security.ACL;
import hudson.slaves.AbstractCloudImpl;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class BaremetalCloud
extends AbstractCloudImpl {
    private static final Logger LOGGER = Logger.getLogger(BaremetalCloud.class.getName());
    public static final String NAME_PREFIX = "oci-compute-";
    private static final long START_POLL_SLEEP_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    public static final String INSTANCE_NAME_PREFIX = "jenkins-";
    private static final String JENKINS_IP = BaremetalCloud.getJenkinsIp();
    private final String credentialsId;
    private final String maxAsyncThreads;
    private final int nextTemplateId;
    private final List<? extends BaremetalCloudAgentTemplate> templates;
    static final String PROVISION_ATTR_AGENT_NAME = BaremetalCloud.class.getName() + ".name";
    static final String PROVISION_ATTR_NUM_EXECUTORS = BaremetalCloud.class.getName() + ".numExecutors";

    static String cloudNameToName(String cloudName) {
        return NAME_PREFIX + cloudName.trim();
    }

    static String nameToCloudName(String name) {
        return name.substring(NAME_PREFIX.length());
    }

    @DataBoundConstructor
    public BaremetalCloud(String cloudName, String credentialsId, String instanceCapStr, String maxAsyncThreads, int nextTemplateId, List<? extends BaremetalCloudAgentTemplate> templates) {
        super(BaremetalCloud.cloudNameToName(cloudName), instanceCapStr);
        this.credentialsId = credentialsId;
        this.maxAsyncThreads = maxAsyncThreads;
        this.nextTemplateId = nextTemplateId;
        this.templates = templates == null ? Collections.emptyList() : templates;
    }

    public String getDisplayName() {
        return this.getCloudName();
    }

    public String getCloudName() {
        return BaremetalCloud.nameToCloudName(this.name);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getMaxAsyncThreads() {
        return this.maxAsyncThreads;
    }

    public int getNextTemplateId() {
        return this.nextTemplateId;
    }

    public List<? extends BaremetalCloudAgentTemplate> getTemplates() {
        return this.templates;
    }

    ExecutorService getThreadPoolForRemoting() {
        return Computer.threadPoolForRemoting;
    }

    private String fmtLogMsg(String msg) {
        return "OCI cloud \"" + this.getCloudName() + "\": " + msg;
    }

    private static String getJenkinsIp() {
        String IP = "";
        try {
            IP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            LOGGER.info("Failed to get Jenkins IP address: " + e.getMessage());
        }
        return IP;
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        BaremetalCloudAgentTemplate template = this.getTemplate(label);
        if (template == null) {
            return Collections.emptyList();
        }
        LOGGER.info(this.fmtLogMsg("requested Agent provision excessWorkload: " + excessWorkload));
        ArrayList<NodeProvisioner.PlannedNode> plannedNodes = new ArrayList<NodeProvisioner.PlannedNode>();
        boolean templateInstanceCapInvalid = false;
        if (template.getInstanceCap() == null || template.getInstanceCap().isEmpty()) {
            templateInstanceCapInvalid = true;
        } else if (Integer.parseInt(template.getInstanceCap()) >= this.getInstanceCap()) {
            templateInstanceCapInvalid = true;
        }
        while (excessWorkload > 0 && plannedNodes.size() + this.getNodeCount() < this.getInstanceCap() && (templateInstanceCapInvalid || plannedNodes.size() + this.getTemplateNodeCount(template.getTemplateId()) < Integer.parseInt(template.getInstanceCap()))) {
            Provisioner provisioner = new Provisioner(template);
            String displayName = provisioner.getPlannedNodeDisplayName();
            Future<Node> future = this.getThreadPoolForRemoting().submit(provisioner);
            int numExecutors = provisioner.numExecutors;
            plannedNodes.add(new BaremetalCloudPlannedNode(displayName, future, numExecutors, this.name, template.getTemplateId()));
            excessWorkload -= numExecutors;
        }
        LOGGER.info(this.fmtLogMsg(plannedNodes.size() + " FutureNodes to be added to provisioning queue"));
        return plannedNodes;
    }

    private BaremetalCloudAgent provision(String name, BaremetalCloudAgentTemplate template, String instanceName) throws Exception {
        LOGGER.info("Provisioning new cloud infrastructure instance");
        boolean using_stopped_instance = false;
        try {
            BaremetalCloudClient client = this.getClient();
            Instance instance = null;
            if (!template.getStopOnIdle().booleanValue()) {
                instance = client.createInstance(instanceName, template);
            } else {
                List<Instance> allStoppedInstances = client.getStoppedInstances(template.getCompartmentId(), template.getAvailableDomain());
                if (!allStoppedInstances.isEmpty()) {
                    String searchName = template.getInstanceNamePrefix() == null || template.getInstanceNamePrefix().isEmpty() ? INSTANCE_NAME_PREFIX + JENKINS_IP + "-" : INSTANCE_NAME_PREFIX + template.getInstanceNamePrefix() + "-" + JENKINS_IP + "-";
                    long numberOfSuitableInstances = allStoppedInstances.stream().filter(n -> n.getDisplayName().contains(searchName)).filter(n -> n.getShape().equals(template.getShape())).filter(n -> n.getImageId().equals(template.getImage())).count();
                    if (numberOfSuitableInstances > 0L) {
                        String instanceId = allStoppedInstances.stream().filter(n -> n.getDisplayName().contains(searchName)).filter(n -> n.getShape().equals(template.getShape())).filter(n -> n.getImageId().equals(template.getImage())).findAny().get().getId();
                        using_stopped_instance = true;
                        instance = client.startInstance(instanceId);
                        instanceName = instance.getDisplayName();
                        name = NAME_PREFIX + instance.getDisplayName().replace(searchName, "");
                    } else {
                        instance = client.createInstance(instanceName, template);
                    }
                } else {
                    instance = client.createInstance(instanceName, template);
                }
            }
            String Ip = "";
            TimeoutHelper timeoutHelper = new TimeoutHelper(this.getClock(), template.getStartTimeoutNanos(), START_POLL_SLEEP_MILLIS);
            try {
                client.waitForInstanceProvisioningToComplete(instance.getId());
                Ip = client.getInstanceIp(template, instance.getId());
                LOGGER.info("Provisioned instance " + instanceName + " with ip " + Ip);
                this.awaitInstanceSshAvailable(Ip, template.getSshConnectTimeoutMillis(), timeoutHelper);
                template.setTemplateSleep(false);
                template.resetFailureCount();
            }
            catch (BmcGenericWaiter.WaitConditionFailedException | IOException | RuntimeException ex) {
                if (using_stopped_instance) {
                    LOGGER.log(Level.WARNING, "Provision node: " + instanceName + " failed for stopped node. Check credentials.", ex);
                    try {
                        this.stopCloudResources(instance.getId());
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Stopping failed node failed", e);
                    }
                } else {
                    try {
                        this.recycleCloudResources(instance.getId());
                        LOGGER.log(Level.WARNING, "Provision node: " + instanceName + " failed, and created resources have been recycled.", ex);
                    }
                    catch (IOException | RuntimeException e2) {
                        LOGGER.log(Level.WARNING, "Provision node: " + instanceName + " failed, and failed to recycle node " + instanceName, ex);
                    }
                }
                throw ex;
            }
            return this.newBaremetalCloudAgent(name, template, this.name, instance.getId(), Ip);
        }
        catch (IOException | RuntimeException e) {
            String cause;
            String message = e.getMessage();
            String string = cause = message != null ? message : e.toString();
            if (!template.isTemplateSleep()) {
                template.increaseFailureCount(cause);
            }
            if (template.doNotDisable == null) {
                LOGGER.log(Level.INFO, "DoNotDisable option is null. Go to template config, if you wish to change.");
                throw e;
            }
            if (!template.getDoNotDisable().booleanValue()) {
                throw e;
            }
            LOGGER.log(Level.WARNING, e.toString());
            template.setTemplateSleep(true);
            LOGGER.log(Level.WARNING, "Since do not disable option is selected, this particular template will sleep for {0} minutes before re-trying any provisioning: " + template.getDisplayName(), template.getRetryTimeoutMins());
            template.setSleepStartTime(System.currentTimeMillis());
            throw e;
        }
    }

    public synchronized void recycleCloudResources(String instanceId) throws IOException {
        BaremetalCloudClient client = this.getClient();
        Retry<String> retry = this.getTerminationRetry(() -> client.terminateInstance(instanceId));
        try {
            retry.run();
            client.waitForInstanceTerminationToComplete(instanceId);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public synchronized void stopCloudResources(String instanceId) throws IOException {
        BaremetalCloudClient client = this.getClient();
        Retry<String> retry = this.getTerminationRetry(() -> client.stopInstance(instanceId));
        try {
            retry.run();
            client.waitForInstanceTerminationToComplete(instanceId);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Retry<String> getTerminationRetry(Callable<String> task) {
        return new LinearRetry<String>(task);
    }

    Clock getClock() {
        return Clock.INSTANCE;
    }

    BaremetalCloudAgent newBaremetalCloudAgent(String name, BaremetalCloudAgentTemplate template, String cloudName, String instanceId, String host) throws IOException, Descriptor.FormException {
        return new BaremetalCloudAgent(name, template, cloudName, instanceId, host);
    }

    public BaremetalCloudAgentTemplate getTemplate(Label label) {
        for (BaremetalCloudAgentTemplate baremetalCloudAgentTemplate : this.templates) {
            if (baremetalCloudAgentTemplate.getDisableCause() != null || baremetalCloudAgentTemplate.isTemplateSleep()) {
                if (baremetalCloudAgentTemplate.getDisableCause() != null) {
                    LOGGER.log(Level.FINER, "Template is disabled, cause: " + baremetalCloudAgentTemplate.getDisableCause());
                    continue;
                }
                LOGGER.log(Level.FINER, "Template encountered a failure, now waiting before retry." + baremetalCloudAgentTemplate.getDisplayName());
                continue;
            }
            if (!(baremetalCloudAgentTemplate.getMode() == Node.Mode.NORMAL ? label == null || label.matches(baremetalCloudAgentTemplate.getLabelAtoms()) : baremetalCloudAgentTemplate.getMode() == Node.Mode.EXCLUSIVE && label != null && label.matches(baremetalCloudAgentTemplate.getLabelAtoms()))) continue;
            return baremetalCloudAgentTemplate;
        }
        return null;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void doProvisionArguments(@QueryParameter int templateId, StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.checkPermission(PROVISION);
        req.setAttribute("PROVISION_TEMPLATE_ID", (Object)templateId);
        req.getView((Object)this, "provisionArguments").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void doProvision(@QueryParameter int numberOfComputers, @QueryParameter int templateId, StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        BaremetalCloudAgentTemplate template = this.getTemplateById(templateId);
        StringBuilder sbNames = new StringBuilder();
        int numExecutors = 0;
        for (int i = 0; i < numberOfComputers; ++i) {
            if (template == null) {
                this.sendError(Messages.BaremetalCloud_provision_templateNotFound(), req, rsp);
                return;
            }
            if (template.getDisableCause() != null) {
                this.sendError(Messages.BaremetalCloud_provision_templateDisabled(), req, rsp);
                return;
            }
            ExplicitProvisioner provisioner = new ExplicitProvisioner(template);
            this.getThreadPoolForRemoting().submit(provisioner);
            sbNames.append(provisioner.name).append(" ");
            numExecutors = provisioner.numExecutors;
        }
        req.setAttribute(PROVISION_ATTR_AGENT_NAME, (Object)sbNames.toString());
        req.setAttribute(PROVISION_ATTR_NUM_EXECUTORS, (Object)numExecutors);
        req.getView((Object)this, "provision").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public int getTemplateId(HttpServletRequest req) {
        return (Integer)req.getAttribute("PROVISION_TEMPLATE_ID");
    }

    void addNode(Node node) throws IOException {
        JenkinsUtil.getJenkinsInstance().addNode(node);
    }

    private BaremetalCloudAgentTemplate getTemplateById(int templateId) {
        for (BaremetalCloudAgentTemplate baremetalCloudAgentTemplate : this.templates) {
            if (baremetalCloudAgentTemplate.getTemplateId() != templateId) continue;
            return baremetalCloudAgentTemplate;
        }
        return null;
    }

    public Class<?> getProvisionSidePanelClass() {
        return ComputerSet.class;
    }

    public String getProvisionStartedMessage(HttpServletRequest req) {
        String name = (String)req.getAttribute(PROVISION_ATTR_AGENT_NAME);
        Integer numExecutors = (Integer)req.getAttribute(PROVISION_ATTR_NUM_EXECUTORS);
        return Messages.BaremetalCloud_provision_started(name, numExecutors);
    }

    public HttpResponse doIndex() throws IOException {
        return HttpResponses.redirectTo((String)"../../computer/");
    }

    public BaremetalCloudClient getClient() {
        BaremetalCloudClientFactory factory = SDKBaremetalCloudClientFactory.INSTANCE;
        return factory.createClient(this.credentialsId, Integer.parseInt(this.maxAsyncThreads));
    }

    private synchronized int getNodeCount() {
        long count = 0L;
        Jenkins jenkins = JenkinsUtil.getJenkinsInstance();
        count += jenkins.getNodes().stream().filter(n -> n instanceof BaremetalCloudAgent).filter(n -> ((BaremetalCloudAgent)n).cloudName.equals(this.name)).peek(n -> LOGGER.fine(this.fmtLogMsg("Peeking provisioned nodes: " + n.getNodeName()))).count();
        LOGGER.info(this.fmtLogMsg("Found " + (count += Stream.concat(jenkins.unlabeledNodeProvisioner.getPendingLaunches().stream(), jenkins.getLabels().stream().flatMap(l -> l.nodeProvisioner.getPendingLaunches().stream())).filter(pn -> pn instanceof BaremetalCloudPlannedNode).filter(pn -> ((BaremetalCloudPlannedNode)((Object)pn)).getCloudName().equals(this.name)).peek(pn -> LOGGER.fine(this.fmtLogMsg("Peeking provisioning nodes: " + ((BaremetalCloudPlannedNode)pn).displayName))).count()) + " provisioned or provisioning Nodes"));
        return Math.toIntExact(count);
    }

    protected synchronized int getTemplateNodeCount(int templateId) {
        long count = 0L;
        Jenkins jenkins = JenkinsUtil.getJenkinsInstance();
        BaremetalCloudAgentTemplate template = this.getTemplateById(templateId);
        count += jenkins.getNodes().stream().filter(n -> n instanceof BaremetalCloudAgent).filter(n -> ((BaremetalCloudAgent)n).cloudName.equals(this.name)).filter(n -> ((BaremetalCloudAgent)n).templateId == templateId).peek(n -> LOGGER.fine(this.fmtLogMsg("Peeking provisioned nodes: " + n.getNodeName()))).count();
        String tempCap = template.getInstanceCap();
        String maxCap = tempCap == null || tempCap.isEmpty() ? "NA" : tempCap;
        LOGGER.fine(this.fmtLogMsg("Found " + (count += Stream.concat(jenkins.unlabeledNodeProvisioner.getPendingLaunches().stream(), jenkins.getLabels().stream().flatMap(l -> l.nodeProvisioner.getPendingLaunches().stream())).filter(pn -> pn instanceof BaremetalCloudPlannedNode).filter(pn -> ((BaremetalCloudPlannedNode)((Object)pn)).getCloudName().equals(this.name)).filter(pn -> ((BaremetalCloudPlannedNode)((Object)pn)).getTemplateId() == templateId).peek(pn -> LOGGER.fine(this.fmtLogMsg("Peeking provisioning nodes: " + ((BaremetalCloudPlannedNode)pn).displayName))).count()) + " provisioned or provisioning Nodes for the template " + template.getDisplayName() + ". Max Cap: " + maxCap));
        return Math.toIntExact(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitInstanceSshAvailable(String host, int connectTimeoutMillis, TimeoutHelper timeoutHelper) throws IOException, InterruptedException {
        do {
            try (Connection connection = SshConnector.createConnection(host, 22);){
                SshConnector.connect(connection, connectTimeoutMillis, "No Verification");
                return;
            }
        } while (timeoutHelper.sleep());
        throw new IOException("Timed out connecting to SSH");
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    public static Credentials matchCredentials(Class c, String id) {
        return CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials((Class)c, (ItemGroup)Jenkins.getInstanceOrNull(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Oracle Cloud Infrastructure Compute";
        }

        List<? extends Cloud> getClouds() {
            return JenkinsUtil.getJenkinsInstance().clouds;
        }

        public FormValidation doCheckCloudName(@QueryParameter String value) {
            value = value.trim();
            try {
                Jenkins.checkGoodName((String)value);
            }
            catch (Failure e) {
                return FormValidation.error((String)e.getMessage());
            }
            String name = BaremetalCloud.cloudNameToName(value);
            int found = 0;
            for (Cloud cloud : this.getClouds()) {
                if (!cloud.name.equals(name)) continue;
                ++found;
            }
            if (found > 1) {
                return FormValidation.error((String)Messages.BaremetalCloud_cloudName_duplicate(value));
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            Jenkins instance = Jenkins.getInstanceOrNull();
            if (context != null && instance != null ? !context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM) : instance != null && !instance.hasPermission(Jenkins.ADMINISTER)) {
                return result.includeCurrentValue(credentialsId);
            }
            ArrayList domainRequirements = new ArrayList();
            return result.includeMatchingAs(ACL.SYSTEM, context, BaremetalCloudCredentials.class, domainRequirements, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(BaremetalCloudCredentials.class)}));
        }

        public static FormValidation withContext(FormValidation fv, String context) {
            return FormValidation.error((String)(JenkinsUtil.unescape(fv.getMessage()) + ": " + context));
        }
    }

    private class ExplicitProvisioner
    extends Provisioner {
        ExplicitProvisioner(BaremetalCloudAgentTemplate template) {
            super(template);
        }

        @Override
        public Node call() throws Exception {
            String displayName = this.getPlannedNodeDisplayName();
            try {
                BaremetalCloud.this.addNode(super.call());
                LOGGER.log(Level.INFO, "{0} provisioning successfully completed via Nodes screen", displayName);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, displayName + " provisioning via Nodes screen failed!", e);
            }
            return null;
        }
    }

    private class BaremetalCloudPlannedNode
    extends NodeProvisioner.PlannedNode {
        private final String cloudName;
        private final int templateId;

        public BaremetalCloudPlannedNode(String displayName, Future<Node> future, int numExecutors, String cloudName, int templateId) {
            super(displayName, future, numExecutors);
            this.cloudName = cloudName;
            this.templateId = templateId;
        }

        public String getCloudName() {
            return this.cloudName;
        }

        public int getTemplateId() {
            return this.templateId;
        }
    }

    private class Provisioner
    implements Callable<Node> {
        final BaremetalCloudAgentTemplate template;
        final int numExecutors;
        final String name;
        final String instanceName;

        Provisioner(BaremetalCloudAgentTemplate template) {
            this.template = template;
            this.numExecutors = template.getNumExecutorsValue();
            UUID uuid = UUID.randomUUID();
            this.name = BaremetalCloud.NAME_PREFIX + uuid;
            this.instanceName = template.getInstanceNamePrefix() == null || template.getInstanceNamePrefix().isEmpty() ? BaremetalCloud.INSTANCE_NAME_PREFIX + JENKINS_IP + "-" + uuid : BaremetalCloud.INSTANCE_NAME_PREFIX + template.getInstanceNamePrefix() + "-" + JENKINS_IP + "-" + uuid;
        }

        public String getPlannedNodeDisplayName() {
            return this.instanceName;
        }

        @Override
        public Node call() throws Exception {
            return BaremetalCloud.this.provision(this.name, this.template, this.instanceName);
        }
    }
}

