/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins.ssh;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloud;
import com.oracle.cloud.baremetal.jenkins.JenkinsUtil;
import com.oracle.cloud.baremetal.jenkins.retry.LinearRetry;
import com.oracle.cloud.baremetal.jenkins.ssh.SshConnector;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.ConnectionInfo;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class SshComputerLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(SshComputerLauncher.class.getName());
    public static final String DEFAULT_SSH_USER = "opc";
    public static final int DEFAULT_SSH_PORT = 22;
    public static final String DEFAULT_SSH_PUBLIC_KEY = " ";
    private final String host;
    private final int sshPort;
    private final String sshUser;
    private final int connectTimeoutMillis;
    private final String privateKey;
    private final String jenkinsAgentUser;
    private final String initScript;
    private final int initScriptTimeoutSeconds;
    private transient SSHUserPrivateKey sshCredentials;

    public SshComputerLauncher(String host, int connectTimeoutMillis, String jenkinsAgentUser, String initScript, int initScriptTimeoutSeconds, String sshCredentialsId) {
        this(host, connectTimeoutMillis, jenkinsAgentUser, initScript, initScriptTimeoutSeconds, sshCredentialsId, 22);
    }

    public SshComputerLauncher(String host, int connectTimeoutMillis, String jenkinsAgentUser, String initScript, int initScriptTimeoutSeconds, String sshCredentialsId, int sshPort) {
        this.sshCredentials = (SSHUserPrivateKey)BaremetalCloud.matchCredentials(SSHUserPrivateKey.class, sshCredentialsId);
        this.host = host;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.privateKey = this.sshCredentials != null ? this.sshCredentials.getPrivateKey() : DEFAULT_SSH_PUBLIC_KEY;
        this.jenkinsAgentUser = jenkinsAgentUser;
        this.initScript = initScript;
        this.initScriptTimeoutSeconds = initScriptTimeoutSeconds;
        this.sshUser = this.sshCredentials != null ? this.sshCredentials.getUsername() : DEFAULT_SSH_USER;
        this.sshPort = sshPort;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        Connection connection = null;
        try {
            connection = this.connect(listener);
            this.authenticate(connection, listener);
            String workingDirectory = this.getRemoteWorkingDirectory(computer);
            this.createRemoteDirectory(connection, workingDirectory, listener);
            this.runInitScript(connection, workingDirectory, listener);
            this.ensureJavaInstalled(connection, listener);
            this.copyAgentJar(connection, workingDirectory, listener);
            this.launchAgent(connection, workingDirectory, computer, listener);
        }
        catch (IOException | InterruptedException e) {
            this.tearDownConnection(connection, listener);
            listener.fatalError("SSH Agent launch failed on: " + this.sshUser + "@" + this.host + ":" + this.sshPort);
            throw e;
        }
    }

    private Connection connect(TaskListener listener) throws IOException, InterruptedException {
        String uri = this.sshUser + "@" + this.host + ":" + this.sshPort;
        listener.getLogger().println("Connecting to ssh: " + uri);
        try {
            Connection connection = SshConnector.createConnection(this.host, this.sshPort);
            new LinearRetry<ConnectionInfo>(() -> SshConnector.connect(connection, this.connectTimeoutMillis)).run();
            return connection;
        }
        catch (Exception e) {
            listener.fatalError("Failed to connect to ssh: " + uri);
            throw new IOException(e);
        }
    }

    private void authenticate(Connection connection, TaskListener listener) throws IOException {
        listener.getLogger().println("Authenticating with private key");
        try {
            boolean authenticated = connection.authenticateWithPublicKey(this.sshUser, this.privateKey.toCharArray(), null);
            if (!authenticated) {
                throw new IOException("SSH launch failed at authenticating to host: " + this.host);
            }
        }
        catch (IOException e) {
            listener.fatalError("Failed to authenticate");
            throw e;
        }
    }

    private void ensureJavaInstalled(Connection connection, TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Verifying that Java is installed");
        int ret = connection.exec("java -fullversion", (OutputStream)listener.getLogger());
        if (ret != 0) {
            listener.fatalError("Agent does not have java installed");
            throw new IOException("Agent does not have java installed: " + this.host);
        }
    }

    private String getRemoteWorkingDirectory(SlaveComputer computer) {
        Slave agent = computer.getNode();
        if (agent == null || agent.getRemoteFS().trim().isEmpty()) {
            return ".";
        }
        return agent.getRemoteFS();
    }

    private void createRemoteDirectory(Connection connection, String remoteDirectory, TaskListener listener) throws IOException, InterruptedException {
        try {
            connection.exec("mkdir -p \"" + remoteDirectory + "\"", (OutputStream)listener.getLogger());
        }
        catch (IOException | InterruptedException e) {
            listener.fatalError("Failed to create remote working directory: " + remoteDirectory);
            throw e;
        }
    }

    private void runInitScript(Connection connection, String remoteDirectory, TaskListener listener) throws InterruptedException, IOException {
        if (this.initScript == null || this.initScript.trim().length() <= 0) {
            listener.getLogger().println("No init script to copy to remote agent");
            return;
        }
        listener.getLogger().println("Copying init script to remote agent using scp");
        try {
            SCPClient scp = connection.createSCPClient();
            scp.put(this.initScript.getBytes("UTF-8"), "init.sh", remoteDirectory, "0700");
        }
        catch (IOException e) {
            listener.fatalError("Failed to copy init script");
            throw e;
        }
        listener.getLogger().println("Running init script on remote agent");
        try (Session initSession = null;){
            initSession = connection.openSession();
            initSession.requestDumbPTY();
            String initIndicatorFile = "~/.hudson-run-init";
            String initCommand = "/bin/bash -c \"if [[ -e ~/.hudson-run-init ]]; then  echo 'Agent already initialized '~/.hudson-run-init exists;else  echo 'Running init script on agent';  /bin/bash " + remoteDirectory + "/init.sh;  echo Creating " + "~/.hudson-run-init" + " on agent;  touch " + "~/.hudson-run-init" + ";fi\"";
            initSession.execCommand(initCommand);
            IOUtils.copy((InputStream)initSession.getStdout(), (OutputStream)listener.getLogger());
            IOUtils.copy((InputStream)initSession.getStderr(), (OutputStream)listener.getLogger());
            initSession.getStdin().close();
            initSession.getStderr().close();
            int exitStatus = this.waitCompletion(initSession);
            if (exitStatus != 0) {
                String msg = "Init script on " + this.host + " finished with non-zero exit status: " + exitStatus;
                listener.getLogger().println(msg);
                throw new IOException(msg);
            }
        }
    }

    private void copyAgentJar(Connection connection, String remoteDirectory, TaskListener listener) throws IOException {
        String deleteString = "sudo rm -f " + remoteDirectory + "/slave.jar";
        listener.getLogger().println("Deleting remote slave.jar if it exists prior to copy [" + deleteString + "]");
        try (Session deleteSession = null;){
            deleteSession = connection.openSession();
            deleteSession.requestDumbPTY();
            deleteSession.execCommand(deleteString);
            deleteSession.getStdin().close();
            IOUtils.copy((InputStream)deleteSession.getStderr(), (OutputStream)listener.getLogger());
            IOUtils.copy((InputStream)deleteSession.getStdout(), (OutputStream)listener.getLogger());
        }
        listener.getLogger().println("Copying slave.jar to remote agent using scp");
        try {
            SCPClient scp = connection.createSCPClient();
            scp.put(JenkinsUtil.getJenkinsInstance().getJnlpJars("slave.jar").readFully(), "slave.jar", remoteDirectory);
        }
        catch (IOException e) {
            listener.fatalError("Failed to copy slave.jar");
            throw e;
        }
    }

    private void launchAgent(final Connection connection, String remoteDirectory, SlaveComputer computer, final TaskListener listener) throws IOException, InterruptedException {
        String jarfile = remoteDirectory + "/slave.jar";
        String launchString = "java -jar " + jarfile;
        if (this.jenkinsAgentUser == null || this.jenkinsAgentUser.trim().isEmpty()) {
            listener.getLogger().println("Jenkins Agent User is empty, default opc.");
        } else {
            launchString = "sudo chown " + this.jenkinsAgentUser + DEFAULT_SSH_PUBLIC_KEY + jarfile + " && sudo -u " + this.jenkinsAgentUser + DEFAULT_SSH_PUBLIC_KEY + launchString;
        }
        listener.getLogger().println("Launching Agent (via Trilead SSH2 Connection): " + launchString);
        final Session session = connection.openSession();
        try {
            session.execCommand(launchString);
            computer.setChannel(session.getStdout(), session.getStdin(), (OutputStream)listener.getLogger(), new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    SshComputerLauncher.this.tearDownSession(session, listener);
                    SshComputerLauncher.this.tearDownConnection(connection, listener);
                }
            });
        }
        catch (IOException | InterruptedException e) {
            this.tearDownSession(session, listener);
            listener.fatalError("Failed to launch Agent");
            throw e;
        }
    }

    private int waitCompletion(Session session) throws InterruptedException {
        LOGGER.info("Timeout around for init script complete is " + this.initScriptTimeoutSeconds);
        for (int i = 0; i < this.initScriptTimeoutSeconds; ++i) {
            Integer r = session.getExitStatus();
            if (r != null) {
                return r;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return -1;
    }

    private void tearDownSession(Session session, TaskListener listener) {
        if (session == null) {
            return;
        }
        this.reportSeesionTerminationReason(session, listener);
        listener.getLogger().println("Closing SSH Session to: " + this.host);
        try {
            session.getStdout().close();
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Error while closing SSH Session to: " + this.host));
        }
    }

    private void reportSeesionTerminationReason(Session session, TaskListener listener) {
        String exitSignal;
        try {
            session.waitForCondition(96, 2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Integer exitCode = session.getExitStatus();
        if (exitCode != null) {
            listener.getLogger().println("Remote Agent has terminated with exit code: " + exitCode);
        }
        if ((exitSignal = session.getExitSignal()) != null) {
            listener.getLogger().println("SSH Sesson has terminated with exit signal: " + exitCode);
        }
    }

    private void tearDownConnection(Connection connection, TaskListener listener) {
        if (connection == null) {
            return;
        }
        this.reportConnectionTerminationReason(connection, listener);
        listener.getLogger().println("Closing SSH Connection to");
        try {
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Error while closing SSH Connection to: " + this.host));
        }
    }

    private void reportConnectionTerminationReason(Connection connection, TaskListener listener) {
        Throwable cause = connection.getReasonClosedCause();
        if (cause != null) {
            cause.printStackTrace(listener.error("Connection to SSH server lost"));
        }
    }
}

