/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.operations;

import com.arkea.jenkins.openstack.exception.utils.ExceptionUtils;
import com.arkea.jenkins.openstack.heat.i18n.Messages;
import com.arkea.jenkins.openstack.heat.orchestration.template.Output;
import com.arkea.jenkins.openstack.log.ConsoleLogger;
import com.arkea.jenkins.openstack.operations.PublishEnvVar;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class EnvVarsUtils {
    private EnvVars env;
    private VariableResolver<String> vr;
    private ConsoleLogger cLog;
    private AbstractBuild<?, ?> build;

    public EnvVarsUtils(AbstractBuild<?, ?> build, BuildListener listener, ConsoleLogger cLog) {
        this.cLog = cLog;
        this.build = build;
        this.vr = build.getBuildVariableResolver();
        try {
            this.env = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException | InterruptedException e) {
            cLog.logError(Messages.environment_notFound() + e.getMessage() + ExceptionUtils.getStackTrace(e));
        }
    }

    public Map<String, String> getVars(Map<String, String> toResolves) {
        TreeMap<String, String> resolveds = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : toResolves.entrySet()) {
            resolveds.put(entry.getKey(), this.env.expand(Util.replaceMacro((String)entry.getValue(), this.vr)));
            if (entry.getValue().equals(resolveds.get(entry.getKey()))) continue;
            this.cLog.logDebug(Messages.environment_variable(entry.getKey(), entry.getValue(), resolveds.get(entry.getKey())));
        }
        return resolveds;
    }

    public String getVar(String toResolve) {
        return this.env.expand(Util.replaceMacro((String)toResolve, this.vr));
    }

    public void setVars(Map<String, Output> toPuts, Map<String, String> outputs) {
        for (Map.Entry<String, Output> entry : toPuts.entrySet()) {
            Output output = entry.getValue();
            if (!output.getValue().startsWith("$") || !outputs.containsKey(entry.getKey())) continue;
            this.cLog.logDebug(Messages.environment_output(output.getValue(), outputs.get(entry.getKey())));
            this.setVar(output.getValue().substring(1), outputs.get(entry.getKey()));
        }
    }

    public void setVar(String name, String value) {
        PublishEnvVar publish = new PublishEnvVar(name, value);
        this.build.addAction((Action)publish);
        publish.buildEnvVars(this.build, this.env);
    }

    public String getValue(String key) {
        return (String)this.env.get((Object)this.env.expand(Util.replaceMacro((String)key, this.vr)));
    }
}

