/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.orchestration.template.constraints;

import com.arkea.jenkins.openstack.heat.orchestration.template.Parameter;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.AbstractConstraint;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.ConstraintType;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;

public class RangeConstraint
extends AbstractConstraint {
    private Map<String, Double> limits = new HashMap<String, Double>();

    RangeConstraint() {
        super(ConstraintType.range);
    }

    RangeConstraint(Map<String, Double> limits, String description) {
        this();
        this.limits = limits;
        this.description = description;
    }

    public Map<String, Double> getLimits() {
        return this.limits;
    }

    public void setLimits(Map<String, Double> limits) {
        this.limits = limits;
    }

    @Override
    public boolean checkConstraint(Parameter parameter) {
        double value = 0.0;
        if (!Strings.isNullOrEmpty((String)parameter.getValue())) {
            value = Double.valueOf(parameter.getValue());
        } else if (!Strings.isNullOrEmpty((String)String.valueOf(parameter.getDefaultValue()))) {
            value = Double.valueOf(String.valueOf(parameter.getDefaultValue()));
        }
        boolean rtn = true;
        if (this.limits.containsKey("min") && value < this.limits.get("min")) {
            rtn = false;
        } else if (this.limits.containsKey("max") && value > this.limits.get("max")) {
            rtn = false;
        }
        return rtn;
    }
}

