/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.orchestration.template.constraints;

import com.arkea.jenkins.openstack.heat.orchestration.template.Parameter;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.AbstractConstraint;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.ConstraintType;
import com.google.common.base.Strings;
import java.util.regex.Pattern;

public class AllowedPatternConstraint
extends AbstractConstraint {
    private String allowed_pattern;

    public AllowedPatternConstraint() {
        super(ConstraintType.allowed_pattern);
    }

    public AllowedPatternConstraint(String allowed_pattern) {
        super(ConstraintType.allowed_pattern);
        this.allowed_pattern = allowed_pattern;
    }

    public String getAllowed_pattern() {
        return this.allowed_pattern;
    }

    public void setAllowed_pattern(String allowed_pattern) {
        this.allowed_pattern = allowed_pattern;
    }

    @Override
    public boolean checkConstraint(Parameter parameter) {
        Pattern p = Pattern.compile(this.allowed_pattern);
        if (!Strings.isNullOrEmpty((String)parameter.getValue())) {
            return p.matcher(parameter.getValue()).matches();
        }
        if (!Strings.isNullOrEmpty((String)String.valueOf(parameter.getDefaultValue()))) {
            return p.matcher(String.valueOf(parameter.getDefaultValue())).matches();
        }
        return false;
    }
}

