/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.Extension;
import hudson.Functions;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.JCloudsSlaveTemplate;
import jenkins.plugins.openstack.compute.SlaveOptions;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public final class JCloudsPreCreationThread
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(JCloudsPreCreationThread.class.getName());

    public JCloudsPreCreationThread() {
        super("OpenStack slave pre-creation");
    }

    public long getRecurrencePeriod() {
        return Functions.getIsUnitTest() ? Long.MAX_VALUE : 120000L;
    }

    public void execute(TaskListener listener) {
        for (JCloudsCloud cloud : JCloudsCloud.getClouds()) {
            for (JCloudsSlaveTemplate template : cloud.getTemplates()) {
                int runningNodeTotal;
                SlaveOptions slaveOptions = template.getEffectiveSlaveOptions();
                int instancesMin = slaveOptions.getInstancesMin();
                int retentionTime = slaveOptions.getRetentionTime();
                if (instancesMin <= 0) continue;
                int globalMaxInstances = cloud.getEffectiveSlaveOptions().getInstanceCap();
                int templateMaxInstances = slaveOptions.getInstanceCap();
                int maxNodes = Math.min(templateMaxInstances, globalMaxInstances);
                int reusableRunningNodeTotal = template.getActiveNodesTotal(retentionTime == 0);
                int desiredNewInstances = Math.min(instancesMin - reusableRunningNodeTotal, maxNodes - (runningNodeTotal = template.getActiveNodesTotal(false)));
                if (desiredNewInstances <= 0) continue;
                LOGGER.log(Level.INFO, "Pre-creating " + desiredNewInstances + " instance(s) for template " + template.name + " in cloud " + cloud.name);
                for (int i = 0; i < desiredNewInstances; ++i) {
                    try {
                        cloud.provisionSlave(template);
                        continue;
                    }
                    catch (Throwable ex) {
                        LOGGER.log(Level.SEVERE, "Failed to pre-create instance from template " + template.name, ex);
                    }
                }
            }
        }
    }

    public static boolean shouldSlaveBeRetained(JCloudsSlave slave) {
        JCloudsSlaveTemplate template;
        JCloudsCloud cloud;
        String templateName = slave.getId().getTemplateName();
        String cloudName = slave.getId().getCloudName();
        if (templateName != null && cloudName != null && (cloud = JCloudsCloud.getByName(cloudName)) != null && (template = cloud.getTemplate(templateName)) != null) {
            SlaveOptions slaveOptions = template.getEffectiveSlaveOptions();
            Integer instancesMin = slaveOptions.getInstancesMin();
            JCloudsComputer computer = (JCloudsComputer)slave.toComputer();
            Integer retentionTime = slaveOptions.getRetentionTime();
            if (instancesMin > 0 && computer != null) {
                if (retentionTime != 0 && template.getActiveNodesTotal(false) - 1 < instancesMin) {
                    return true;
                }
                if (retentionTime == 0 && !computer.isUsed() && template.getActiveNodesTotal(true) - 1 < instancesMin) {
                    return true;
                }
            }
        }
        return false;
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }

    protected Level getSlowLoggingLevel() {
        return Level.INFO;
    }
}

