/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.openshift;

import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;

public class Server {
    private String name;
    private String brokerAddress;
    private String username;
    private String password;
    private Secret secret;

    @DataBoundConstructor
    public Server(String name, String brokerAddress, String username, String password) {
        this.name = name;
        this.brokerAddress = brokerAddress;
        this.username = username;
        if (this.secret == null) {
            this.secret = Secret.fromString((String)password);
        }
        this.password = this.secret.getEncryptedValue();
    }

    public String getName() {
        return this.name;
    }

    public String getBrokerAddress() {
        return this.brokerAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return Secret.toString((Secret)this.secret);
    }
}

