/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.openshift;

import com.jcraft.jsch.Session;
import com.openshift.client.IApplication;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.jenkinsci.plugins.openshift.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitClient {
    private Logger log = Logger.NOOP;
    private IApplication app;

    public GitClient(IApplication app) {
        this.app = app;
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void deploy(List<String> deployments, File workingCopyDir, String relativeDeployDir) throws IOException, GitAPIException {
        this.deploy(deployments, workingCopyDir, relativeDeployDir, "", "");
    }

    public void deploy(List<String> deployments, File workingCopyDir, String relativeDeployDir, String commitMsg, String openshiftDirectory) throws IOException, GitAPIException {
        File[] removeList;
        if (openshiftDirectory != null && !StringUtils.isEmpty((CharSequence)openshiftDirectory) && !openshiftDirectory.startsWith(File.separator)) {
            throw new IllegalArgumentException("openshiftDirectory is not null or empty and is not an absolute path.");
        }
        this.log.info("Cloning '" + this.app.getName() + "' [" + this.app.getGitUrl() + "] to " + workingCopyDir);
        SshSessionFactory.setInstance((SshSessionFactory)new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host hc, Session session) {
                session.setConfig("StrictHostKeyChecking", "no");
            }
        });
        Git git = Git.cloneRepository().setURI(this.app.getGitUrl()).setDirectory(workingCopyDir).call();
        for (File fileToRemove : removeList = workingCopyDir.listFiles()) {
            if (fileToRemove.getName().equals(".git") || fileToRemove.getName().equals(".openshift")) continue;
            this.log.info("Deleting '" + fileToRemove.getName() + "'");
            FileUtils.forceDelete((File)fileToRemove);
        }
        File dest = new File(workingCopyDir.getAbsoluteFile() + relativeDeployDir);
        this.copyDeploymentPackages(deployments, dest);
        File dotOpenshiftSource = null;
        if (!StringUtils.isEmpty((CharSequence)openshiftDirectory)) {
            if (!openshiftDirectory.endsWith("openshift")) {
                File[] dirContents;
                File directory = new File(openshiftDirectory);
                for (File file : dirContents = directory.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return !name.equals(".") && !name.equals("..");
                    }
                })) {
                    if (!file.getName().endsWith("openshift")) continue;
                    dotOpenshiftSource = file;
                    break;
                }
            } else {
                dotOpenshiftSource = new File(openshiftDirectory);
            }
            if (dotOpenshiftSource != null && dotOpenshiftSource.exists()) {
                for (File source : dotOpenshiftSource.listFiles()) {
                    FileUtils.copyDirectoryToDirectory((File)source, (File)new File(workingCopyDir + File.separator + ".openshift"));
                }
            }
        }
        git.add().addFilepattern(".").call();
        this.log.info("Committing repo");
        git.commit().setAll(true).setMessage(commitMsg).call();
        this.log.info("Pushing to upstream");
        PushCommand pushCommand = git.push();
        pushCommand.setProgressMonitor((ProgressMonitor)new TextProgressMonitor((Writer)new OutputStreamWriter(System.out)));
        Iterable pushResults = pushCommand.call();
        for (PushResult result : pushResults) {
            System.out.println(result.toString());
        }
    }

    private void copyDeploymentPackages(List<String> deployments, File dest) throws IOException {
        if (deployments.size() == 1) {
            String deployment = deployments.get(0);
            File destFile = new File(dest, "ROOT." + FilenameUtils.getExtension((String)deployment));
            FileUtils.copyFile((File)new File(deployment), (File)destFile);
            this.log.info("Deployment '" + FilenameUtils.getName((String)deployment) + "' copied to '" + destFile.getName() + "'");
        } else {
            for (String deployment : deployments) {
                FileUtils.copyFileToDirectory((File)new File(deployment), (File)dest);
                this.log.info("Deployment '" + FilenameUtils.getName((String)deployment) + "' copied to '" + dest.getName() + "'");
            }
        }
    }
}

