/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid;

import com.cloudbees.openid4java.team.TeamExtensionFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Failure;
import hudson.plugins.openid.Identity;
import hudson.plugins.openid.OpenIdExtension;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;

public abstract class OpenIdSession {
    private final ConsumerManager manager;
    private final DiscoveryInformation endpoint;
    private final String finishUrl;
    private static final String SESSION_NAME;

    public OpenIdSession(ConsumerManager manager, DiscoveryInformation endpoint, String finishUrl) {
        this.manager = manager;
        this.endpoint = endpoint;
        this.finishUrl = finishUrl;
    }

    public OpenIdSession(ConsumerManager manager, String openid, String finishUrl) throws OpenIDException {
        this.manager = manager;
        this.finishUrl = finishUrl;
        try {
            List discoveries = manager.discover(openid);
            this.endpoint = manager.associate(discoveries);
        }
        catch (DiscoveryException e) {
            throw new DiscoveryException("Failed to discover OpenID: " + openid, e.getErrorCode(), (Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"J2EE_STORE_OF_NON_SERIALIZABLE_OBJECT_INTO_SESSION"}, justification="Just for this login.")
    public HttpResponse doCommenceLogin() throws IOException, OpenIDException {
        AuthRequest authReq = this.manager.authenticate(this.endpoint, Jenkins.get().getRootUrl() + this.finishUrl);
        OpenIdExtension.extendRequest(authReq);
        String url = authReq.getDestinationUrl(true);
        Stapler.getCurrentRequest().getSession().setAttribute(SESSION_NAME, (Object)this);
        return new HttpRedirect(url);
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException, OpenIDException {
        VerificationResult verification;
        Identifier verified;
        ParameterList responseList = new ParameterList(request.getParameterMap());
        String receivingURL = Jenkins.get().getRootUrl() + this.finishUrl;
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            receivingURL = receivingURL + '?' + request.getQueryString();
        }
        if ((verified = (verification = this.manager.verify(receivingURL, responseList, this.endpoint)).getVerifiedId()) == null) {
            throw new Failure("Failed to login: " + verification.getStatusMsg());
        }
        Message authResponse = verification.getAuthResponse();
        if (authResponse instanceof AuthSuccess) {
            AuthSuccess authSuccess = (AuthSuccess)authResponse;
            return this.onSuccess(new Identity(authSuccess));
        }
        throw new Failure("Failed to login. Authentication failed with the following response: " + authResponse);
    }

    protected abstract HttpResponse onSuccess(Identity var1) throws IOException;

    public static OpenIdSession getCurrent() {
        return (OpenIdSession)Stapler.getCurrentRequest().getSession().getAttribute(SESSION_NAME);
    }

    static {
        TeamExtensionFactory.install();
        SESSION_NAME = OpenIdSession.class.getName();
    }
}

