/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid.impl;

import com.cloudbees.openid4java.team.TeamExtensionFactory;
import com.cloudbees.openid4java.team.TeamExtensionRequest;
import com.cloudbees.openid4java.team.TeamExtensionResponse;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.plugins.openid.Identity;
import hudson.plugins.openid.OpenIdExtension;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;

@Extension
public class TeamsExtension
extends OpenIdExtension {
    private static final Logger LOGGER;
    public static boolean DISABLE;

    public void extend(AuthRequest authRequest) throws MessageException {
        if (DISABLE) {
            return;
        }
        TeamExtensionRequest req = new TeamExtensionRequest();
        Collection groups = Hudson.getInstance().getAuthorizationStrategy().getGroups();
        req.setQueryMembership(groups);
        authRequest.addExtension((MessageExtension)req);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Checking memberships of " + new ArrayList(groups) + " with OpenID");
        }
    }

    public void process(AuthSuccess authSuccess, Identity id) throws MessageException {
        if (DISABLE) {
            return;
        }
        TeamExtensionResponse ter = this.getMessageAs(TeamExtensionResponse.class, authSuccess, "http://ns.launchpad.net/2007/openid-teams");
        List<GrantedAuthority> r = id.getGrantedAuthorities();
        for (String s : ter.getTeamMembership()) {
            r.add((GrantedAuthority)new GrantedAuthorityImpl(s));
        }
        r.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding " + ter.getTeamMembership() + " as authorities from team extension to " + id.getOpenId());
        }
    }

    static {
        TeamExtensionFactory.install();
        LOGGER = Logger.getLogger(TeamsExtension.class.getName());
        DISABLE = Boolean.getBoolean(TeamsExtension.class.getName() + "disable");
    }
}

