/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.User;
import hudson.plugins.openid.Identity;
import hudson.plugins.openid.Messages;
import hudson.plugins.openid.OpenIdSession;
import hudson.plugins.openid.OpenIdSsoSecurityRealm;
import hudson.plugins.openid.OpenIdUserProperty;
import hudson.plugins.openid.YadisResolver2;
import hudson.security.FederatedLoginService;
import hudson.security.FederatedLoginServiceUserProperty;
import java.io.IOException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.server.RealmVerifierFactory;
import org.openid4java.util.HttpFetcherFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class OpenIdLoginService
extends FederatedLoginService {
    @Inject
    private transient Jenkins jenkins;
    private final ConsumerManager manager;
    private static boolean disabled = Boolean.getBoolean(OpenIdLoginService.class.getName() + ".disabled");

    public OpenIdLoginService() throws ConsumerException {
        HttpFetcherFactory fetcherFactory = new HttpFetcherFactory();
        YadisResolver2 resolver = new YadisResolver2(fetcherFactory);
        this.manager = new ConsumerManager(new RealmVerifierFactory((YadisResolver)resolver), new Discovery(), fetcherFactory);
        this.manager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
        this.manager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
        this.manager.getDiscovery().setYadisResolver((YadisResolver)resolver);
    }

    public boolean isDisabled() {
        return disabled || !((GlobalConfigurationImpl)this.jenkins.getDescriptorByType(GlobalConfigurationImpl.class)).isEnabled() || this.jenkins.getSecurityRealm() instanceof OpenIdSsoSecurityRealm;
    }

    public void setDisabled(boolean disabled) {
        OpenIdLoginService.disabled = disabled;
    }

    public String getUrlName() {
        return "openid";
    }

    public Class<? extends FederatedLoginServiceUserProperty> getUserPropertyClass() {
        return OpenIdUserProperty.class;
    }

    public HttpResponse doStartLogin(@QueryParameter String openid, @QueryParameter String openid_identifier, @QueryParameter String from) throws OpenIDException, IOException {
        if (this.isDisabled()) {
            return HttpResponses.notFound();
        }
        if (openid == null) {
            openid = openid_identifier;
        }
        return new OpenIdSession(this.manager, openid, this.getFinishUrl()){

            protected HttpResponse onSuccess(Identity identity) throws IOException {
                IdentityImpl id = new IdentityImpl(identity);
                User u = id.signin();
                id.id.updateProfile(u);
                return HttpResponses.redirectToContextRoot();
            }
        }.doCommenceLogin();
    }

    private String getFinishUrl() {
        StaplerRequest req = Stapler.getCurrentRequest();
        String contextPath = req.getContextPath();
        if (StringUtils.isBlank((String)contextPath) || "/".equals(contextPath)) {
            return "federatedLoginService/openid/finish";
        }
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)contextPath, (String)"/"), (String)"/") + "/federatedLoginService/openid/finish";
    }

    public HttpResponse doFinish(StaplerRequest request) throws IOException, OpenIDException {
        if (this.isDisabled()) {
            return HttpResponses.notFound();
        }
        OpenIdSession session = OpenIdSession.getCurrent();
        if (session == null) {
            throw new Failure(Messages.OpenIdLoginService_SessionNotFound());
        }
        return session.doFinishLogin(request);
    }

    public HttpResponse doStartAssociate(@QueryParameter String openid) throws OpenIDException, IOException {
        if (this.isDisabled()) {
            return HttpResponses.notFound();
        }
        return new OpenIdSession(this.manager, openid, this.getFinishUrl()){

            protected HttpResponse onSuccess(Identity identity) throws IOException {
                new IdentityImpl(identity).addToCurrentUser();
                return new HttpRedirect("onAssociationSuccess");
            }
        }.doCommenceLogin();
    }

    @Extension
    public static class GlobalConfigurationImpl
    extends GlobalConfiguration {
        private boolean enabled;

        public GlobalConfigurationImpl() {
            if (this.getConfigFile().exists()) {
                this.load();
            } else {
                try {
                    this.setEnabled(Jenkins.getInstance().getPlugin("openid").getWrapper().isDowngradable());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }

        public boolean isHidden() {
            return disabled;
        }

        public boolean isEnabled() {
            return this.enabled && !disabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.save();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            return true;
        }

        public GlobalConfigurationCategory getCategory() {
            return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
        }
    }

    public class IdentityImpl
    extends FederatedLoginService.FederatedIdentity {
        private final Identity id;

        public IdentityImpl(Identity id) {
            super((FederatedLoginService)OpenIdLoginService.this);
            this.id = id;
        }

        public String getIdentifier() {
            return this.id.getOpenId();
        }

        public String getNickname() {
            return this.id.getEffectiveNick();
        }

        public String getFullName() {
            return this.id.getFullName();
        }

        public String getEmailAddress() {
            return this.id.getEmail();
        }

        public String getPronoun() {
            return "OpenID";
        }
    }
}

