/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.openid.OpenIdSsoSecurityRealm;
import hudson.plugins.openid.YadisResolver2;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.server.RealmVerifierFactory;
import org.openid4java.util.HttpClientFactory;
import org.openid4java.util.HttpFetcherFactory;
import org.openid4java.util.ProxyProperties;

public class GoogleAppSsoSecurityRealm
extends OpenIdSsoSecurityRealm {
    public final String domain;
    private static final Logger LOGGER = Logger.getLogger(OpenIdSsoSecurityRealm.class.getName());

    @DataBoundConstructor
    public GoogleAppSsoSecurityRealm(String domain) throws IOException, OpenIDException {
        super("https://www.google.com/accounts/o8/site-xrds?hd=" + domain);
        this.domain = domain;
    }

    protected ConsumerManager createManager() throws ConsumerException {
        Hudson instance = Hudson.getInstance();
        if (instance.proxy != null) {
            ProxyProperties props = new ProxyProperties();
            props.setProxyHostName(instance.proxy.name);
            props.setProxyPort(instance.proxy.port);
            props.setUserName(instance.proxy.getUserName());
            props.setProxyHostName(instance.proxy.getPassword());
            HttpClientFactory.setProxyProperties((ProxyProperties)props);
        }
        HttpFetcherFactory fetcherFactory = new HttpFetcherFactory();
        YadisResolver2 resolver = new YadisResolver2(fetcherFactory);
        ConsumerManager m = new ConsumerManager(new RealmVerifierFactory((YadisResolver)resolver), new Discovery(), fetcherFactory);
        m.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
        m.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
        m.setDiscovery(new Discovery(){

            public List discover(Identifier id) throws DiscoveryException {
                if (id.getIdentifier().startsWith("http://" + GoogleAppSsoSecurityRealm.this.domain + '/') && id instanceof UrlIdentifier) {
                    String source = "https://www.google.com/accounts/o8/user-xrds?uri=" + id.getIdentifier();
                    List r = super.discover((Identifier)new UrlIdentifier(source));
                    ArrayList<DiscoveryInformation> x = new ArrayList<DiscoveryInformation>();
                    for (DiscoveryInformation discovered : r) {
                        if (discovered.getClaimedIdentifier().getIdentifier().equals(source)) {
                            discovered = new DiscoveryInformation(discovered.getOPEndpoint(), id, discovered.getDelegateIdentifier(), discovered.getVersion(), discovered.getTypes());
                        }
                        x.add(discovered);
                    }
                    return x;
                }
                return super.discover(id);
            }
        });
        m.getDiscovery().setYadisResolver((YadisResolver)resolver);
        return m;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "Google Apps SSO (with OpenID)";
        }
    }
}

