/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openstf;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.android_emulator.AndroidEmulator;
import hudson.plugins.android_emulator.SdkInstallationException;
import hudson.plugins.android_emulator.SdkInstaller;
import hudson.plugins.android_emulator.sdk.AndroidSdk;
import hudson.plugins.android_emulator.sdk.Tool;
import hudson.plugins.openstf.AndroidRemoteContext;
import hudson.plugins.openstf.Messages;
import hudson.plugins.openstf.STFConfig;
import hudson.plugins.openstf.STFException;
import hudson.plugins.openstf.STFReservedDeviceAction;
import hudson.plugins.openstf.exception.ApiFailedException;
import hudson.plugins.openstf.util.Utils;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.NullStream;
import io.swagger.client.model.DeviceListResponseDevices;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class STFBuildWrapper
extends BuildWrapper {
    private static final int STF_DEVICE_CONNECT_COMPLETE_TIMEOUT_MS = 30000;
    private static final int KILL_PROCESS_TIMEOUT_MS = 10000;
    private DescriptorImpl descriptor;
    private AndroidEmulator.DescriptorImpl emulatorDescriptor;
    public Map<String, String> deviceCondition;
    public final int deviceReleaseWaitTime;

    @DataBoundConstructor
    public STFBuildWrapper(Map<String, String> deviceCondition, int deviceReleaseWaitTime) {
        this.deviceCondition = deviceCondition;
        this.deviceReleaseWaitTime = deviceReleaseWaitTime;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        Jenkins hudsonInstance = Jenkins.getInstance();
        if (this.descriptor == null) {
            this.descriptor = (DescriptorImpl)hudsonInstance.getDescriptorByType(DescriptorImpl.class);
        }
        if (this.emulatorDescriptor == null) {
            this.emulatorDescriptor = (AndroidEmulator.DescriptorImpl)hudsonInstance.getDescriptorByType(AndroidEmulator.DescriptorImpl.class);
        }
        EnvVars envVars = hudson.plugins.android_emulator.util.Utils.getEnvironment((AbstractBuild)build, (BuildListener)listener);
        Map buildVars = build.getBuildVariables();
        String stfApiEndpoint = this.descriptor.stfApiEndpoint;
        String stfToken = this.descriptor.stfToken;
        Boolean useSpecificKey = this.descriptor.useSpecificKey;
        String adbPublicKey = this.descriptor.adbPublicKey;
        String adbPrivateKey = this.descriptor.adbPrivateKey;
        Map<String, String> deviceFilter = Utils.expandVariables(envVars, buildVars, this.deviceCondition);
        boolean ignoreCertError = this.descriptor.ignoreCertError;
        if (!Utils.validateDeviceFilter(deviceFilter)) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.INVALID_DEVICE_CONDITION_SET_IS_GIVEN());
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        Utils.setupSTFApiClient(stfApiEndpoint, ignoreCertError, stfToken);
        String androidHome = hudson.plugins.android_emulator.util.Utils.getConfiguredAndroidHome();
        String configError = this.isConfigValid(stfApiEndpoint, ignoreCertError, stfToken);
        if (configError != null) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.ERROR_MISCONFIGURED(configError));
            build.setResult(Result.NOT_BUILT);
            return null;
        }
        AndroidSdk androidSdk = hudson.plugins.android_emulator.util.Utils.getAndroidSdk((Launcher)launcher, (String)androidHome, null);
        if (androidSdk == null) {
            if (!this.emulatorDescriptor.shouldInstallSdk) {
                AndroidEmulator.log((PrintStream)logger, (String)hudson.plugins.android_emulator.Messages.SDK_TOOLS_NOT_FOUND());
                build.setResult(Result.NOT_BUILT);
                return null;
            }
            AndroidEmulator.log((PrintStream)logger, (String)hudson.plugins.android_emulator.Messages.INSTALLING_SDK());
            try {
                androidSdk = SdkInstaller.install((Launcher)launcher, (BuildListener)listener, null);
            }
            catch (SdkInstallationException ex) {
                AndroidEmulator.log((PrintStream)logger, (String)hudson.plugins.android_emulator.Messages.SDK_INSTALLATION_FAILED(), (Throwable)ex);
                build.setResult(Result.NOT_BUILT);
                return null;
            }
        }
        String displayHome = androidSdk.hasKnownRoot() ? androidSdk.getSdkRoot() : hudson.plugins.android_emulator.Messages.USING_PATH();
        AndroidEmulator.log((PrintStream)logger, (String)hudson.plugins.android_emulator.Messages.USING_SDK((Object)displayHome));
        STFConfig stfConfig = new STFConfig(useSpecificKey, adbPublicKey, adbPrivateKey, deviceFilter, this.deviceReleaseWaitTime);
        return this.doSetup(build, launcher, listener, androidSdk, stfConfig);
    }

    private BuildWrapper.Environment doSetup(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, final AndroidSdk androidSdk, final STFConfig stfConfig) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        final AndroidRemoteContext remote = new AndroidRemoteContext(build, launcher, listener, androidSdk);
        try {
            String reservedDeviceId = stfConfig.reserve();
            DeviceListResponseDevices device = Utils.getSTFDeviceById(reservedDeviceId);
            remote.setDevice(device);
            AndroidEmulator.log((PrintStream)logger, (String)Messages.SHOW_RESERVED_DEVICE_INFO(device.name, device.serial, device.sdk, device.version));
            build.addAction((Action)new STFReservedDeviceAction(this.descriptor.stfApiEndpoint, Utils.convertDeviceToMap(device)));
        }
        catch (STFException ex) {
            AndroidEmulator.log((PrintStream)logger, (String)ex.getMessage());
            build.setResult(Result.NOT_BUILT);
            if (remote.getDevice() != null) {
                this.cleanUp(stfConfig, remote);
            }
            return null;
        }
        if (stfConfig.getUseSpecificKey().booleanValue()) {
            try {
                Callable<Boolean, IOException> task = stfConfig.getAdbKeySettingTask(listener);
                VirtualChannel channel = launcher.getChannel();
                if (channel != null) {
                    channel.call(task);
                }
            }
            catch (IOException ex) {
                AndroidEmulator.log((PrintStream)logger, (String)Messages.CANNOT_CREATE_ADBKEY_FILE());
                build.setResult(Result.NOT_BUILT);
                this.cleanUp(stfConfig, remote);
                return null;
            }
        }
        Proc adbStart = remote.getToolProcStarter(Tool.ADB, "start-server").stdout((OutputStream)logger).stderr((OutputStream)logger).start();
        adbStart.joinWithTimeout(5L, TimeUnit.SECONDS, (TaskListener)listener);
        Proc adbStart2 = remote.getToolProcStarter(Tool.ADB, "start-server").stdout((OutputStream)logger).stderr((OutputStream)logger).start();
        adbStart2.joinWithTimeout(5L, TimeUnit.SECONDS, (TaskListener)listener);
        final File artifactsDir = build.getArtifactsDir();
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.CANNOT_GET_WORKSPACE_ON_THIS_BUILD());
            build.setResult(Result.FAILURE);
            this.cleanUp(stfConfig, remote);
            return null;
        }
        final FilePath logcatFile = workspace.createTextTempFile("logcat_", ".log", "", false);
        final OutputStream logcatStream = logcatFile.write();
        String logcatArgs = String.format("-s %s logcat -v time", remote.serial());
        final Proc logWriter = remote.getToolProcStarter(Tool.ADB, logcatArgs).stdout(logcatStream).stderr((OutputStream)new NullStream()).start();
        STFBuildWrapper.connect(remote);
        AndroidEmulator.log((PrintStream)logger, (String)Messages.WAITING_FOR_STF_DEVICE_CONNECT_COMPLETION());
        int connectTimeout = 30000;
        boolean connectSucceeded = this.waitForSTFDeviceConnectCompletion(connectTimeout, remote);
        if (!connectSucceeded) {
            AndroidEmulator.log((PrintStream)logger, (String)Messages.CONNECTING_STF_DEVICE_FAILED());
            build.setResult(Result.FAILURE);
            this.cleanUp(stfConfig, remote);
            return null;
        }
        Thread.sleep(5000L);
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.put("ANDROID_SERIAL", remote.serial());
                env.put("ANDROID_AVD_DEVICE", remote.serial());
                env.put("ANDROID_ADB_SERVER_PORT", Integer.toString(remote.adbServerPort()));
                env.put("ANDROID_TMP_LOGCAT_FILE", logcatFile.getRemote());
                if (androidSdk.hasKnownRoot()) {
                    env.put("JENKINS_ANDROID_HOME", androidSdk.getSdkRoot());
                    env.put("ANDROID_HOME", androidSdk.getSdkRoot());
                    env.put("PATH+SDK_TOOLS", androidSdk.getSdkRoot() + "/tools/");
                    env.put("PATH+SDK_PLATFORM_TOOLS", androidSdk.getSdkRoot() + "/platform-tools/");
                }
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                STFBuildWrapper.this.cleanUp(stfConfig, remote, logWriter, logcatFile, logcatStream, artifactsDir);
                return true;
            }
        };
    }

    private static void connect(AndroidRemoteContext remote) throws IOException, InterruptedException {
        ArgumentListBuilder adbConnectCmd = remote.getToolCommand(Tool.ADB, "connect " + remote.serial());
        remote.getProcStarter(adbConnectCmd).start().joinWithTimeout(5L, TimeUnit.SECONDS, remote.launcher().getListener());
    }

    private static void disconnect(AndroidRemoteContext remote) throws IOException, InterruptedException {
        String args = "disconnect " + remote.serial();
        ArgumentListBuilder adbDisconnectCmd = remote.getToolCommand(Tool.ADB, args);
        remote.getProcStarter(adbDisconnectCmd).start().joinWithTimeout(5L, TimeUnit.SECONDS, remote.launcher().getListener());
    }

    private void cleanUp(STFConfig stfConfig, AndroidRemoteContext remote) throws IOException, InterruptedException {
        this.cleanUp(stfConfig, remote, null, null, null, null);
    }

    private void cleanUp(STFConfig stfConfig, AndroidRemoteContext remote, Proc logcatProcess, FilePath logcatFile, OutputStream logcatStream, File artifactsDir) throws IOException, InterruptedException {
        STFBuildWrapper.disconnect(remote);
        try {
            stfConfig.release(remote.getDevice());
        }
        catch (STFException ex) {
            AndroidEmulator.log((PrintStream)remote.logger(), (String)ex.getMessage());
        }
        if (logcatProcess != null) {
            if (logcatProcess.isAlive()) {
                Thread.sleep(3000L);
                if (logcatProcess.isAlive()) {
                    hudson.plugins.android_emulator.util.Utils.killProcess((Proc)logcatProcess, (int)10000);
                }
            }
            try {
                logcatStream.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (logcatFile.length() != 0L) {
                AndroidEmulator.log((PrintStream)remote.logger(), (String)hudson.plugins.android_emulator.Messages.ARCHIVING_LOG());
                logcatFile.copyTo(new FilePath(artifactsDir).child("logcat.txt"));
            }
            logcatFile.delete();
        }
        ArgumentListBuilder adbKillCmd = remote.getToolCommand(Tool.ADB, "kill-server");
        remote.getProcStarter(adbKillCmd).join();
        remote.cleanUp();
    }

    private String isConfigValid(String stfApiEndpoint, boolean ignoreCertError, String stfToken) {
        if (stfApiEndpoint == null || stfApiEndpoint.equals("")) {
            return Messages.API_ENDPOINT_URL_NOT_SET();
        }
        FormValidation result = this.descriptor.doCheckSTFApiEndpoint(stfApiEndpoint, ignoreCertError);
        if (FormValidation.Kind.ERROR == result.kind) {
            return result.getMessage();
        }
        result = this.descriptor.doCheckSTFToken(stfApiEndpoint, ignoreCertError, stfToken);
        if (FormValidation.Kind.ERROR == result.kind) {
            return result.getMessage();
        }
        return null;
    }

    private boolean waitForSTFDeviceConnectCompletion(int timeout, AndroidRemoteContext remote) {
        long start = System.currentTimeMillis();
        int sleep = timeout / (int)(Math.sqrt((double)timeout / 1000.0) * 2.0);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArgumentListBuilder adbDevicesCmd = remote.getToolCommand(Tool.ADB, "devices");
        boolean shownUnauthorizedOnce = false;
        try {
            while (System.currentTimeMillis() < start + (long)timeout) {
                remote.getProcStarter(adbDevicesCmd).stdout((OutputStream)out).stderr((OutputStream)out).start().joinWithTimeout(5L, TimeUnit.SECONDS, remote.launcher().getListener());
                int unauthorized = 0;
                String devicesResult = out.toString(Utils.getDefaultCharset().displayName());
                String lineSeparator = Computer.currentComputer().getSystemProperties().get("line.separator").toString();
                for (String line : devicesResult.split(lineSeparator)) {
                    if (line == null) continue;
                    if (line.contains(remote.serial()) && line.contains("device")) {
                        return true;
                    }
                    if (!line.contains(remote.serial()) || !line.contains("unauthorized") || ++unauthorized != 4 || shownUnauthorizedOnce) continue;
                    AndroidEmulator.log((PrintStream)remote.logger(), (String)Messages.DEVICE_UNAUTHORIZED());
                    shownUnauthorizedOnce = true;
                }
                Thread.sleep(sleep);
            }
        }
        catch (InterruptedException ex) {
            AndroidEmulator.log((PrintStream)remote.logger(), (String)Messages.INTERRUPTED_DURING_STF_DEVICE_CONNECT_COMPLETION());
        }
        catch (IOException ex) {
            AndroidEmulator.log((PrintStream)remote.logger(), (String)Messages.COULD_NOT_CHECK_STF_DEVICE_CONNECT_COMPLETION());
            ex.printStackTrace(remote.logger());
        }
        return false;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String stfApiEndpoint = "";
        public String stfToken = "";
        public Boolean useSpecificKey = false;
        public String adbPublicKey;
        public String adbPrivateKey;
        public boolean ignoreCertError = false;

        public DescriptorImpl() {
            super(STFBuildWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.JOB_DESCRIPTION();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.stfApiEndpoint = json.optString("stfApiEndpoint");
            this.stfToken = json.optString("stfToken");
            this.useSpecificKey = json.optBoolean("useSpecificKey", false);
            if (this.useSpecificKey.booleanValue()) {
                this.adbPublicKey = Util.fixEmptyAndTrim((String)json.optString("adbPublicKey"));
                this.adbPrivateKey = Util.fixEmptyAndTrim((String)json.optString("adbPrivateKey"));
            } else {
                this.adbPublicKey = null;
                this.adbPrivateKey = null;
            }
            this.ignoreCertError = json.optBoolean("ignoreCertError", false);
            this.save();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONArray conditionArray;
            int deviceReleaseWaitTime = 0;
            HashMap<String, String> deviceCondition = new HashMap<String, String>();
            try {
                deviceReleaseWaitTime = Integer.parseInt(formData.getString("deviceReleaseWaitTime"));
                if (deviceReleaseWaitTime < 0) {
                    deviceReleaseWaitTime = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            finally {
                formData.discard("deviceReleaseWaitTime");
            }
            if ((conditionArray = formData.optJSONArray("condition")) != null) {
                for (Object conditionObj : conditionArray) {
                    JSONObject condition = JSONObject.fromObject(conditionObj);
                    deviceCondition.put(condition.getString("conditionName"), condition.getString("conditionValue"));
                }
            } else {
                JSONObject condition = formData.optJSONObject("condition");
                if (condition != null) {
                    deviceCondition.put(condition.getString("conditionName"), condition.getString("conditionValue"));
                }
            }
            return new STFBuildWrapper(deviceCondition, deviceReleaseWaitTime);
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public ListBoxModel doFillConditionNameItems() {
            Utils.setupSTFApiClient(this.stfApiEndpoint, this.ignoreCertError, this.stfToken);
            return Utils.getSTFDeviceAttributeListBoxItems();
        }

        public ComboBoxModel doFillConditionValueItems(@QueryParameter String conditionName) {
            if (Util.fixEmpty((String)this.stfApiEndpoint) == null || Util.fixEmpty((String)this.stfToken) == null) {
                return new ComboBoxModel();
            }
            Utils.setupSTFApiClient(this.stfApiEndpoint, this.ignoreCertError, this.stfToken);
            return Utils.getSTFDeviceAttributeValueComboBoxItems(conditionName);
        }

        public FormValidation doCheckConditionValue(@QueryParameter String value) {
            if (value.matches("^/.+/$") && !Utils.validateRegexValue(value)) {
                return FormValidation.error((String)Messages.INVALID_REGEXP_VALUE());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSTFApiEndpoint(@QueryParameter String stfApiEndpoint, @QueryParameter boolean ignoreCertError) {
            return Utils.validateSTFApiEndpoint(stfApiEndpoint, ignoreCertError);
        }

        public FormValidation doCheckSTFToken(@QueryParameter String stfApiEndpoint, @QueryParameter boolean ignoreCertError, @QueryParameter String stfToken) {
            return Utils.validateSTFToken(stfApiEndpoint, ignoreCertError, stfToken);
        }

        public FormValidation doCheckUseSpecificKey(@QueryParameter Boolean value) {
            if (value.booleanValue()) {
                return FormValidation.warning((String)Messages.ADBKEY_FILE_WILL_BE_OVERWRITTEN());
            }
            return FormValidation.ok();
        }

        @JavaScriptMethod
        public JSONArray getDeviceListJSON(JSONObject filterJSON) {
            Map filter = (Map)JSONObject.toBean((JSONObject)filterJSON, Map.class);
            if (Util.fixEmpty((String)this.stfApiEndpoint) == null || Util.fixEmpty((String)this.stfToken) == null) {
                return new JSONArray();
            }
            if (!Utils.validateDeviceFilter(filter)) {
                return new JSONArray();
            }
            Utils.setupSTFApiClient(this.stfApiEndpoint, this.ignoreCertError, this.stfToken);
            try {
                List<DeviceListResponseDevices> deviceList = Utils.getDeviceList(filter);
                return JSONArray.fromObject(deviceList);
            }
            catch (ApiFailedException ex) {
                return new JSONArray();
            }
        }

        @JavaScriptMethod
        public synchronized String getStfApiEndpoint() {
            return String.valueOf(this.stfApiEndpoint);
        }
    }
}

