/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.steps;

import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.junit.TestResultSummary;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.BuildFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ValidationRunFacade;
import net.nemerosa.ontrack.jenkins.steps.OntrackStepHelper;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OntrackValidateStep
extends Step {
    private final String project;
    private final String branch;
    private final String build;
    private final String validationStamp;
    private String validationStatus = null;
    private String description = "";
    private Result buildResult = null;
    private Map<String, ?> data = null;
    private String dataType = null;
    private boolean dataValidation = true;
    private TestResultSummary testResults = null;
    private boolean testResultsAsFraction = false;

    @DataBoundConstructor
    public OntrackValidateStep(@Nonnull String project, @Nonnull String branch, @Nonnull String build, @Nonnull String validationStamp) {
        this.project = project;
        this.branch = branch;
        this.build = build;
        this.validationStamp = validationStamp;
    }

    @DataBoundSetter
    public void setValidationStatus(String validationStatus) {
        this.validationStatus = validationStatus;
    }

    public String getDescription() {
        return this.description;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, ?> getData() {
        return this.data;
    }

    @DataBoundSetter
    public void setData(Map<String, ?> data) {
        this.data = data;
    }

    public String getDataType() {
        return this.dataType;
    }

    @DataBoundSetter
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public boolean isDataValidation() {
        return this.dataValidation;
    }

    @DataBoundSetter
    public void setDataValidation(boolean dataValidation) {
        this.dataValidation = dataValidation;
    }

    public TestResultSummary getTestResults() {
        return this.testResults;
    }

    @DataBoundSetter
    public void setTestResults(TestResultSummary testResults) {
        this.testResults = testResults;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBuild() {
        return this.build;
    }

    public String getValidationStamp() {
        return this.validationStamp;
    }

    public String getValidationStatus() {
        return this.validationStatus;
    }

    public Result getBuildResult() {
        return this.buildResult;
    }

    @DataBoundSetter
    public void setBuildResult(Result buildResult) {
        this.buildResult = buildResult;
    }

    public boolean isTestResultsAsFraction() {
        return this.testResultsAsFraction;
    }

    @DataBoundSetter
    public void setTestResultsAsFraction(boolean testResultsAsFraction) {
        this.testResultsAsFraction = testResultsAsFraction;
    }

    public StepExecution start(final StepContext context) throws Exception {
        if (StringUtils.isBlank((String)this.project) || StringUtils.isBlank((String)this.branch) || StringUtils.isBlank((String)this.build) || StringUtils.isBlank((String)this.validationStamp)) {
            throw new AbortException("Ontrack validation run not created. All mandatory properties must be supplied ('project', 'branch', 'build', 'validationStamp').");
        }
        return new SynchronousStepExecution<Void>(context){

            protected Void run() throws Exception {
                Map<String, ?> runInfo;
                ValidationRunFacade validationRun;
                TaskListener taskListener = (TaskListener)context.get(TaskListener.class);
                if (taskListener == null) {
                    throw new IllegalStateException("Cannot get any task listener.");
                }
                OntrackDSLFacade ontrack = OntrackDSLConnector.createOntrackConnector(taskListener);
                BuildFacade ontrackBuild = ontrack.build(OntrackValidateStep.this.project, OntrackValidateStep.this.branch, OntrackValidateStep.this.build);
                String actualStatus = OntrackValidateStep.this.validationStatus;
                if (actualStatus == null && OntrackValidateStep.this.buildResult != null) {
                    actualStatus = OntrackStepHelper.toValidationRunStatus(OntrackValidateStep.this.buildResult);
                }
                if (actualStatus == null) {
                    actualStatus = OntrackStepHelper.getValidationRunStatusFromStage(context);
                }
                if (OntrackValidateStep.this.testResults != null) {
                    if (OntrackValidateStep.this.testResultsAsFraction) {
                        int ok = OntrackValidateStep.this.testResults.getPassCount();
                        int total = OntrackValidateStep.this.testResults.getTotalCount() - OntrackValidateStep.this.testResults.getSkipCount();
                        validationRun = ontrackBuild.validateWithFraction(OntrackValidateStep.this.validationStamp, ok, total, OntrackValidateStep.this.dataValidation ? OntrackValidateStep.this.validationStatus : actualStatus);
                    } else {
                        int passed = OntrackValidateStep.this.testResults.getPassCount();
                        int skipped = OntrackValidateStep.this.testResults.getSkipCount();
                        int failed = OntrackValidateStep.this.testResults.getFailCount();
                        validationRun = ontrackBuild.validateWithTestSummary(OntrackValidateStep.this.validationStamp, passed, skipped, failed, OntrackValidateStep.this.dataValidation ? OntrackValidateStep.this.validationStatus : actualStatus);
                    }
                } else if (StringUtils.equals((String)OntrackValidateStep.this.dataType, (String)"fraction")) {
                    validationRun = ontrackBuild.validateWithFraction(OntrackValidateStep.this.validationStamp, OntrackValidateStep.this.getInt(OntrackValidateStep.this.data, "numerator"), OntrackValidateStep.this.getInt(OntrackValidateStep.this.data, "denominator"), OntrackValidateStep.this.dataValidation ? OntrackValidateStep.this.validationStatus : actualStatus);
                } else if (StringUtils.equals((String)OntrackValidateStep.this.dataType, (String)"chml")) {
                    validationRun = ontrackBuild.validateWithCHML(OntrackValidateStep.this.validationStamp, OntrackValidateStep.this.getInt(OntrackValidateStep.this.data, "critical", 0), OntrackValidateStep.this.getInt(OntrackValidateStep.this.data, "high", 0), OntrackValidateStep.this.getInt(OntrackValidateStep.this.data, "medium", 0), OntrackValidateStep.this.getInt(OntrackValidateStep.this.data, "low", 0), OntrackValidateStep.this.dataValidation ? OntrackValidateStep.this.validationStatus : actualStatus);
                } else if (StringUtils.equals((String)OntrackValidateStep.this.dataType, (String)"text")) {
                    validationRun = ontrackBuild.validateWithText(OntrackValidateStep.this.validationStamp, OntrackValidateStep.this.dataValidation ? OntrackValidateStep.this.validationStatus : actualStatus, OntrackValidateStep.this.getString(OntrackValidateStep.this.data, "value"));
                } else if (StringUtils.equals((String)OntrackValidateStep.this.dataType, (String)"number")) {
                    validationRun = ontrackBuild.validateWithNumber(OntrackValidateStep.this.validationStamp, OntrackValidateStep.this.getInt(OntrackValidateStep.this.data, "value"), OntrackValidateStep.this.dataValidation ? OntrackValidateStep.this.validationStatus : actualStatus);
                } else if (StringUtils.equals((String)OntrackValidateStep.this.dataType, (String)"percentage")) {
                    validationRun = ontrackBuild.validateWithPercentage(OntrackValidateStep.this.validationStamp, OntrackValidateStep.this.getInt(OntrackValidateStep.this.data, "value"), OntrackValidateStep.this.dataValidation ? OntrackValidateStep.this.validationStatus : actualStatus);
                } else if (StringUtils.equals((String)OntrackValidateStep.this.dataType, (String)"metrics")) {
                    HashMap<String, Double> metrics = new HashMap<String, Double>();
                    OntrackValidateStep.this.data.forEach((name, value) -> metrics.put((String)name, OntrackValidateStep.this.toDouble(value)));
                    validationRun = ontrackBuild.validateWithMetrics(OntrackValidateStep.this.validationStamp, metrics, OntrackValidateStep.this.dataValidation ? OntrackValidateStep.this.validationStatus : actualStatus);
                } else if (OntrackValidateStep.this.dataType != null) {
                    validationRun = ontrackBuild.validateWithData(OntrackValidateStep.this.validationStamp, OntrackValidateStep.this.data, OntrackValidateStep.this.dataType, OntrackValidateStep.this.dataValidation ? OntrackValidateStep.this.validationStatus : actualStatus);
                } else {
                    if (OntrackValidateStep.this.data != null) {
                        throw new IllegalArgumentException("There is some data, but no dataType.");
                    }
                    validationRun = ontrackBuild.validate(OntrackValidateStep.this.validationStamp, actualStatus);
                }
                if (StringUtils.isNotBlank((String)OntrackValidateStep.this.description)) {
                    validationRun.getLastValidationRunStatus().setDescription(OntrackValidateStep.this.description);
                }
                if ((runInfo = OntrackStepHelper.getRunInfo(context, taskListener)) != null && !runInfo.isEmpty()) {
                    validationRun.setRunInfo(runInfo);
                }
                return null;
            }
        };
    }

    private Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value != null) {
            return Double.parseDouble(value.toString());
        }
        throw new IllegalArgumentException("Null metrics are not valid.");
    }

    private String getString(Map<String, ?> map, String field) {
        Object value = map.get(field);
        if (value == null) {
            throw new IllegalArgumentException("Missing field " + field);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("Field " + field + " is not a string: " + value);
    }

    private int getInt(Map<String, ?> map, String field) {
        Object value = map.get(field);
        if (value == null) {
            throw new IllegalArgumentException("Missing field " + field);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new IllegalArgumentException("Field " + field + " is not an integer: " + value);
    }

    private int getInt(Map<String, ?> map, String field, int defaultValue) {
        Object value = map.get(field);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new IllegalArgumentException("Field " + field + " is not an integer: " + value);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "ontrackValidate";
        }

        @Nonnull
        public String getDisplayName() {
            return "Validates an Ontrack build";
        }
    }
}

