/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl.v3;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.dsl.OntrackConnection;
import net.nemerosa.ontrack.dsl.http.OTMessageClientException;
import net.nemerosa.ontrack.dsl.http.OTNotFoundException;
import net.nemerosa.ontrack.jenkins.OntrackConfiguration;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLFacade;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLLogger;
import net.nemerosa.ontrack.jenkins.dsl.facade.BranchFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.BuildFacade;
import net.nemerosa.ontrack.jenkins.dsl.facade.ProjectFacade;
import net.nemerosa.ontrack.jenkins.dsl.v3.BranchV3Facade;
import net.nemerosa.ontrack.jenkins.dsl.v3.BuildV3Facade;
import net.nemerosa.ontrack.jenkins.dsl.v3.ProjectV3Facade;
import org.apache.commons.lang.StringUtils;

public class OntrackDSLV3Facade
implements OntrackDSLFacade {
    private final Ontrack ontrack;

    public OntrackDSLV3Facade(OntrackConfiguration config, OntrackDSLLogger logger) {
        String user;
        OntrackConnection connection = OntrackConnection.create((String)config.getOntrackUrl());
        if (logger != null) {
            connection = connection.logger(logger::log);
        }
        if (StringUtils.isNotBlank((String)(user = config.getOntrackUser()))) {
            connection = connection.authenticate(user, config.getOntrackPassword());
        }
        if (config.getOntrackMaxTries() >= 1) {
            connection = connection.maxTries(config.getOntrackMaxTries()).retryDelaySeconds(config.getOntrackRetryDelaySeconds());
        }
        this.ontrack = connection.build();
    }

    @Override
    public String getVersion() {
        return "V3";
    }

    @Override
    public String getAppVersion() {
        return this.ontrack.getVersion();
    }

    @Override
    public Object getDSLRoot() {
        return this.ontrack;
    }

    @Override
    public void onClientException(Exception exception, Consumer<String> handler) {
        if (!(exception instanceof OTMessageClientException)) {
            throw new RuntimeException("Client", exception);
        }
        handler.accept(exception.getMessage());
    }

    @Override
    public <T> T onNotFoundException(Exception exception, Supplier<T> handler) {
        if (exception instanceof OTNotFoundException) {
            return handler.get();
        }
        throw new RuntimeException("Not found", exception);
    }

    @Override
    public Object graphQLQuery(String query, Map<String, ?> vars) {
        return this.ontrack.graphQLQuery(query, vars);
    }

    @Override
    public ProjectFacade project(String project) {
        return new ProjectV3Facade(this.ontrack.project(project));
    }

    @Override
    public BranchFacade branch(String project, String branch) {
        return new BranchV3Facade(this.ontrack.branch(project, branch));
    }

    @Override
    public BuildFacade build(String projectName, String branchName, String buildName) {
        return new BuildV3Facade(this.ontrack.build(projectName, branchName, buildName));
    }
}

