/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl;

import hudson.model.TaskListener;
import java.io.PrintStream;
import net.nemerosa.ontrack.jenkins.OntrackConfiguration;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLFacade;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLLogger;
import net.nemerosa.ontrack.jenkins.dsl.v3.OntrackDSLV3Facade;
import net.nemerosa.ontrack.jenkins.dsl.v4.OntrackDSLV4Facade;
import org.apache.commons.lang.StringUtils;

public class OntrackDSLConnector {
    private static OntrackDSLFacade ontrackDSLFacade = null;

    public static OntrackDSLFacade createOntrackConnector(PrintStream logger) {
        return OntrackDSLConnector.createOntrackConnector(logger::println);
    }

    public static OntrackDSLFacade createOntrackConnector(OntrackDSLLogger logger) {
        OntrackConfiguration config = OntrackConfiguration.getOntrackConfiguration();
        return OntrackDSLConnector.createOntrackConnector(config, logger);
    }

    public static OntrackDSLFacade createOntrackConnector(OntrackConfiguration config, OntrackDSLLogger logger) {
        if (config == null) {
            throw new IllegalStateException("Could not find any Ontrack configuration.");
        }
        String version = config.getOntrackVersion();
        if ("V3".equals(version) || StringUtils.isBlank((String)version)) {
            return new OntrackDSLV3Facade(config, logger);
        }
        if ("V4".equals(version)) {
            return new OntrackDSLV4Facade(config, logger);
        }
        throw new IllegalStateException("Not supporting Ontrack API version " + version);
    }

    public static OntrackDSLFacade createOntrackConnector(TaskListener listener) {
        return ontrackDSLFacade != null ? ontrackDSLFacade : OntrackDSLConnector.createOntrackConnector(listener != null ? listener.getLogger() : System.out);
    }

    public static void setOntrack(OntrackDSLFacade test) {
        ontrackDSLFacade = test;
    }
}

