/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl;

import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;

public class JenkinsConnector {
    private final Map<String, String> env = new LinkedHashMap<String, String>();
    private final Run build;
    private final TaskListener listener;
    private final Consumer<Map<String, Object>> runInfoAdapter;

    public JenkinsConnector(Run build, TaskListener listener, Consumer<Map<String, Object>> runInfoAdapter) {
        this.build = build;
        this.listener = listener;
        this.runInfoAdapter = runInfoAdapter;
    }

    public void env(String name, String value) {
        this.env.put(name, value);
    }

    public Map<String, ?> getRunInfo() throws IOException, InterruptedException {
        Map<String, Object> runInfo = OntrackPluginSupport.getRunInfo(this.build, this.listener);
        this.runInfoAdapter.accept(runInfo);
        return runInfo;
    }

    public Result getResult() {
        return this.build.getResult();
    }

    public Run getBuild() {
        return this.build;
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public boolean isSuccess() {
        Result result = this.getResult();
        return result != null && result.isBetterOrEqualTo(Result.SUCCESS);
    }

    public boolean isUnstable() {
        Result result = this.getResult();
        return result != null && result.isBetterOrEqualTo(Result.UNSTABLE) && result.isWorseThan(Result.SUCCESS);
    }

    public boolean isFailure() {
        Result result = this.getResult();
        return result != null && result.isWorseOrEqualTo(Result.FAILURE);
    }

    public Map<String, String> env() {
        return this.env;
    }
}

