/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.nemerosa.ontrack.jenkins.OntrackSecurityMode;
import net.nemerosa.ontrack.jenkins.Version;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLFacade;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class OntrackConfiguration
extends GlobalConfiguration {
    private static Logger LOGGER = Logger.getLogger(OntrackConfiguration.class.getName());
    public static final String VERSION_3 = "V3";
    public static final String VERSION_4 = "V4";
    private String ontrackConfigurationName;
    private String ontrackUrl;
    private String ontrackVersion;
    private String ontrackUser;
    private String ontrackPassword;
    private int ontrackMaxTries = 1;
    private int ontrackRetryDelaySeconds = 10000;
    private int ontrackVersionCacheExpirationSeconds = 3600;
    private OntrackSecurityMode securityMode = OntrackSecurityMode.DEFAULT;
    private boolean ontrackTraceTimings = false;
    private final transient AtomicReference<VersionCache> version = new AtomicReference();

    @Nullable
    public static OntrackConfiguration getOntrackConfiguration() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        return instance != null ? (OntrackConfiguration)instance.getDescriptor(OntrackConfiguration.class) : null;
    }

    public OntrackConfiguration() {
        this.load();
    }

    public synchronized void load() {
        super.load();
        this.loadVersion();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.ontrackConfigurationName = json.getString("ontrackConfigurationName");
        this.ontrackUrl = json.getString("ontrackUrl");
        this.ontrackVersion = json.has("ontrackVersion") ? json.getString("ontrackVersion") : VERSION_3;
        this.ontrackUser = json.getString("ontrackUser");
        this.ontrackPassword = json.getString("ontrackPassword");
        this.ontrackMaxTries = json.getInt("ontrackMaxTries");
        this.ontrackRetryDelaySeconds = json.getInt("ontrackRetryDelaySeconds");
        this.ontrackVersionCacheExpirationSeconds = json.getInt("ontrackVersionCacheExpirationSeconds");
        this.securityMode = OntrackSecurityMode.valueOf(json.getString("securityMode"));
        this.ontrackTraceTimings = json.has("ontrackTraceTimings") && json.getBoolean("ontrackTraceTimings");
        this.save();
        boolean ok = super.configure(req, json);
        this.loadVersion();
        return ok;
    }

    private VersionCache loadVersion() {
        return this.version.updateAndGet(current -> {
            if (current != null) {
                long expiredTimeMs = System.currentTimeMillis() - current.getTimestamp();
                long expiredTimeSeconds = expiredTimeMs / 1000L;
                if (expiredTimeSeconds >= (long)this.ontrackVersionCacheExpirationSeconds) {
                    return this.computeVersionCache();
                }
                return current;
            }
            return this.computeVersionCache();
        });
    }

    private VersionCache computeVersionCache() {
        Version remoteVersion = this.getRemoteVersion();
        if (remoteVersion != null) {
            LOGGER.info("[ontrack] Remote version = " + remoteVersion);
            return new VersionCache(remoteVersion, System.currentTimeMillis());
        }
        return null;
    }

    private Version getRemoteVersion() {
        try {
            OntrackDSLFacade facade = OntrackDSLConnector.createOntrackConnector(this, message -> LOGGER.info(message));
            String versionString = facade.getAppVersion();
            return Version.of(versionString);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    public Version getVersion() {
        VersionCache versionCache = this.loadVersion();
        return versionCache != null ? versionCache.getValue() : null;
    }

    public String getOntrackConfigurationName() {
        return this.ontrackConfigurationName;
    }

    public String getOntrackUrl() {
        return this.ontrackUrl;
    }

    public String getOntrackVersion() {
        return this.ontrackVersion;
    }

    public String getOntrackUser() {
        return this.ontrackUser;
    }

    public String getOntrackPassword() {
        return this.ontrackPassword;
    }

    public OntrackSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public void setSecurityMode(OntrackSecurityMode securityMode) {
        this.securityMode = securityMode;
    }

    public void setOntrackConfigurationName(String ontrackConfigurationName) {
        this.ontrackConfigurationName = ontrackConfigurationName;
    }

    public void setOntrackUrl(String ontrackUrl) {
        this.ontrackUrl = ontrackUrl;
    }

    public void setOntrackVersion(String ontrackVersion) {
        this.ontrackVersion = ontrackVersion;
    }

    public void setOntrackUser(String ontrackUser) {
        this.ontrackUser = ontrackUser;
    }

    public void setOntrackPassword(String ontrackPassword) {
        this.ontrackPassword = ontrackPassword;
    }

    public int getOntrackMaxTries() {
        return this.ontrackMaxTries;
    }

    public void setOntrackMaxTries(int ontrackMaxTries) {
        this.ontrackMaxTries = ontrackMaxTries;
    }

    public int getOntrackRetryDelaySeconds() {
        return this.ontrackRetryDelaySeconds;
    }

    public void setOntrackRetryDelaySeconds(int ontrackRetryDelaySeconds) {
        this.ontrackRetryDelaySeconds = ontrackRetryDelaySeconds;
    }

    public int getOntrackVersionCacheExpirationSeconds() {
        return this.ontrackVersionCacheExpirationSeconds;
    }

    public void setOntrackVersionCacheExpirationSeconds(int ontrackVersionCacheExpirationSeconds) {
        this.ontrackVersionCacheExpirationSeconds = ontrackVersionCacheExpirationSeconds;
    }

    public boolean isOntrackTraceTimings() {
        return this.ontrackTraceTimings;
    }

    public void setOntrackTraceTimings(boolean ontrackTraceTimings) {
        this.ontrackTraceTimings = ontrackTraceTimings;
    }

    public ListBoxModel doFillSecurityModeItems() {
        ListBoxModel items = new ListBoxModel();
        for (OntrackSecurityMode mode : OntrackSecurityMode.values()) {
            items.add(mode.getDisplayName(), mode.name());
        }
        return items;
    }

    private static class VersionCache {
        private final Version value;
        private final long timestamp;

        private VersionCache(Version value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }

        public Version getValue() {
            return this.value;
        }

        long getTimestamp() {
            return this.timestamp;
        }
    }
}

