/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.trigger;

import com.google.common.collect.ImmutableMap;
import hudson.model.ParameterValue;
import hudson.model.Result;
import hudson.model.StringParameterValue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.dsl.Branch;
import net.nemerosa.ontrack.dsl.Build;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.jenkins.trigger.OntrackTriggerCause;
import net.nemerosa.ontrack.jenkins.trigger.TriggerDefinition;
import net.nemerosa.ontrack.jenkins.trigger.TriggerJob;
import net.nemerosa.ontrack.jenkins.trigger.TriggerResult;
import net.nemerosa.ontrack.jenkins.trigger.TriggerRun;
import org.apache.commons.lang.StringUtils;

public class TriggerHelper {
    private static final Logger LOGGER = Logger.getLogger(TriggerHelper.class.getName());
    private static final Level LOG_LEVEL = Level.FINE;

    public static void evaluate(Ontrack ontrack, TriggerJob job, List<TriggerDefinition> triggers) {
        List results = triggers.stream().map(trigger -> {
            TriggerResult result = TriggerHelper.getTriggerResult(ontrack, job, trigger);
            LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] %s --> %s (firing: %s)", job.getFullName(), trigger, result, result.isFiring()));
            return result;
        }).collect(Collectors.toList());
        boolean oneFiring = results.stream().anyMatch(TriggerResult::isFiring);
        boolean firing = oneFiring ? results.stream().allMatch(result -> StringUtils.isNotBlank((String)result.getNewValue())) : false;
        if (!firing) {
            LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] For one of the reasons mentioned above, not firing", job.getFullName()));
        } else {
            LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Firing", job.getFullName()));
            List<ParameterValue> parameters = results.stream().map(result -> new StringParameterValue(result.getName(), result.getNewValue())).collect(Collectors.toList());
            job.trigger(new OntrackTriggerCause(), parameters);
        }
    }

    private static TriggerResult getTriggerResult(Ontrack ontrack, TriggerJob job, TriggerDefinition trigger) {
        Branch ontrackBranch = ontrack.branch(trigger.getProject(), trigger.getBranch());
        List ontrackBuilds = StringUtils.isBlank((String)trigger.getPromotion()) ? ontrackBranch.standardFilter(Collections.singletonMap("count", 1)) : ("*".equals(trigger.getPromotion()) ? ontrackBranch.getLastPromotedBuilds() : ontrackBranch.standardFilter((Map)ImmutableMap.of((Object)"count", (Object)1, (Object)"withPromotionLevel", (Object)trigger.getPromotion())));
        if (ontrackBuilds.isEmpty()) {
            LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] No build eligible", job.getFullName()));
            return trigger.noResult();
        }
        String newValue = ((Build)ontrackBuilds.get(0)).getName();
        LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Last available build: %s", job.getFullName(), newValue));
        String parameterName = trigger.getParameterName();
        TriggerRun lastBuild = job.getLastBuild();
        if (lastBuild != null) {
            Result result = lastBuild.getResult();
            Result minimum = Result.fromString((String)trigger.getMinimumResult());
            if (result == null || result.isWorseThan(minimum) && result.isCompleteBuild()) {
                LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Last build was failed or unsuccessful", job.getFullName()));
                return trigger.noPrevious(newValue);
            }
            try {
                String previousValue = lastBuild.getEnvironment(parameterName);
                LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] Version for last build: %s", job.getFullName(), previousValue));
                return trigger.withPrevious(previousValue, newValue);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(String.format("[ontrack][trigger][%s] Could not compute the trigger condition because %s environment variable could not be accessed", job.getFullName(), parameterName), e);
            }
        }
        LOGGER.log(LOG_LEVEL, String.format("[ontrack][trigger][%s] No previous build, firing", job.getFullName()));
        return trigger.noPrevious(newValue);
    }
}

