/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.trigger;

import hudson.model.Result;
import net.nemerosa.ontrack.jenkins.trigger.TriggerResult;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class TriggerDefinition {
    public static final String SUCCESS = "SUCCESS";
    private final String project;
    private final String branch;
    private final String promotion;
    private final String parameterName;
    private final String minimumResult;

    @DataBoundConstructor
    public TriggerDefinition(String project, String branch, String promotion, String parameterName, String minimumResult) {
        this.project = project;
        this.branch = branch;
        this.promotion = promotion;
        this.parameterName = StringUtils.isBlank((String)parameterName) ? "VERSION" : parameterName;
        this.minimumResult = minimumResult != null && !minimumResult.isEmpty() ? Result.fromString((String)minimumResult).toString() : SUCCESS;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getPromotion() {
        return this.promotion;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getMinimumResult() {
        return this.minimumResult;
    }

    public String toString() {
        return "TriggerDefinition{project='" + this.project + '\'' + ", branch='" + this.branch + '\'' + ", promotion='" + this.promotion + '\'' + ", parameterName='" + this.parameterName + '\'' + ", minimumResult='" + this.minimumResult + '\'' + '}';
    }

    TriggerResult noResult() {
        return new TriggerResult(this.parameterName, null, null);
    }

    TriggerResult noPrevious(String newValue) {
        return new TriggerResult(this.parameterName, null, newValue);
    }

    TriggerResult withPrevious(String previousValue, String lastVersion) {
        return new TriggerResult(this.parameterName, previousValue, lastVersion);
    }
}

