/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.steps;

import com.google.common.collect.ImmutableSet;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.jenkins.dsl.JenkinsConnector;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.nemerosa.ontrack.jenkins.steps.OntrackStepHelper;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OntrackScriptStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final String script;
    private Map<String, Object> bindings = Collections.emptyMap();
    private boolean logging = false;

    @DataBoundConstructor
    public OntrackScriptStep(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public boolean isLogging() {
        return this.logging;
    }

    @DataBoundSetter
    public void setBindings(Map<String, Object> bindings) {
        this.bindings = bindings;
    }

    @DataBoundSetter
    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public StepExecution start(final StepContext context) throws Exception {
        if (StringUtils.isBlank((String)this.script)) {
            throw new AbortException("Ontrack script not run. All mandatory properties must be supplied ('script').");
        }
        return new SynchronousNonBlockingStepExecution<JSON>(context){

            protected JSON run() throws Exception {
                TaskListener listener = (TaskListener)context.get(TaskListener.class);
                assert (listener != null);
                Ontrack ontrack = OntrackDSLConnector.createOntrackConnector(listener);
                HashMap<String, Object> values = new HashMap<String, Object>(OntrackScriptStep.this.bindings);
                Run run = (Run)context.get(Run.class);
                if (run != null) {
                    values.put("jenkins", new JenkinsConnector(run, listener, runInfo -> OntrackStepHelper.adaptRunInfo(context, runInfo)));
                }
                values.put("ontrack", ontrack);
                values.put("out", listener.getLogger());
                Binding binding = new Binding(values);
                GroovyShell shell = new GroovyShell(binding);
                listener.getLogger().format("[ontrack] DSL script running...%n", new Object[0]);
                Object shellResult = shell.evaluate(OntrackScriptStep.this.script);
                if (OntrackScriptStep.this.logging) {
                    listener.getLogger().format("[ontrack] DSL script returned result: %s%n", shellResult);
                } else {
                    listener.getLogger().format("[ontrack] DSL script returned result.%n", new Object[0]);
                }
                return JSONSerializer.toJSON((Object)shellResult);
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "ontrackScript";
        }

        @Nonnull
        public String getDisplayName() {
            return "Runs some Ontrack DSL script";
        }
    }
}

