/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.steps;

import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OntrackGraphQLStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final String script;
    private Map<String, Object> bindings = Collections.emptyMap();

    @DataBoundConstructor
    public OntrackGraphQLStep(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    @DataBoundSetter
    public void setBindings(Map<String, Object> bindings) {
        this.bindings = bindings;
    }

    public StepExecution start(final StepContext context) throws Exception {
        if (StringUtils.isBlank((String)this.script)) {
            throw new AbortException("Ontrack script not run. All mandatory properties must be supplied ('script').");
        }
        return new SynchronousNonBlockingStepExecution<JSON>(context){

            protected JSON run() throws Exception {
                TaskListener listener = (TaskListener)context.get(TaskListener.class);
                assert (listener != null);
                Ontrack ontrack = OntrackDSLConnector.createOntrackConnector(listener);
                Object result = ontrack.graphQLQuery(OntrackGraphQLStep.this.script, OntrackGraphQLStep.this.bindings);
                return JSONSerializer.toJSON((Object)result);
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "ontrackGraphQL";
        }

        @Nonnull
        public String getDisplayName() {
            return "Runs some Ontrack GraphQL script";
        }
    }
}

