/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.steps;

import hudson.AbortException;
import hudson.Extension;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OntrackBranchNameStep
extends Step {
    private static final String BRANCH_CHARACTERS = "[^A-Za-z0-9._\\-]";
    private final String branch;
    private String branchReplacement = "-";

    @DataBoundConstructor
    public OntrackBranchNameStep(@Nonnull String branch) {
        this.branch = branch;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBranchReplacement() {
        return this.branchReplacement;
    }

    @DataBoundSetter
    public void setBranchReplacement(String branchReplacement) {
        this.branchReplacement = branchReplacement;
    }

    public StepExecution start(StepContext context) throws Exception {
        if (StringUtils.isBlank((String)this.branch)) {
            throw new AbortException("Ontrack branch name not available. All mandatory properties must be supplied ('branch').");
        }
        return new SynchronousStepExecution<String>(context){

            protected String run() throws Exception {
                return OntrackBranchNameStep.this.branch.replaceAll(OntrackBranchNameStep.BRANCH_CHARACTERS, OntrackBranchNameStep.this.branchReplacement);
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }

        public String getFunctionName() {
            return "ontrackBranchName";
        }

        @Nonnull
        public String getDisplayName() {
            return "Transforms a branch name, as provided by the pipeline for example, into a name suitable for a branch in Ontrack.";
        }
    }
}

