/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl;

import groovy.lang.Script;
import hudson.model.Item;
import net.nemerosa.ontrack.jenkins.dsl.AbstractDSLLauncher;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLException;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLWhitelist;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;

public class SandboxDSLLauncher
extends AbstractDSLLauncher {
    private final Item source;

    public SandboxDSLLauncher(Item source) {
        this.source = source;
    }

    @Override
    protected CompilerConfiguration prepareCompilerConfiguration() {
        return GroovySandbox.createSecureCompilerConfiguration();
    }

    @Override
    protected ClassLoader prepareClassLoader(ClassLoader classLoader) {
        return GroovySandbox.createSecureClassLoader((ClassLoader)classLoader);
    }

    @Override
    protected Object run(Script groovyScript) {
        try {
            return GroovySandbox.run((Script)groovyScript, (Whitelist)new ProxyWhitelist(new Whitelist[]{Whitelist.all(), new OntrackDSLWhitelist()}));
        }
        catch (RejectedAccessException e) {
            throw new OntrackDSLException(e.getMessage(), ScriptApproval.get().accessRejected(e, ApprovalContext.create().withItem(this.source)));
        }
    }
}

