/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.dsl;

import hudson.model.TaskListener;
import java.io.PrintStream;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.dsl.OntrackConnection;
import net.nemerosa.ontrack.dsl.OntrackLogger;
import net.nemerosa.ontrack.jenkins.OntrackConfiguration;
import org.apache.commons.lang.StringUtils;

public class OntrackDSLConnector {
    private static Ontrack ontrack = null;

    public static Ontrack createOntrackConnector(final PrintStream logger) {
        return OntrackDSLConnector.createOntrackConnector(new OntrackLogger(){

            public void trace(String message) {
                logger.println(message);
            }
        });
    }

    public static Ontrack createOntrackConnector(OntrackLogger logger) {
        String user;
        OntrackConfiguration config = OntrackConfiguration.getOntrackConfiguration();
        if (config == null) {
            throw new IllegalStateException("Could not find any Ontrack configuration.");
        }
        OntrackConnection connection = OntrackConnection.create((String)config.getOntrackUrl());
        if (logger != null) {
            connection = connection.logger(logger);
        }
        if (StringUtils.isNotBlank((String)(user = config.getOntrackUser()))) {
            connection = connection.authenticate(user, config.getOntrackPassword());
        }
        if (config.getOntrackMaxTries() > 1) {
            connection = connection.maxTries(config.getOntrackMaxTries()).retryDelaySeconds(config.getOntrackRetryDelaySeconds());
        }
        return connection.build();
    }

    public static Ontrack createOntrackConnector(TaskListener listener) {
        return ontrack != null ? ontrack : OntrackDSLConnector.createOntrackConnector(listener != null ? listener.getLogger() : null);
    }

    public static void setOntrack(Ontrack test) {
        ontrack = test;
    }
}

