/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins.changelog;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import net.nemerosa.ontrack.dsl.Build;
import net.nemerosa.ontrack.dsl.ChangeLog;
import net.nemerosa.ontrack.dsl.ChangeLogCommit;
import net.nemerosa.ontrack.dsl.ChangeLogFile;
import net.nemerosa.ontrack.dsl.ChangeLogIssue;
import net.nemerosa.ontrack.dsl.Ontrack;
import net.nemerosa.ontrack.dsl.http.OTNotFoundException;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.changelog.OntrackChangeLog;
import net.nemerosa.ontrack.jenkins.changelog.OntrackChangeLogAction;
import net.nemerosa.ontrack.jenkins.changelog.OntrackChangeLogCommit;
import net.nemerosa.ontrack.jenkins.changelog.OntrackChangeLogFile;
import net.nemerosa.ontrack.jenkins.changelog.OntrackChangeLogIssue;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLConnector;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackChangelogPublisher
extends Notifier {
    private final String project;
    private final String branch;
    private final String buildNameParameter;
    private final boolean distinctBuilds;
    private final boolean collectFiles;
    private final boolean failOnChangeLogFailure;
    private final String committersVariable;
    private final String committerMailSuffix;

    @DataBoundConstructor
    public OntrackChangelogPublisher(String project, String branch, String buildNameParameter, boolean distinctBuilds, boolean collectFiles, boolean failOnChangeLogFailure, String committersVariable, String committerMailSuffix) {
        this.project = project;
        this.branch = branch;
        this.buildNameParameter = buildNameParameter;
        this.distinctBuilds = distinctBuilds;
        this.collectFiles = collectFiles;
        this.failOnChangeLogFailure = failOnChangeLogFailure;
        this.committersVariable = committersVariable;
        this.committerMailSuffix = committerMailSuffix;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Build buildN;
        Build build1;
        String projectName = OntrackPluginSupport.expand(this.project, build, listener);
        String branchName = OntrackPluginSupport.expand(this.branch, build, listener);
        String lastBuildName = this.getBuildName(build);
        String previousBuildName = null;
        AbstractBuild previousBuild = build.getPreviousBuild();
        if (previousBuild != null) {
            previousBuildName = this.getBuildName(previousBuild);
        }
        if (StringUtils.isBlank((String)lastBuildName)) {
            return this.noChangeLog(listener, "No build name can be retrieved from the current build");
        }
        if (previousBuild == null) {
            return this.noChangeLog(listener, "There is no previous build");
        }
        if (StringUtils.isBlank((String)previousBuildName)) {
            return this.noChangeLog(listener, "No build name can be retrieved from the previous build");
        }
        Ontrack ontrack = OntrackDSLConnector.createOntrackConnector((TaskListener)listener);
        try {
            build1 = ontrack.build(projectName, branchName, previousBuildName);
        }
        catch (OTNotFoundException ignored) {
            return this.noChangeLog(listener, String.format("Build %s cannot be found.", previousBuildName));
        }
        try {
            buildN = ontrack.build(projectName, branchName, lastBuildName);
        }
        catch (OTNotFoundException ignored) {
            return this.noChangeLog(listener, String.format("Build %s cannot be found.", lastBuildName));
        }
        List builds = Arrays.asList(build1, buildN);
        if (this.distinctBuilds) {
            builds = ontrack.branch(projectName, branchName).intervalFilter((Map)ImmutableMap.of((Object)"from", (Object)build1.getName(), (Object)"to", (Object)buildN.getName()));
        }
        ArrayList<OntrackChangeLog> changeLogs = new ArrayList<OntrackChangeLog>();
        int count = builds.size();
        for (int i = 1; i < count; ++i) {
            Build a = (Build)builds.get(i - 1);
            Build b = (Build)builds.get(i);
            if (a.getId() == b.getId()) continue;
            try {
                ChangeLog changeLog = a.getChangeLog(b);
                OntrackChangeLog ontrackChangeLog = this.collectInfo(changeLog);
                changeLogs.add(ontrackChangeLog);
                continue;
            }
            catch (Exception ex) {
                if (this.failOnChangeLogFailure) {
                    throw new RuntimeException("Could not collect the change log", ex);
                }
                changeLogs.add(OntrackChangeLog.error(a.getName(), b.getName()));
            }
        }
        if (StringUtils.isNotBlank((String)this.committersVariable)) {
            String committersMailingList = this.getCommittersMailingList(changeLogs);
            listener.getLogger().format("Injecting mailing list into %s: %s%n", this.committersVariable, committersMailingList);
            build.addAction((Action)new ParametersAction(new ParameterValue[]{new StringParameterValue(this.committersVariable, committersMailingList)}));
        }
        build.addAction((Action)new OntrackChangeLogAction(build, changeLogs));
        return true;
    }

    private String getCommittersMailingList(List<OntrackChangeLog> changeLogs) {
        TreeSet<String> emails = new TreeSet<String>();
        for (OntrackChangeLog changeLog : changeLogs) {
            for (OntrackChangeLogCommit commit : changeLog.getCommits()) {
                String authorEmail = commit.getAuthorEmail();
                if (StringUtils.isNotBlank((String)authorEmail)) {
                    emails.add(authorEmail);
                    continue;
                }
                String author = commit.getAuthor();
                if (!StringUtils.isNotBlank((String)author)) continue;
                if (!StringUtils.contains((String)author, (String)"@")) {
                    author = author + this.committerMailSuffix;
                }
                emails.add(author);
            }
        }
        return StringUtils.join(emails, (String)",");
    }

    private OntrackChangeLog collectInfo(ChangeLog changeLog) {
        List commits = Lists.transform((List)changeLog.getCommits(), (Function)new Function<ChangeLogCommit, OntrackChangeLogCommit>(){

            public OntrackChangeLogCommit apply(ChangeLogCommit input) {
                return new OntrackChangeLogCommit(input.getId(), input.getShortId(), input.getAuthor(), input.getAuthorEmail(), input.getTimestamp(), input.getMessage(), input.getFormattedMessage(), input.getLink());
            }
        });
        List issues = Lists.transform((List)changeLog.getIssues(), (Function)new Function<ChangeLogIssue, OntrackChangeLogIssue>(){

            public OntrackChangeLogIssue apply(ChangeLogIssue input) {
                return new OntrackChangeLogIssue(input.getKey(), input.getDisplayKey(), input.getSummary(), input.getStatus(), input.getUpdateTime(), input.getUrl());
            }
        });
        List files = this.collectFiles ? Lists.transform((List)changeLog.getFiles(), (Function)new Function<ChangeLogFile, OntrackChangeLogFile>(){

            public OntrackChangeLogFile apply(ChangeLogFile input) {
                return new OntrackChangeLogFile(input.getPath(), input.getChangeTypes());
            }
        }) : Collections.emptyList();
        String page = changeLog.link("page");
        return new OntrackChangeLog(false, changeLog.getFrom().getName(), changeLog.getTo().getName(), page, new ArrayList<OntrackChangeLogCommit>(commits), new ArrayList<OntrackChangeLogIssue>(issues), new ArrayList<OntrackChangeLogFile>(files));
    }

    protected boolean noChangeLog(BuildListener listener, String reason) {
        listener.getLogger().format("No change log can be computed. %s%n", reason);
        return true;
    }

    protected String getBuildName(AbstractBuild<?, ?> build) {
        List parametersActions = build.getActions(ParametersAction.class);
        for (ParametersAction parametersAction : parametersActions) {
            ParameterValue parameterValue = parametersAction.getParameter(this.buildNameParameter);
            if (parameterValue == null) continue;
            return Objects.toString(parameterValue.getValue(), null);
        }
        return null;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBuildNameParameter() {
        return this.buildNameParameter;
    }

    public boolean isDistinctBuilds() {
        return this.distinctBuilds;
    }

    public boolean isCollectFiles() {
        return this.collectFiles;
    }

    public boolean isFailOnChangeLogFailure() {
        return this.failOnChangeLogFailure;
    }

    public String getCommittersVariable() {
        return this.committersVariable;
    }

    public String getCommitterMailSuffix() {
        return this.committerMailSuffix;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class OntrackChangelogPublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        public OntrackChangelogPublisherDescriptor() {
            super(OntrackChangelogPublisher.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Ontrack: Change log publication";
        }
    }
}

