/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Version {
    private static final Pattern PATTERN = Pattern.compile("^([^.]+)(\\.([^.]+)(\\.([^.]+))?)?.*$");
    public static final Version NONE = new Version(0, 0, 0);
    private final int major;
    private final int minor;
    private final int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isValid() {
        return this.major >= 0 && this.minor >= 0 && this.patch >= 0 && (this.major > 0 || this.minor > 0 || this.patch > 0);
    }

    public static Version of(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            Matcher matcher = PATTERN.matcher(value);
            if (matcher.matches()) {
                String majorValue = matcher.group(1);
                String minorValue = matcher.group(3);
                String patchValue = matcher.group(5);
                int major = Version.parse(majorValue);
                int minor = Version.parse(minorValue);
                int patch = Version.parse(patchValue);
                return new Version(major, minor, patch);
            }
            return NONE;
        }
        return NONE;
    }

    private static int parse(String value) {
        if (StringUtils.isBlank((String)value)) {
            return 0;
        }
        if (StringUtils.isNumeric((String)value)) {
            return Integer.parseInt(value, 10);
        }
        return -1;
    }

    public static Version of(int major, int minor, int patch) {
        return new Version(major, minor, patch);
    }
}

