/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.nemerosa.ontrack.jenkins.AbstractOntrackMultipleParameterDefinition;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class OntrackMultiChoiceParameterDefinition
extends AbstractOntrackMultipleParameterDefinition {
    @DataBoundConstructor
    public OntrackMultiChoiceParameterDefinition(String name, String description, String dsl, boolean sandbox, String valueProperty, String injectProperties) {
        super(name, description, dsl, sandbox, valueProperty, injectProperties);
    }

    public OntrackMultiChoiceParameterDefinition(String name, String description, String dsl, boolean sandbox, String valueProperty, Map<String, Object> bindings) {
        super(name, description, dsl, sandbox, valueProperty, bindings);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        Object object = jo.get("value");
        List<String> choices = this.getChoices();
        ArrayList<String> selectionList = new ArrayList<String>();
        if (object instanceof Boolean && !choices.isEmpty()) {
            Boolean selected = (Boolean)object;
            String firstOption = choices.get(0);
            if (selected.booleanValue()) {
                selectionList.add(firstOption);
            }
        } else if (object instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)object;
            for (int i = 0; i < choices.size(); ++i) {
                String choice = choices.get(i);
                if (i >= jsonArray.size() || !(jsonArray.get(i) instanceof Boolean) || !((Boolean)jsonArray.get(i)).booleanValue()) continue;
                selectionList.add(choice);
            }
        }
        String selections = StringUtils.join(selectionList, (char)',');
        StringParameterValue value = new StringParameterValue(this.getName(), selections, this.getDescription());
        return value;
    }

    public ParameterValue createValue(StaplerRequest req) {
        Object[] value = req.getParameterValues(this.getName());
        String selections = StringUtils.join((Object[])value, (char)',');
        return new StringParameterValue(this.getName(), selections, this.getDescription());
    }

    public StringParameterValue getDefaultParameterValue() {
        return new StringParameterValue(this.getName(), "", this.getDescription());
    }

    @Extension
    @Symbol(value={"ontrackMultiChoiceParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Ontrack: Multi Parameter choice";
        }

        public String getHelpFile() {
            return "/help/ontrack/parameter-choice.html";
        }
    }
}

