/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import net.nemerosa.ontrack.dsl.http.OTHttpClientException;
import net.nemerosa.ontrack.dsl.http.OTMessageClientException;
import net.nemerosa.ontrack.jenkins.OntrackPluginSupport;
import net.nemerosa.ontrack.jenkins.ScriptLocation;
import net.nemerosa.ontrack.jenkins.dsl.JenkinsConnector;
import net.nemerosa.ontrack.jenkins.dsl.OntrackDSLRunner;
import org.kohsuke.stapler.DataBoundConstructor;

public class OntrackDSLNotifier
extends Notifier {
    private final boolean usingText;
    private final String scriptPath;
    private final String scriptText;
    private final boolean sandbox;
    private final String injectEnvironment;
    private final String injectProperties;
    private final boolean ontrackLog;
    private final boolean ignoreFailure;

    @DataBoundConstructor
    public OntrackDSLNotifier(ScriptLocation ontrackScriptLocation, boolean sandbox, String injectEnvironment, String injectProperties, boolean ontrackLog, boolean ignoreFailure) {
        this.usingText = ontrackScriptLocation == null || ontrackScriptLocation.isUsingText();
        this.scriptPath = ontrackScriptLocation == null ? null : ontrackScriptLocation.getScriptPath();
        this.scriptText = ontrackScriptLocation == null ? null : ontrackScriptLocation.getScriptText();
        this.sandbox = sandbox;
        this.injectEnvironment = injectEnvironment;
        this.injectProperties = injectProperties;
        this.ontrackLog = ontrackLog;
        this.ignoreFailure = ignoreFailure;
    }

    public boolean isUsingText() {
        return this.usingText;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public String getInjectEnvironment() {
        return this.injectEnvironment;
    }

    public String getInjectProperties() {
        return this.injectProperties;
    }

    public boolean isOntrackLog() {
        return this.ontrackLog;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> theBuild, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        block5: {
            String script = OntrackPluginSupport.readScript(theBuild, this.usingText, this.scriptText, this.scriptPath);
            JenkinsConnector jenkins = new JenkinsConnector((Run)theBuild, (TaskListener)listener, runInfo -> {});
            OntrackDSLRunner dsl = OntrackDSLRunner.getRunnerForBuild((Item)theBuild.getProject(), (TaskListener)listener).injectEnvironment(this.injectEnvironment, (Run)theBuild, (TaskListener)listener).injectProperties(this.injectProperties, (Run)theBuild, (TaskListener)listener).setSandbox(this.sandbox).addBinding("jenkins", jenkins).addBinding("out", listener.getLogger());
            try {
                dsl.run(script);
            }
            catch (OTMessageClientException ex) {
                listener.getLogger().format("[ontrack] ERROR %s%n", ex.getMessage());
                if (!this.ignoreFailure) {
                    theBuild.setResult(Result.FAILURE);
                }
            }
            catch (OTHttpClientException ex) {
                listener.getLogger().format("[ontrack] ERROR %s%n", ex.getMessage());
                if (this.ontrackLog) {
                    ex.printStackTrace(listener.getLogger());
                }
                if (this.ignoreFailure) break block5;
                theBuild.setResult(Result.FAILURE);
            }
        }
        return true;
    }

    @Extension
    public static final class OntrackDSLNotifierDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public OntrackDSLNotifierDescriptorImpl() {
            super(OntrackDSLNotifier.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Ontrack: DSL action";
        }
    }
}

