/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.jenkins;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import java.util.List;
import java.util.Map;
import net.nemerosa.ontrack.jenkins.AbstractOntrackMultipleParameterDefinition;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class OntrackChoiceParameterDefinition
extends AbstractOntrackMultipleParameterDefinition {
    @DataBoundConstructor
    public OntrackChoiceParameterDefinition(String name, String description, String dsl, boolean sandbox, String valueProperty, String injectProperties) {
        super(name, description, dsl, sandbox, valueProperty, injectProperties);
    }

    public OntrackChoiceParameterDefinition(String name, String description, String dsl, boolean sandbox, String valueProperty, Map<String, Object> bindings) {
        super(name, description, dsl, sandbox, valueProperty, bindings);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] value = req.getParameterValues(this.getName());
        if (value == null) {
            return this.getDefaultParameterValue();
        }
        if (value.length != 1) {
            throw new IllegalArgumentException(String.format("Illegal number of parameter values for %s: %d", this.getName(), value.length));
        }
        List<String> choices = this.getChoices();
        if (choices.contains(value[0])) {
            return new StringParameterValue(this.getName(), value[0], this.getDescription());
        }
        throw new IllegalArgumentException(String.format("Value %s for parameter %s is not a valid choice.", value[0], this.getName()));
    }

    public StringParameterValue getDefaultParameterValue() {
        List<String> choices = this.getChoices();
        String value = choices.isEmpty() ? "" : choices.get(0);
        return new StringParameterValue(this.getName(), value, this.getDescription());
    }

    @Extension
    @Symbol(value={"ontrackChoiceParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Ontrack: Parameter choice";
        }

        public String getHelpFile() {
            return "/help/ontrack/parameter-choice.html";
        }
    }
}

