/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import com.google.common.base.Objects;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.oic.OicSecurityRealm;

public class WellKnownOpenIDConfigurationResponse
extends GenericJson {
    @Key(value="authorization_endpoint")
    private String authorizationEndpoint;
    @Key(value="token_endpoint")
    private String tokenEndpoint;
    @Key(value="token_endpoint_auth_methods_supported")
    private Set<String> tokenAuthMethods;
    @Key(value="userinfo_endpoint")
    private String userinfoEndpoint;
    @Key(value="jwks_uri")
    private String jwksUri;
    @Key(value="scopes_supported")
    private Set<String> scopesSupported;
    @Key(value="end_session_endpoint")
    private String endSessionEndpoint;

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public Set<String> getTokenAuthMethods() {
        return this.tokenAuthMethods;
    }

    public OicSecurityRealm.TokenAuthMethod getPreferredTokenAuthMethod() {
        if (this.tokenAuthMethods != null && !this.tokenAuthMethods.isEmpty()) {
            if (this.tokenAuthMethods.contains("client_secret_post")) {
                return OicSecurityRealm.TokenAuthMethod.client_secret_post;
            }
            if (this.tokenAuthMethods.contains("client_secret_basic")) {
                return OicSecurityRealm.TokenAuthMethod.client_secret_basic;
            }
            return OicSecurityRealm.TokenAuthMethod.client_secret_post;
        }
        return OicSecurityRealm.TokenAuthMethod.client_secret_post;
    }

    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public Set<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public Map<String, Object> getKnownKeys() {
        GenericJson clone = this.clone();
        for (String key : this.getUnknownKeys().keySet()) {
            clone.remove(key);
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof WellKnownOpenIDConfigurationResponse)) {
            return false;
        }
        WellKnownOpenIDConfigurationResponse obj = (WellKnownOpenIDConfigurationResponse)((Object)o);
        if (!Objects.equal((Object)this.authorizationEndpoint, (Object)obj.getAuthorizationEndpoint())) {
            return false;
        }
        if (!Objects.equal((Object)this.tokenEndpoint, (Object)obj.getTokenEndpoint())) {
            return false;
        }
        if (!Objects.equal((Object)this.userinfoEndpoint, (Object)obj.getUserinfoEndpoint())) {
            return false;
        }
        if (!Objects.equal((Object)this.jwksUri, (Object)obj.getJwksUri())) {
            return false;
        }
        if (!Objects.equal(this.scopesSupported, obj.getScopesSupported())) {
            return false;
        }
        return Objects.equal((Object)this.endSessionEndpoint, (Object)obj.getEndSessionEndpoint());
    }

    public int hashCode() {
        return (this.authorizationEndpoint + this.tokenEndpoint + this.userinfoEndpoint + this.jwksUri + this.scopesSupported + this.endSessionEndpoint).hashCode();
    }
}

