/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.ConnectionFactory;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.Data;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.SecurityRealm;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.Secret;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.oic.JenkinsAwareConnectionFactory;
import org.jenkinsci.plugins.oic.Messages;
import org.jenkinsci.plugins.oic.OicSession;
import org.jenkinsci.plugins.oic.OicTokenResponse;
import org.jenkinsci.plugins.oic.OicUserDetails;
import org.jenkinsci.plugins.oic.OicUserProperty;
import org.jenkinsci.plugins.oic.WellKnownOpenIDConfigurationResponse;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class OicSecurityRealm
extends SecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(OicSecurityRealm.class.getName());
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static final String ID_TOKEN_REQUEST_ATTRIBUTE = "oic-id-token";
    private static final String STATE_REQUEST_ATTRIBUTE = "oic-state";
    private static final String NO_SECRET = "none";
    private final String clientId;
    private final Secret clientSecret;
    private String wellKnownOpenIDConfigurationUrl = null;
    private String tokenServerUrl = null;
    private TokenAuthMethod tokenAuthMethod;
    private String authorizationServerUrl = null;
    private String userInfoServerUrl = null;
    private String userNameField = "sub";
    private String tokenFieldToCheckKey = null;
    private String tokenFieldToCheckValue = null;
    private String fullNameFieldName = null;
    private String emailFieldName = null;
    private String groupsFieldName = null;
    private String scopes = null;
    private final boolean disableSslVerification;
    private boolean logoutFromOpenidProvider = true;
    private String endSessionEndpoint = null;
    private String postLogoutRedirectUrl;
    private boolean escapeHatchEnabled = false;
    private String escapeHatchUsername = null;
    private Secret escapeHatchSecret = null;
    private String escapeHatchGroup = null;
    private String automanualconfigure = null;
    private transient Boolean overrideScopesDefined = null;
    private String overrideScopes = null;
    private boolean rootURLFromRequest = false;
    private boolean sendScopesInTokenRequest = false;
    private transient String endSessionUrl;
    private transient HttpTransport httpTransport;
    private static final Random RANDOM = new Random();

    @Deprecated
    public OicSecurityRealm(String clientId, String clientSecret, String wellKnownOpenIDConfigurationUrl, String tokenServerUrl, String tokenAuthMethod, String authorizationServerUrl, String userInfoServerUrl, String userNameField, String tokenFieldToCheckKey, String tokenFieldToCheckValue, String fullNameFieldName, String emailFieldName, String scopes, String groupsFieldName, Boolean disableSslVerification, Boolean logoutFromOpenidProvider, String endSessionEndpoint, String postLogoutRedirectUrl, Boolean escapeHatchEnabled, String escapeHatchUsername, String escapeHatchSecret, String escapeHatchGroup, String automanualconfigure) throws IOException {
        this.disableSslVerification = (Boolean)Util.fixNull((Object)disableSslVerification, (Object)Boolean.FALSE);
        this.httpTransport = OicSecurityRealm.constructHttpTransport(this.disableSslVerification);
        this.clientId = clientId;
        Secret secret = this.clientSecret = clientSecret != null && !clientSecret.toLowerCase().equals(NO_SECRET) ? Secret.fromString((String)clientSecret) : null;
        if ("auto".equals(automanualconfigure) || Util.fixNull((String)automanualconfigure).isEmpty() && !Util.fixNull((String)wellKnownOpenIDConfigurationUrl).isEmpty()) {
            this.automanualconfigure = "auto";
            this.wellKnownOpenIDConfigurationUrl = Util.fixEmpty((String)wellKnownOpenIDConfigurationUrl);
            URL url = new URL(wellKnownOpenIDConfigurationUrl);
            HttpRequest request = this.httpTransport.createRequestFactory().buildGetRequest(new GenericUrl(url));
            HttpResponse response = request.execute();
            WellKnownOpenIDConfigurationResponse config = (WellKnownOpenIDConfigurationResponse)((Object)JSON_FACTORY.fromInputStream(response.getContent(), Charset.defaultCharset(), WellKnownOpenIDConfigurationResponse.class));
            this.authorizationServerUrl = config.getAuthorizationEndpoint();
            this.tokenServerUrl = config.getTokenEndpoint();
            this.tokenAuthMethod = config.getPreferredTokenAuthMethod();
            this.userInfoServerUrl = config.getUserinfoEndpoint();
            this.setScopes(config.getScopesSupported() != null ? StringUtils.join(config.getScopesSupported(), (String)" ") : null);
            this.endSessionEndpoint = config.getEndSessionEndpoint();
        } else {
            this.automanualconfigure = "manual";
            this.authorizationServerUrl = authorizationServerUrl;
            this.tokenServerUrl = tokenServerUrl;
            this.tokenAuthMethod = TokenAuthMethod.valueOf(StringUtils.defaultIfBlank((String)tokenAuthMethod, (String)"client_secret_post"));
            this.userInfoServerUrl = userInfoServerUrl;
            this.setScopes(scopes);
            this.wellKnownOpenIDConfigurationUrl = null;
            this.endSessionEndpoint = endSessionEndpoint;
        }
        this.tokenFieldToCheckKey = Util.fixEmpty((String)tokenFieldToCheckKey);
        this.tokenFieldToCheckValue = Util.fixEmpty((String)tokenFieldToCheckValue);
        this.userNameField = Util.fixEmpty((String)userNameField) == null ? "sub" : userNameField;
        this.fullNameFieldName = Util.fixEmpty((String)fullNameFieldName);
        this.emailFieldName = Util.fixEmpty((String)emailFieldName);
        this.groupsFieldName = Util.fixEmpty((String)groupsFieldName);
        this.logoutFromOpenidProvider = (Boolean)Util.fixNull((Object)logoutFromOpenidProvider, (Object)Boolean.TRUE);
        this.postLogoutRedirectUrl = postLogoutRedirectUrl;
        this.escapeHatchEnabled = (Boolean)Util.fixNull((Object)escapeHatchEnabled, (Object)Boolean.FALSE);
        this.escapeHatchUsername = Util.fixEmpty((String)escapeHatchUsername);
        this.escapeHatchSecret = Secret.fromString((String)escapeHatchSecret);
        this.escapeHatchGroup = Util.fixEmpty((String)escapeHatchGroup);
    }

    @DataBoundConstructor
    public OicSecurityRealm(String clientId, String clientSecret, String authorizationServerUrl, String tokenServerUrl, String tokenAuthMethod, String userInfoServerUrl, String endSessionEndpoint, String scopes, String automanualconfigure, Boolean disableSslVerification) throws IOException {
        this.disableSslVerification = (Boolean)Util.fixNull((Object)disableSslVerification, (Object)Boolean.FALSE);
        this.httpTransport = OicSecurityRealm.constructHttpTransport(this.disableSslVerification);
        this.clientId = clientId;
        this.clientSecret = clientSecret != null && !clientSecret.toLowerCase().equals(NO_SECRET) ? Secret.fromString((String)clientSecret) : null;
        this.automanualconfigure = Util.fixNull((String)automanualconfigure);
        this.authorizationServerUrl = authorizationServerUrl;
        this.tokenServerUrl = tokenServerUrl;
        this.tokenAuthMethod = TokenAuthMethod.valueOf(StringUtils.defaultIfBlank((String)tokenAuthMethod, (String)"client_secret_post"));
        this.userInfoServerUrl = userInfoServerUrl;
        this.endSessionEndpoint = endSessionEndpoint;
        this.setScopes(scopes);
    }

    protected Object readResolve() {
        if (this.httpTransport == null) {
            this.httpTransport = OicSecurityRealm.constructHttpTransport(this.isDisableSslVerification());
        }
        if (!Strings.isNullOrEmpty((String)this.endSessionUrl)) {
            try {
                Field field = ((Object)((Object)this)).getClass().getDeclaredField("endSessionEndpoint");
                field.setAccessible(true);
                field.set((Object)this, this.endSessionUrl + "/");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LOGGER.log(Level.SEVERE, "Can't set endSessionEndpoint from old value", e);
            }
        }
        return this;
    }

    private static HttpTransport constructHttpTransport(boolean disableSslVerification) {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        builder.setConnectionFactory((ConnectionFactory)new JenkinsAwareConnectionFactory());
        if (disableSslVerification) {
            try {
                builder.doNotValidateCertificate();
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public String getClientId() {
        return this.clientId;
    }

    public Secret getClientSecret() {
        return this.clientSecret == null ? Secret.fromString((String)NO_SECRET) : this.clientSecret;
    }

    public String getWellKnownOpenIDConfigurationUrl() {
        return this.wellKnownOpenIDConfigurationUrl;
    }

    public String getTokenServerUrl() {
        return this.tokenServerUrl;
    }

    public TokenAuthMethod getTokenAuthMethod() {
        return this.tokenAuthMethod;
    }

    public String getAuthorizationServerUrl() {
        return this.authorizationServerUrl;
    }

    public String getUserInfoServerUrl() {
        return this.userInfoServerUrl;
    }

    public String getUserNameField() {
        return this.userNameField;
    }

    public String getTokenFieldToCheckKey() {
        return this.tokenFieldToCheckKey;
    }

    public String getTokenFieldToCheckValue() {
        return this.tokenFieldToCheckValue;
    }

    public String getFullNameFieldName() {
        return this.fullNameFieldName;
    }

    public String getEmailFieldName() {
        return this.emailFieldName;
    }

    public String getGroupsFieldName() {
        return this.groupsFieldName;
    }

    public String getScopes() {
        return this.scopes != null ? this.scopes : "openid email";
    }

    public boolean isDisableSslVerification() {
        return this.disableSslVerification;
    }

    public boolean isLogoutFromOpenidProvider() {
        return this.logoutFromOpenidProvider;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public String getPostLogoutRedirectUrl() {
        return this.postLogoutRedirectUrl;
    }

    public boolean isEscapeHatchEnabled() {
        return this.escapeHatchEnabled;
    }

    public String getEscapeHatchUsername() {
        return this.escapeHatchUsername;
    }

    public Secret getEscapeHatchSecret() {
        return this.escapeHatchSecret;
    }

    public String getEscapeHatchGroup() {
        return this.escapeHatchGroup;
    }

    public String getAutomanualconfigure() {
        return this.automanualconfigure;
    }

    public boolean isOverrideScopesDefined() {
        return this.overrideScopes != null;
    }

    public String getOverrideScopes() {
        return this.overrideScopes;
    }

    public boolean isRootURLFromRequest() {
        return this.rootURLFromRequest;
    }

    public boolean isSendScopesInTokenRequest() {
        return this.sendScopesInTokenRequest;
    }

    public boolean isAutoConfigure() {
        return "auto".equals(this.automanualconfigure);
    }

    @DataBoundSetter
    public void setWellKnownOpenIDConfigurationUrl(String wellKnownOpenIDConfigurationUrl) throws IOException {
        if (this.isAutoConfigure() || this.automanualconfigure.isEmpty() && !Util.fixNull((String)wellKnownOpenIDConfigurationUrl).isEmpty()) {
            this.automanualconfigure = "auto";
            this.wellKnownOpenIDConfigurationUrl = wellKnownOpenIDConfigurationUrl;
            URL url = new URL(wellKnownOpenIDConfigurationUrl);
            HttpRequest request = this.httpTransport.createRequestFactory().buildGetRequest(new GenericUrl(url));
            HttpResponse response = request.execute();
            WellKnownOpenIDConfigurationResponse config = (WellKnownOpenIDConfigurationResponse)((Object)JSON_FACTORY.fromInputStream(response.getContent(), Charset.defaultCharset(), WellKnownOpenIDConfigurationResponse.class));
            this.authorizationServerUrl = config.getAuthorizationEndpoint();
            this.tokenServerUrl = config.getTokenEndpoint();
            this.tokenAuthMethod = config.getPreferredTokenAuthMethod();
            this.userInfoServerUrl = config.getUserinfoEndpoint();
            this.setScopes(config.getScopesSupported() != null ? StringUtils.join(config.getScopesSupported(), (String)" ") : null);
            this.applyOverrideScopes();
            this.endSessionEndpoint = config.getEndSessionEndpoint();
        } else {
            this.automanualconfigure = "manual";
            this.wellKnownOpenIDConfigurationUrl = null;
        }
    }

    private void applyOverrideScopes() {
        if (!"auto".equals(this.automanualconfigure) || this.overrideScopes == null) {
            return;
        }
        if (this.scopes == null) {
            this.scopes = this.overrideScopes;
            return;
        }
        HashSet<String> scopesSet = new HashSet<String>(Arrays.asList(this.scopes.trim().split("\\s+")));
        scopesSet.retainAll(Arrays.asList(this.overrideScopes.trim().split("\\s+")));
        this.setScopes(StringUtils.join(scopesSet, (String)" "));
    }

    @DataBoundSetter
    public void setUserNameField(String userNameField) {
        this.userNameField = Util.fixEmpty((String)userNameField);
    }

    @DataBoundSetter
    public void setTokenFieldToCheckKey(String tokenFieldToCheckKey) {
        this.tokenFieldToCheckKey = Util.fixEmpty((String)tokenFieldToCheckKey);
    }

    @DataBoundSetter
    public void setTokenFieldToCheckValue(String tokenFieldToCheckValue) {
        this.tokenFieldToCheckValue = Util.fixEmpty((String)tokenFieldToCheckValue);
    }

    @DataBoundSetter
    public void setFullNameFieldName(String fullNameFieldName) {
        this.fullNameFieldName = Util.fixEmpty((String)fullNameFieldName);
    }

    @DataBoundSetter
    public void setEmailFieldName(String emailFieldName) {
        this.emailFieldName = Util.fixEmpty((String)emailFieldName);
    }

    @DataBoundSetter
    public void setGroupsFieldName(String groupsFieldName) {
        this.groupsFieldName = Util.fixEmpty((String)groupsFieldName);
    }

    public void setScopes(String scopes) {
        this.scopes = Util.fixEmptyAndTrim((String)scopes);
    }

    @DataBoundSetter
    public void setLogoutFromOpenidProvider(boolean logoutFromOpenidProvider) {
        this.logoutFromOpenidProvider = logoutFromOpenidProvider;
    }

    @DataBoundSetter
    public void setPostLogoutRedirectUrl(String postLogoutRedirectUrl) {
        this.postLogoutRedirectUrl = Util.fixEmpty((String)postLogoutRedirectUrl);
    }

    @DataBoundSetter
    public void setEscapeHatchEnabled(boolean escapeHatchEnabled) {
        this.escapeHatchEnabled = escapeHatchEnabled;
    }

    @DataBoundSetter
    public void setEscapeHatchUsername(String escapeHatchUsername) {
        this.escapeHatchUsername = Util.fixEmpty((String)escapeHatchUsername);
    }

    @DataBoundSetter
    public void setEscapeHatchSecret(Secret escapeHatchSecret) {
        this.escapeHatchSecret = escapeHatchSecret;
    }

    @DataBoundSetter
    public void setEscapeHatchGroup(String escapeHatchGroup) {
        this.escapeHatchGroup = Util.fixEmpty((String)escapeHatchGroup);
    }

    @DataBoundSetter
    public void setOverrideScopesDefined(boolean overrideScopesDefined) {
        if (overrideScopesDefined) {
            this.overrideScopesDefined = Boolean.TRUE;
        } else {
            this.overrideScopesDefined = Boolean.FALSE;
            this.overrideScopes = null;
            this.applyOverrideScopes();
        }
    }

    @DataBoundSetter
    public void setOverrideScopes(String overrideScopes) {
        if (this.overrideScopesDefined == null || this.overrideScopesDefined.booleanValue()) {
            this.overrideScopes = Util.fixEmptyAndTrim((String)overrideScopes);
            this.applyOverrideScopes();
        }
    }

    @DataBoundSetter
    public void setRootURLFromRequest(boolean rootURLFromRequest) {
        this.rootURLFromRequest = rootURLFromRequest;
    }

    @DataBoundSetter
    public void setSendScopesInTokenRequest(boolean sendScopesInTokenRequest) {
        this.sendScopesInTokenRequest = sendScopesInTokenRequest;
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    public String getAuthenticationGatewayUrl() {
        return "securityRealm/escapeHatch";
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof AnonymousAuthenticationToken) {
                    return authentication;
                }
                if (authentication instanceof UsernamePasswordAuthenticationToken && OicSecurityRealm.this.escapeHatchEnabled) {
                    OicSecurityRealm.this.randomWait();
                    if (authentication.getPrincipal().toString().equals(OicSecurityRealm.this.escapeHatchUsername) && authentication.getCredentials().toString().equals(Secret.toString((Secret)OicSecurityRealm.this.escapeHatchSecret))) {
                        ArrayList<Object> grantedAuthorities = new ArrayList<Object>();
                        grantedAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY2);
                        if (StringUtils.isNotBlank((String)OicSecurityRealm.this.escapeHatchGroup)) {
                            grantedAuthorities.add(new SimpleGrantedAuthority(OicSecurityRealm.this.escapeHatchGroup));
                        }
                        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)OicSecurityRealm.this.escapeHatchUsername, (Object)"", grantedAuthorities);
                        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
                        OicUserDetails userDetails = new OicUserDetails(OicSecurityRealm.this.escapeHatchUsername, grantedAuthorities);
                        SecurityListener.fireAuthenticated2((UserDetails)userDetails);
                        return token;
                    }
                    throw new BadCredentialsException("Wrong username and password: " + authentication);
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        }, new UserDetailsService(){

            public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
                LOGGER.fine("loadUserByUsername in createSecurityComponents called, username: " + username);
                User u = User.get((String)username, (boolean)false, Collections.emptyMap());
                if (u == null) {
                    LOGGER.fine("loadUserByUsername in createSecurityComponents called, no user '" + username + "' found");
                    throw new UsernameNotFoundException(username);
                }
                LOGGER.fine("loadUserByUsername in createSecurityComponents called, user: " + u);
                OicUserProperty oicProp = (OicUserProperty)u.getProperty(OicUserProperty.class);
                List<Object> auths = new ArrayList();
                if (oicProp != null) {
                    auths = oicProp.getAuthoritiesAsGrantedAuthorities();
                    LOGGER.fine("loadUserByUsername in createSecurityComponents called, oic prop found with username '" + oicProp.getUserName() + "', auths size: " + auths.size());
                }
                return new OicUserDetails(username, auths);
            }
        });
    }

    protected AuthorizationCodeFlow buildAuthorizationCodeFlow() {
        Credential.AccessMethod tokenAccessMethod = BearerToken.queryParameterAccessMethod();
        ClientParametersAuthentication authInterceptor = new ClientParametersAuthentication(this.clientId, Secret.toString((Secret)this.clientSecret));
        if (TokenAuthMethod.client_secret_basic.equals((Object)this.tokenAuthMethod)) {
            tokenAccessMethod = BearerToken.authorizationHeaderAccessMethod();
            authInterceptor = new BasicAuthentication(this.clientId, Secret.toString((Secret)this.clientSecret));
        }
        return new AuthorizationCodeFlow.Builder(tokenAccessMethod, this.httpTransport, JSON_FACTORY, new GenericUrl(this.tokenServerUrl), (HttpExecuteInterceptor)authInterceptor, this.clientId, this.authorizationServerUrl).setScopes(Arrays.asList(this.getScopes())).build();
    }

    @Restricted(value={DoNotUse.class})
    public org.kohsuke.stapler.HttpResponse doCommenceLogin(@QueryParameter String from, @Header(value="Referer") String referer) {
        final String redirectOnFinish = this.determineRedirectTarget(from, referer);
        final AuthorizationCodeFlow flow = this.buildAuthorizationCodeFlow();
        return new OicSession(flow, from, this.buildOAuthRedirectUrl()){

            @Override
            public org.kohsuke.stapler.HttpResponse onSuccess(String authorizationCode) {
                try {
                    String username;
                    AuthorizationCodeTokenRequest tokenRequest = flow.newTokenRequest(authorizationCode).setRedirectUri(OicSecurityRealm.this.buildOAuthRedirectUrl()).setResponseClass(OicTokenResponse.class);
                    if (!OicSecurityRealm.this.sendScopesInTokenRequest) {
                        tokenRequest.setScopes(Collections.emptyList());
                    }
                    OicTokenResponse response = (OicTokenResponse)tokenRequest.execute();
                    this.setIdToken(response.getIdToken());
                    IdToken idToken = response.parseIdToken();
                    if (OicSecurityRealm.this.failedCheckOfTokenField(idToken)) {
                        return HttpResponses.errorWithoutStack((int)401, (String)"Unauthorized");
                    }
                    GenericJson userInfo = null;
                    if (!Strings.isNullOrEmpty((String)OicSecurityRealm.this.userInfoServerUrl)) {
                        userInfo = OicSecurityRealm.this.getUserInfo(flow, response.getAccessToken());
                    }
                    if ((username = OicSecurityRealm.this.determineStringField(OicSecurityRealm.this.userNameField, idToken, userInfo)) == null) {
                        return HttpResponses.error((int)500, (String)("no field '" + OicSecurityRealm.this.userNameField + "' was supplied in the UserInfo or the IdToken payload to be used as the username"));
                    }
                    flow.createAndStoreCredential((TokenResponse)response, null);
                    OicSecurityRealm.this.loginAndSetUserData(username.toString(), idToken, userInfo);
                    return new HttpRedirect(redirectOnFinish);
                }
                catch (IOException e) {
                    return HttpResponses.error((int)500, (Throwable)e);
                }
            }
        }.doCommenceLogin();
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="False positive in spotbug about DMI_RANDOM_USED_ONLY_ONCE")
    private void randomWait() {
        try {
            Thread.sleep(1000 + RANDOM.nextInt(1000));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private GenericJson getUserInfo(AuthorizationCodeFlow flow, final String accessToken) throws IOException {
        HttpRequestFactory requestFactory = flow.getTransport().createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.getHeaders().setAuthorization("Bearer " + accessToken);
            }
        });
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(this.userInfoServerUrl));
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        if (response.isSuccessStatusCode()) {
            if (response.getHeaders().getContentType().contains("application/jwt")) {
                String token = response.parseAsString();
                JsonWebSignature jws = JsonWebSignature.parse((JsonFactory)flow.getJsonFactory(), (String)token);
                return jws.getPayload();
            }
            JsonObjectParser parser = new JsonObjectParser(flow.getJsonFactory());
            return (GenericJson)parser.parseAndClose(response.getContent(), response.getContentCharset(), GenericJson.class);
        }
        throw new HttpResponseException(response);
    }

    private boolean failedCheckOfTokenField(IdToken idToken) {
        if (this.tokenFieldToCheckKey == null || this.tokenFieldToCheckValue == null) {
            return false;
        }
        Object value = this.getField((GenericJson)idToken.getPayload(), this.tokenFieldToCheckKey);
        if (value == null) {
            return true;
        }
        return !this.tokenFieldToCheckValue.equals(String.valueOf(value));
    }

    private UsernamePasswordAuthenticationToken loginAndSetUserData(String userName, IdToken idToken, GenericJson userInfo) throws IOException {
        String fullName;
        List<GrantedAuthority> grantedAuthorities = this.determineAuthorities(idToken, userInfo);
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder grantedAuthoritiesAsString = new StringBuilder("(");
            for (GrantedAuthority grantedAuthority : grantedAuthorities) {
                grantedAuthoritiesAsString.append(" ").append(grantedAuthority.getAuthority());
            }
            grantedAuthoritiesAsString.append(" )");
            LOGGER.finest("GrantedAuthorities:" + grantedAuthoritiesAsString);
        }
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)userName, (Object)"", grantedAuthorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        User user = User.get2((Authentication)token);
        if (user == null) {
            throw new IOException("Cannot set OIDC property on anonymous user");
        }
        user.addProperty((UserProperty)new OicUserProperty(userName, grantedAuthorities));
        String email = this.determineStringField(this.emailFieldName, idToken, userInfo);
        if (email != null) {
            user.addProperty((UserProperty)new Mailer.UserProperty(email));
        }
        if ((fullName = this.determineStringField(this.fullNameFieldName, idToken, userInfo)) != null) {
            user.setFullName(fullName);
        }
        OicUserDetails userDetails = new OicUserDetails(userName, grantedAuthorities);
        SecurityListener.fireAuthenticated2((UserDetails)userDetails);
        return token;
    }

    private String determineStringField(String fieldName, IdToken idToken, GenericJson userInfo) {
        if (fieldName != null) {
            String fieldValue;
            String fieldValue2;
            Object field;
            if (userInfo != null && (field = this.getField(userInfo, fieldName)) != null && field instanceof String && (fieldValue2 = Util.fixEmptyAndTrim((String)((String)field))) != null) {
                return fieldValue2;
            }
            if (idToken != null && (fieldValue = Util.fixEmptyAndTrim((String)this.getField(idToken, fieldName))) != null) {
                return fieldValue;
            }
        }
        return null;
    }

    private List<GrantedAuthority> determineAuthorities(IdToken idToken, GenericJson userInfo) {
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        grantedAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY2);
        if (StringUtils.isNotBlank((String)this.groupsFieldName)) {
            if (!Strings.isNullOrEmpty((String)this.userInfoServerUrl) && this.containsField(userInfo, this.groupsFieldName)) {
                LOGGER.fine("UserInfo contains group field name: " + this.groupsFieldName + " with value class:" + this.getField(userInfo, this.groupsFieldName).getClass());
                List<String> groupNames = this.ensureString(this.getField(userInfo, this.groupsFieldName));
                if (groupNames.isEmpty()) {
                    LOGGER.warning("UserInfo does not contains groups in " + this.groupsFieldName);
                } else {
                    LOGGER.fine("Number of groups in groupNames: " + groupNames.size());
                }
                for (String groupName : groupNames) {
                    LOGGER.fine("Adding group from UserInfo: " + groupName);
                    grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(groupName));
                }
            } else if (this.containsField((GenericJson)idToken.getPayload(), this.groupsFieldName)) {
                LOGGER.fine("idToken contains group field name: " + this.groupsFieldName + " with value class:" + this.getField((GenericJson)idToken.getPayload(), this.groupsFieldName).getClass());
                List<String> groupNames = this.ensureString(this.getField((GenericJson)idToken.getPayload(), this.groupsFieldName));
                LOGGER.fine("Number of groups in groupNames: " + groupNames.size());
                for (String groupName : groupNames) {
                    LOGGER.fine("Adding group from idToken: " + groupName);
                    grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(groupName));
                }
            } else {
                LOGGER.warning("idToken and userInfo did not contain group field name: " + this.groupsFieldName);
            }
        } else {
            LOGGER.fine("Not adding groups because groupsFieldName is not set. groupsFieldName=" + this.groupsFieldName);
        }
        return grantedAuthorities;
    }

    private List<String> ensureString(Object field) {
        if (field == null || Data.isNull((Object)field)) {
            LOGGER.warning("userInfo did not contain a valid group field content, got null");
            return Collections.emptyList();
        }
        if (field instanceof String) {
            String sField = (String)field;
            String[] rawFields = sField.split("[\\s\\[\\],]");
            ArrayList<String> result = new ArrayList<String>();
            for (String rawField : rawFields) {
                if (rawField == null || rawField.isEmpty()) continue;
                result.add(rawField);
            }
            return result;
        }
        try {
            return (List)field;
        }
        catch (ClassCastException e) {
            LOGGER.warning("userInfo did not contain a valid group field content, got: " + field.getClass().getSimpleName());
            return Collections.emptyList();
        }
    }

    private String getField(IdToken idToken, String fullNameFieldName) {
        Object value = this.getField((GenericJson)idToken.getPayload(), fullNameFieldName);
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    @Restricted(value={DoNotUse.class})
    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        OicSession oicSession = OicSession.getCurrent();
        if (oicSession != null) {
            req.setAttribute(ID_TOKEN_REQUEST_ATTRIBUTE, (Object)oicSession.getIdToken());
            req.setAttribute(STATE_REQUEST_ATTRIBUTE, (Object)oicSession.getState());
        }
        super.doLogout(req, rsp);
    }

    public String getPostLogOutUrl2(StaplerRequest req, Authentication auth) {
        if (this.logoutFromOpenidProvider && !Strings.isNullOrEmpty((String)this.endSessionEndpoint)) {
            StringBuilder openidLogoutEndpoint = new StringBuilder(this.endSessionEndpoint);
            openidLogoutEndpoint.append("?id_token_hint=").append(req.getAttribute(ID_TOKEN_REQUEST_ATTRIBUTE));
            openidLogoutEndpoint.append("&state=").append(req.getAttribute(STATE_REQUEST_ATTRIBUTE));
            if (this.postLogoutRedirectUrl != null) {
                try {
                    openidLogoutEndpoint.append("&post_logout_redirect_uri=").append(URLEncoder.encode(this.postLogoutRedirectUrl, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            return openidLogoutEndpoint.toString();
        }
        return this.getFinalLogoutUrl(req, auth);
    }

    private String getFinalLogoutUrl(StaplerRequest req, Authentication auth) {
        if (Jenkins.get().hasPermission(Jenkins.READ)) {
            return super.getPostLogOutUrl2(req, auth);
        }
        return req.getContextPath() + "/" + "OicLogout";
    }

    private String getRootUrl() {
        if (this.rootURLFromRequest) {
            return Jenkins.get().getRootUrlFromRequest();
        }
        return Jenkins.get().getRootUrl();
    }

    private String determineRedirectTarget(@QueryParameter String from, @Header(value="Referer") String referer) {
        String target = from != null ? from : (referer != null ? referer : this.getRootUrl());
        return target;
    }

    private String buildOAuthRedirectUrl() throws NullPointerException {
        String rootUrl = this.getRootUrl();
        if (rootUrl == null) {
            throw new NullPointerException("Jenkins root url should not be null");
        }
        return rootUrl + "securityRealm/finishLogin";
    }

    public org.kohsuke.stapler.HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        OicSession currentSession = OicSession.getCurrent();
        if (currentSession == null) {
            LOGGER.fine("No session to resume (perhaps jenkins was restarted?)");
            return HttpResponses.errorWithoutStack((int)401, (String)"Unauthorized");
        }
        return currentSession.doFinishLogin(request);
    }

    public Object getField(GenericJson payload, String field) {
        Object value = this.lookup((Map)payload, field);
        if (value == PlaceHolder.ABSENT) {
            return null;
        }
        return value;
    }

    public boolean containsField(GenericJson payload, String field) {
        return this.lookup((Map)payload, field) != PlaceHolder.ABSENT;
    }

    private Object lookup(Map parsedJson, String key) {
        if (key.contains("\"")) {
            int indexMarker = key.indexOf(34);
            Object nested = parsedJson.get(key.substring(0, indexMarker));
            if (nested == null || !(nested instanceof Map)) {
                return parsedJson.containsKey(key.substring(0, indexMarker)) ? null : PlaceHolder.ABSENT;
            }
            return this.lookup((Map)nested, key.substring(indexMarker));
        }
        String firstPart = key;
        int lastPos = key.length();
        do {
            Object nested;
            Object value;
            if ((value = parsedJson.get(firstPart = firstPart.substring(0, lastPos))) == null) continue;
            if (firstPart.length() == key.length()) {
                if (value instanceof Map) {
                    return PlaceHolder.ABSENT;
                }
                return value;
            }
            if (!(value instanceof Map) || (nested = this.lookup((Map)value, key.substring(firstPart.length() + 1, key.length()))) == null) continue;
            return nested;
        } while ((lastPos = firstPart.lastIndexOf(46)) != -1);
        return parsedJson.containsKey(firstPart) ? null : PlaceHolder.ABSENT;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public boolean isAuto() {
            SecurityRealm realm = Jenkins.get().getSecurityRealm();
            return realm instanceof OicSecurityRealm && StringUtils.isNotBlank((String)((OicSecurityRealm)realm).getWellKnownOpenIDConfigurationUrl());
        }

        public boolean isManual() {
            return Jenkins.get().getSecurityRealm() instanceof OicSecurityRealm && !this.isAuto();
        }

        public String getDisplayName() {
            return Messages.OicSecurityRealm_DisplayName();
        }

        @RequirePOST
        public FormValidation doCheckClientId(@QueryParameter String clientId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)clientId) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_ClientIdRequired());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckClientSecret(@QueryParameter String clientSecret) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)clientSecret) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_ClientSecretRequired());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckWellKnownOpenIDConfigurationUrl(@QueryParameter String wellKnownOpenIDConfigurationUrl, @QueryParameter boolean disableSslVerification) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                URL url = new URL(wellKnownOpenIDConfigurationUrl);
                HttpRequest request = OicSecurityRealm.constructHttpTransport(disableSslVerification).createRequestFactory().buildGetRequest(new GenericUrl(url));
                HttpResponse response = request.execute();
                WellKnownOpenIDConfigurationResponse config = (WellKnownOpenIDConfigurationResponse)((Object)JSON_FACTORY.fromInputStream(response.getContent(), Charset.defaultCharset(), WellKnownOpenIDConfigurationResponse.class));
                if (config.getAuthorizationEndpoint() == null || config.getTokenEndpoint() == null) {
                    return FormValidation.warning((String)Messages.OicSecurityRealm_URLNotAOpenIdEnpoint());
                }
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_NotAValidURL());
            }
            catch (HttpResponseException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_CouldNotRetreiveWellKnownConfig(e.getStatusCode(), e.getStatusMessage()));
            }
            catch (JsonParseException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_CouldNotParseResponse());
            }
            catch (IOException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_ErrorRetreivingWellKnownConfig());
            }
        }

        @RequirePOST
        public FormValidation doCheckTokenServerUrl(@QueryParameter String tokenServerUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)tokenServerUrl) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_TokenServerURLKeyRequired());
            }
            try {
                new URL(tokenServerUrl);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_NotAValidURL());
            }
        }

        @RequirePOST
        public FormValidation doCheckTokenAuthMethod(@QueryParameter String tokenAuthMethod) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)tokenAuthMethod) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_TokenAuthMethodRequired());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckAuthorizationServerUrl(@QueryParameter String authorizationServerUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (authorizationServerUrl == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_TokenServerURLKeyRequired());
            }
            try {
                new URL(authorizationServerUrl);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_NotAValidURL());
            }
        }

        @RequirePOST
        public FormValidation doCheckUserNameField(@QueryParameter String userNameField) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)userNameField) == null) {
                return FormValidation.ok((String)Messages.OicSecurityRealm_UsingDefaultUsername());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckScopes(@QueryParameter String scopes) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)scopes) == null) {
                return FormValidation.ok((String)Messages.OicSecurityRealm_UsingDefaultScopes());
            }
            if (!scopes.toLowerCase().contains("openid")) {
                return FormValidation.warning((String)Messages.OicSecurityRealm_RUSureOpenIdNotInScope());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckOverrideScopes(@QueryParameter String overrideScopes) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)overrideScopes) == null) {
                return FormValidation.ok((String)Messages.OicSecurityRealm_UsingDefaultScopes());
            }
            if (!overrideScopes.toLowerCase().contains("openid")) {
                return FormValidation.warning((String)Messages.OicSecurityRealm_RUSureOpenIdNotInScope());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckEndSessionEndpoint(@QueryParameter String endSessionEndpoint) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)endSessionEndpoint) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_EndSessionURLKeyRequired());
            }
            try {
                new URL(endSessionEndpoint);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_NotAValidURL());
            }
        }

        @RequirePOST
        public FormValidation doCheckPostLogoutRedirectUrl(@QueryParameter String postLogoutRedirectUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)postLogoutRedirectUrl) != null) {
                try {
                    new URL(postLogoutRedirectUrl);
                    return FormValidation.ok();
                }
                catch (MalformedURLException e) {
                    return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_NotAValidURL());
                }
            }
            return FormValidation.ok();
        }
    }

    static enum PlaceHolder {
        ABSENT;

    }

    public static enum TokenAuthMethod {
        client_secret_basic,
        client_secret_post;

    }
}

