/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class InvalidXmlInputStream
extends ProxyInputStream {
    private final byte replacement;

    public InvalidXmlInputStream(InputStream delegate, char replacement) {
        super(delegate);
        this.replacement = (byte)replacement;
    }

    private boolean isValid(int input) {
        return input == 9 || input == 10 || input == 13 || input >= 32 && input <= 55295 || input >= 57344 && input <= 65533 || input >= 65536 && input <= 0x10FFFF;
    }

    public int read() throws IOException {
        int read = super.read();
        if (read >= 0 && !this.isValid(read)) {
            return this.replacement;
        }
        return read;
    }

    public int read(byte[] cbuf, int off, int len) throws IOException {
        int read = super.read(cbuf, off, len);
        if (read == -1) {
            return -1;
        }
        int pos = off - 1;
        for (int readPos = off; readPos < off + read; ++readPos) {
            if (!this.isValid(cbuf[readPos])) {
                cbuf[readPos] = this.replacement;
            }
            ++pos;
        }
        return pos - off + 1;
    }
}

